/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.configurations.PipelineBuilderConstants;
import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.cli.main.PipelineBuilderCLI;
import de.julielab.jcore.pipeline.builder.cli.menu.BackMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.ComponentSelectionMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.AbstractComponentSelectionDialog;
import de.julielab.jcore.pipeline.builder.cli.util.MenuItemExecutionException;
import de.julielab.jcore.pipeline.builder.cli.util.StatusPrinter;
import java.util.Deque;
import java.util.EnumSet;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;

public class ActivationDialog
extends AbstractComponentSelectionDialog {
    @Override
    public IMenuItem executeMenuItem(JCoReUIMAPipeline pipeline, TextIO textIO, Deque<String> path) throws MenuItemExecutionException {
        this.init(pipeline, EnumSet.of(PipelineBuilderConstants.JcoreMeta.Category.multiplier, PipelineBuilderConstants.JcoreMeta.Category.ae, PipelineBuilderConstants.JcoreMeta.Category.consumer, PipelineBuilderConstants.JcoreMeta.Category.flowcontroller));
        this.printPosition(textIO, path);
        StatusPrinter.printPipelineStatus(pipeline, PipelineBuilderCLI.statusVerbosity, textIO);
        IMenuItem choice = (IMenuItem)((GenericInputReader)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(this.itemList)).withDefaultValue(BackMenuItem.get())).read("\nChoose a component.");
        this.clearTerminal(textIO);
        if (choice instanceof ComponentSelectionMenuItem) {
            Description description;
            description.setActive(!(description = ((ComponentSelectionMenuItem)choice).getDescription()).isActive());
        } else if (choice instanceof ActivateAllMenuItem) {
            this.itemList.stream().filter(ComponentSelectionMenuItem.class::isInstance).map(ComponentSelectionMenuItem.class::cast).map(ComponentSelectionMenuItem::getDescription).forEach(d -> d.setActive(true));
        } else if (choice instanceof DeactivateAllMenuItem) {
            this.itemList.stream().filter(ComponentSelectionMenuItem.class::isInstance).map(ComponentSelectionMenuItem.class::cast).map(ComponentSelectionMenuItem::getDescription).forEach(d -> d.setActive(false));
        }
        return choice;
    }

    @Override
    protected void init(JCoReUIMAPipeline pipeline, EnumSet<PipelineBuilderConstants.JcoreMeta.Category> categories) {
        super.init(pipeline, categories);
        this.itemList.remove(this.itemList.size() - 1);
        this.itemList.add(new ActivateAllMenuItem());
        this.itemList.add(new DeactivateAllMenuItem());
        this.itemList.add(BackMenuItem.get());
    }

    @Override
    public String getName() {
        return "Manage Component Activation Status";
    }

    private static class DeactivateAllMenuItem
    implements IMenuItem {
        private DeactivateAllMenuItem() {
        }

        @Override
        public String getName() {
            return "Deactivate all";
        }

        public String toString() {
            return this.getName();
        }
    }

    private static class ActivateAllMenuItem
    implements IMenuItem {
        private ActivateAllMenuItem() {
        }

        @Override
        public String getName() {
            return "Activate all";
        }

        public String toString() {
            return this.getName();
        }
    }
}

