/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu;

import de.julielab.jcore.pipeline.builder.cli.menu.dialog.IMenuDialog;
import de.julielab.jcore.pipeline.builder.cli.util.PrintLine;
import de.julielab.jcore.pipeline.builder.cli.util.TextIOUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.resource.ConfigurableDataResourceSpecifier;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.IntInputReader;
import org.beryx.textio.TextIO;

public class MultiValuedParameterEditingMenuItem
implements IMenuDialog {
    private final ResourceSpecifier descriptor;
    private final ConfigurationParameter parameter;

    public MultiValuedParameterEditingMenuItem(ResourceSpecifier description, ConfigurationParameter parameter) {
        this.descriptor = description;
        this.parameter = parameter;
    }

    public ConfigurationParameter getParameter() {
        return this.parameter;
    }

    public void setParameterValue(TextIO textIO) {
        String response;
        ResourceMetaData md;
        Stream<PrintLine> lineStream = Stream.empty();
        lineStream = !StringUtils.isBlank(this.parameter.getDescription()) ? Stream.concat(lineStream, Stream.of(TextIOUtils.createPrintLine("The parameter description is:", "header"), TextIOUtils.createPrintLine(this.parameter.getDescription(), "default"))) : Stream.concat(lineStream, Stream.of(TextIOUtils.createPrintLine("No parameter description is available.", "default")));
        TextIOUtils.printLines(lineStream, textIO);
        if (this.descriptor instanceof ResourceCreationSpecifier) {
            md = ((ResourceCreationSpecifier)this.descriptor).getMetaData();
        } else if (this.descriptor instanceof ConfigurableDataResourceSpecifier) {
            md = ((ConfigurableDataResourceSpecifier)this.descriptor).getMetaData();
        } else {
            throw new IllegalArgumentException("Unhandled descriptor type " + this.descriptor.getClass().getCanonicalName() + ". This type must be explicitly handled in the code, contact the developer.");
        }
        Object[] array = (Object[])md.getConfigurationParameterSettings().getParameterValue(this.parameter.getName());
        if (array == null) {
            array = new Object[]{};
        }
        this.printCurrentValues(array, textIO);
        do {
            switch (response = (String)((GenericInputReader)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues("Add element", "Remove element", "Back")).withDefaultValue("Back")).read("Select an action:")) {
                case "Add element": {
                    while ((array = this.addValue(array, textIO)) != null) {
                        md.getConfigurationParameterSettings().setParameterValue(this.parameter.getName(), array);
                        this.printCurrentValues(array, textIO);
                    }
                    array = (Object[])md.getConfigurationParameterSettings().getParameterValue(this.parameter.getName());
                    break;
                }
                case "Remove element": {
                    Integer toRemove;
                    do {
                        if ((toRemove = (Integer)((IntInputReader)((IntInputReader)((IntInputReader)textIO.newIntInputReader().withMinVal(0)).withMaxVal(array.length)).withDefaultValue(0)).read("Select an item to remove or 0 for none:")) <= 0) continue;
                        ArrayList<Object> objList = new ArrayList<Object>(Arrays.asList(array));
                        objList.remove(toRemove - 1);
                        array = objList.toArray(new Object[0]);
                        md.getConfigurationParameterSettings().setParameterValue(this.parameter.getName(), array);
                        this.printCurrentValues(array, textIO);
                    } while (toRemove > 0);
                }
            }
        } while (!response.equals("Back"));
    }

    private void printCurrentValues(Object[] array, TextIO textIO) {
        if (array.length > 0) {
            String ls = System.getProperty("line.separator");
            StringBuilder sb = new StringBuilder();
            sb.append("Current parameter values:");
            sb.append(ls);
            for (int i = 0; i < array.length; ++i) {
                Object o = array[i];
                sb.append(i + 1).append(": ");
                sb.append(o.toString());
                sb.append(ls);
            }
            textIO.getTextTerminal().print(sb.toString());
        } else {
            textIO.getTextTerminal().println("The parameter has currently no values.");
        }
    }

    private Object[] addValue(Object[] array, TextIO textIO) {
        Object newElement;
        Object[] newArray;
        String prompt = "Specify new parameter value. Enter empty value to end input:";
        int length = array != null ? array.length + 1 : 1;
        String input = (String)textIO.newStringInputReader().withMinLength(0).read(prompt);
        if (input.isEmpty()) {
            return null;
        }
        switch (this.parameter.getType()) {
            case "Boolean": {
                newArray = new Boolean[length];
                newElement = Boolean.parseBoolean(input);
                break;
            }
            case "Float": {
                newArray = new Double[length];
                newElement = Double.parseDouble(input);
                break;
            }
            case "Integer": {
                newArray = new Integer[length];
                newElement = Integer.parseInt(input);
                break;
            }
            case "String": {
                newArray = new String[length];
                newElement = input;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported parameter type: " + this.parameter.getType());
            }
        }
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = newElement;
        return newArray;
    }

    @Override
    public String getName() {
        return this.parameter.getName();
    }

    public String toString() {
        return this.getName();
    }
}

