/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu;

import de.julielab.java.utilities.prerequisites.PrerequisiteChecker;
import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.utilities.aether.AetherUtilities;
import de.julielab.utilities.aether.MavenArtifact;
import de.julielab.utilities.aether.MavenException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.beryx.textio.StringInputReader;
import org.beryx.textio.TextIO;

public class ArtifactVersionMenuItem
implements IMenuItem {
    private final Description description;

    public ArtifactVersionMenuItem(Description description) {
        this.description = description;
    }

    public void selectVersion(TextIO textIO, JCoReUIMAPipeline pipeline) {
        PrerequisiteChecker.checkThat().notNull(this.description).supplyNotNull(() -> this.description.getMetaDescription()).supplyNotNull(() -> this.description.getMetaDescription().getMavenArtifactCoordinates()).withNames("Description", "MetaDescription", "MavenArtifactCoordinates").execute();
        MavenArtifact artifact = this.description.getMetaDescription().getMavenArtifactCoordinates();
        try {
            List versionList = AetherUtilities.getVersions(artifact).collect(Collectors.toList());
            if (versionList.isEmpty()) {
                textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.print("No versions available for component " + this.description.getName() + ", Maven artifact " + artifact));
                return;
            }
            Collections.reverse(versionList);
            int currentVersionIndex = versionList.indexOf(artifact.getVersion());
            String selectedVersion = (String)((StringInputReader)((StringInputReader)textIO.newStringInputReader().withNumberedPossibleValues(versionList)).withDefaultValue((String)versionList.get(currentVersionIndex >= 0 ? currentVersionIndex : 0))).read("These are the available versions for the component " + this.description.getName() + ":");
            pipeline.getMavenComponentArtifacts().filter(a -> a.getArtifactId().equalsIgnoreCase(artifact.getArtifactId()) && a.getGroupId().equalsIgnoreCase(artifact.getGroupId()) && (a.getClassifier() == null && artifact.getClassifier() == null || a.getClassifier().equalsIgnoreCase(artifact.getClassifier())) && a.getPackaging().equalsIgnoreCase(artifact.getPackaging())).forEach(a -> a.setVersion(selectedVersion));
        }
        catch (MavenException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return this.description.getName();
    }
}

