/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.base.main;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.jcore.pipeline.builder.base.configurations.PipelineBuilderConstants;
import de.julielab.jcore.pipeline.builder.base.connectors.GitHubConnector;
import de.julielab.jcore.pipeline.builder.base.exceptions.DescriptorLoadingException;
import de.julielab.jcore.pipeline.builder.base.exceptions.GithubInformationException;
import de.julielab.jcore.pipeline.builder.base.interfaces.IComponentMetaInformationService;
import de.julielab.jcore.pipeline.builder.base.main.ComponentRepository;
import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.base.main.GitHubRepository;
import de.julielab.jcore.pipeline.builder.base.main.MetaDescription;
import de.julielab.jcore.pipeline.builder.base.main.Repositories;
import de.julielab.utilities.aether.AetherUtilities;
import de.julielab.utilities.aether.MavenArtifact;
import de.julielab.utilities.aether.MavenException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.JsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentMetaInformationService
implements IComponentMetaInformationService,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ComponentMetaInformationService.class);
    private static ComponentMetaInformationService instance;
    private final String mvnLocal;
    private final Map<String, MetaDescription> metaInformation = new HashMap<String, MetaDescription>();
    private final Set<MavenArtifact> mavenDependencies = new HashSet<MavenArtifact>();

    private ComponentMetaInformationService() {
        this.mvnLocal = Paths.get(System.getProperty("user.home"), PipelineBuilderConstants.Maven.LOCAL_REPO).toString();
    }

    public static ComponentMetaInformationService getInstance() {
        if (instance == null) {
            instance = new ComponentMetaInformationService();
        }
        return instance;
    }

    @Override
    public void completeReload() throws GithubInformationException, MavenException {
        this.metaInformation.clear();
        this.mavenDependencies.clear();
        this.loadComponentMetaInformation(true);
        this.loadAllArtifacts();
    }

    @Override
    public void loadMetaInformationFromDisk(ComponentRepository repository) throws GithubInformationException {
        logger.debug("Loading JCoRe component meta information from local file cache for repository {}.", (Object)repository);
        Object eMessage = null;
        BufferedInputStream infile = null;
        File metaFile = Repositories.getMetaFile(repository);
        logger.trace("Loading component meta description file {} for module {}:{}", metaFile, repository.getName(), repository.getVersion());
        System.out.println(metaFile.getAbsolutePath());
        try {
            infile = FileUtilities.getInputStreamFromFile(metaFile);
            ObjectMapper objectMapper = new ObjectMapper();
            List<MetaDescription> asList = objectMapper.readValue((InputStream)infile, new TypeReference<List<MetaDescription>>(){});
            asList.forEach(md -> this.metaInformation.put(md.getName(), (MetaDescription)md));
            asList.forEach(md -> md.setModule(repository));
            if (logger.isTraceEnabled()) {
                asList.stream().map(MetaDescription::getName).forEach(name -> logger.trace("Loading meta description of {}", name));
            }
        }
        catch (MismatchedInputException | JsonException e) {
            try {
                ((InputStream)infile).close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            logger.info("JsonException while trying to read a stored meta information file. Reloading from GitHub.");
            logger.debug("The exception was", e);
            this.loadComponentMetaInformation(true, repository);
        }
        catch (IOException e) {
            throw new GithubInformationException(e);
        }
        if (eMessage != null) {
            logger.error(String.format("Could not load MetaInformation for %s-%s: %s", repository, eMessage));
        }
    }

    public void loadComponentMetaInformation(Boolean loadNew, ComponentRepository repository) throws GithubInformationException {
        logger.trace("Loading component meta data for repository {}:{}. The parameter 'loadNew' is set to {}", repository.getName(), repository.getVersion(), loadNew);
        try {
            if (!(loadNew.booleanValue() && repository.isUpdateable() || !Repositories.getMetaFile(repository).exists())) {
                this.loadMetaInformationFromDisk(repository);
            } else {
                logger.debug("Loading JCoRe component meta information from GitHub.");
                Map<String, MetaDescription> jc = GitHubConnector.getComponents((GitHubRepository)repository, true);
                for (String key : jc.keySet()) {
                    MetaDescription metaDescription = jc.get(key);
                    metaDescription.setModule(repository);
                    logger.trace("Loaded component {}", (Object)metaDescription);
                    this.metaInformation.put(key, metaDescription);
                }
                Repositories.saveMetaInformationToDisk(repository);
            }
        }
        catch (IOException e) {
            throw new GithubInformationException(e);
        }
    }

    @Override
    public void loadComponentMetaInformation(Boolean loadNew) throws GithubInformationException {
        this.metaInformation.clear();
        List<ComponentRepository> gitHubRepositories = this.getRepositories();
        for (ComponentRepository gitHubRepository : gitHubRepositories) {
            this.loadComponentMetaInformation(loadNew, gitHubRepository);
        }
    }

    public List<ComponentRepository> getRepositories() {
        return Repositories.getRepositories().collect(Collectors.toList());
    }

    @Override
    public List<MavenArtifact> downloadArtifacts(List<MavenArtifact> artifactIds) throws MavenException {
        logger.debug("Retrieving the Maven artifacts for {} components", (Object)artifactIds.size());
        ArrayList<MavenArtifact> resolvedArtifacts = new ArrayList<MavenArtifact>();
        for (MavenArtifact artifactId : artifactIds) {
            if (this.mavenDependencies.contains(artifactId)) continue;
            try {
                MavenArtifact resolvedArtifact = AetherUtilities.getArtifactByAether(artifactId, new File(this.mvnLocal));
                resolvedArtifacts.add(resolvedArtifact);
            }
            catch (MavenException e) {
                resolvedArtifacts.add(null);
                throw e;
            }
        }
        return resolvedArtifacts;
    }

    @Override
    public Set<MavenArtifact> loadAllArtifacts() throws GithubInformationException, MavenException {
        ArrayList<MavenArtifact> dlList = new ArrayList<MavenArtifact>();
        if (this.mavenDependencies.isEmpty()) {
            for (MetaDescription jobj : this.getMetaInformation()) {
                MavenArtifact mvnArtifact = jobj.getMavenArtifact();
                dlList.add(mvnArtifact);
            }
            this.downloadArtifacts(dlList);
        }
        return this.mavenDependencies;
    }

    @Override
    public Set<MavenArtifact> getArtifacts() throws GithubInformationException {
        return this.mavenDependencies;
    }

    @Override
    public Collection<MetaDescription> getMetaInformation(ComponentRepository repository) throws GithubInformationException {
        return this.metaInformation.values().stream().filter(md -> md.getModule().getName().equals(repository.getName())).collect(Collectors.toList());
    }

    @Override
    public Collection<MetaDescription> getMetaInformation() throws GithubInformationException {
        return this.getMetaInformation(false);
    }

    @Override
    public Collection<MetaDescription> getMetaInformationWithArtifacts(Boolean loadNew) throws GithubInformationException, MavenException {
        this.getMetaInformation(loadNew);
        this.loadAllArtifacts();
        return this.getMetaInformation(false).stream().filter(md -> this.mavenDependencies.contains(md.getMavenArtifact())).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public MetaDescription getMetaInformation(String componentName) throws GithubInformationException {
        return this.getMetaInformation(componentName, false);
    }

    @Override
    public Collection<MetaDescription> getMetaInformation(Boolean loadNew) throws GithubInformationException {
        if (this.metaInformation.isEmpty() || loadNew.booleanValue()) {
            this.loadComponentMetaInformation(loadNew);
        }
        return this.metaInformation.values();
    }

    @Override
    public MetaDescription getMetaInformation(String componentName, Boolean loadNew) throws GithubInformationException {
        if (this.metaInformation.isEmpty() || loadNew.booleanValue()) {
            this.loadComponentMetaInformation(loadNew);
        }
        return this.metaInformation.getOrDefault(componentName, null);
    }

    @Override
    public String getName(String componentName) throws GithubInformationException {
        return this.getMetaInformation(componentName).getName();
    }

    @Override
    public String[] getDescriptors(String componentName) throws GithubInformationException, DescriptorLoadingException {
        MetaDescription jobj = this.getMetaInformation(componentName);
        return (String[])jobj.getJCoReDescriptions().stream().map(Description::getLocation).toArray(String[]::new);
    }

    @Override
    public List<String> getCategory(String componentName) throws GithubInformationException {
        return this.getMetaInformation(componentName).getCategories().stream().map(Enum::name).collect(Collectors.toList());
    }

    @Override
    public String getGroups(String componentName) throws GithubInformationException {
        return this.getMetaInformation(componentName).getGroup();
    }
}

