/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities.classpath;

import de.julielab.java.utilities.IOStreamUtilities;
import de.julielab.java.utilities.classpath.Agent;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.bytebuddy.agent.ByteBuddyAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarLoader {
    private static final Logger log = LoggerFactory.getLogger(JarLoader.class);
    private static File AGENT_JAR;

    public static void addJarToClassPath(File jarFile) {
        if (JarLoader.isJavaVersionAbove8()) {
            if (AGENT_JAR == null) {
                JarLoader.findAgentJar();
            }
            String processId = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
            if (AGENT_JAR != null) {
                ByteBuddyAgent.attach(AGENT_JAR, String.valueOf(processId), jarFile.getPath());
            }
        } else {
            try {
                JarLoader.loadLibraryWithURLClassloader(jarFile);
            }
            catch (Exception e) {
                log.error("Could not add {} to the classloader: {}", (Object)jarFile, (Object)e);
            }
        }
    }

    public static synchronized void loadLibraryWithURLClassloader(File jar) {
        try {
            URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            URL url = jar.toURI().toURL();
            for (URL it : loader.getURLs()) {
                if (!it.equals(url)) continue;
                return;
            }
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)loader, url);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean isJavaVersionAbove8() {
        String version2 = System.getProperty("java.version");
        return !version2.startsWith("1.");
    }

    private static synchronized void findAgentJar() {
        File jarFilePath;
        File propFile;
        File jarLocation = null;
        if (System.getProperty("de.julielab.jarloader.agent") != null && (propFile = new File(System.getProperty("de.julielab.jarloader.agent"))).exists()) {
            jarLocation = propFile;
        }
        String nameOfLibraryJar = "julielab-java-utilities";
        String classpath = System.getProperty("java.class.path");
        String[] classpathEntries = classpath.split(File.pathSeparator);
        if (jarLocation == null) {
            try {
                Optional<String> any = IOStreamUtilities.getLinesFromInputStream(JarLoader.class.getResourceAsStream("/jarname.txt")).stream().filter(l -> !l.trim().isEmpty()).findAny();
                if (!any.isPresent()) {
                    throw new IOException();
                }
                nameOfLibraryJar = any.get();
                log.debug("Found JAR name of the julielab-java-utilities through the jarname.txt file to be {}", (Object)nameOfLibraryJar);
            }
            catch (IOException e2) {
                log.warn("Loading of the JAR name for the julielab-java-utilities from the file jarname.txt that should be included in the very same JAR failed. It will still be tried to find the JAR from the classpath but it may fail, resulting in the inability to load JARs at runtime.");
            }
            String finalLibName = nameOfLibraryJar;
            Optional<String> jarOpt = Stream.of(classpathEntries).filter(e -> e.contains(finalLibName)).findAny();
            if (jarOpt.isPresent()) {
                jarLocation = new File(jarOpt.get());
                log.debug("Found location julielab-java-utilities JAR on the classpath as {}", (Object)jarLocation);
            }
        }
        if (jarLocation == null) {
            jarLocation = new File("target/" + nameOfLibraryJar);
            if (!jarLocation.exists()) {
                jarLocation = null;
            } else {
                log.debug("Found location julielab-java-utilities JAR in the target/ directory to be {}", (Object)jarLocation);
            }
        }
        if (jarLocation == null) {
            try {
                jarFilePath = new File(JarLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                if (JarLoader.checkForAgentClassInJarManifest(jarFilePath)) {
                    jarLocation = jarFilePath;
                    log.debug("Found that the class {} resides within a JAR on the classpath: {}", (Object)Agent.class.getCanonicalName(), (Object)jarLocation);
                }
            }
            catch (SecurityException | URISyntaxException e3) {
                log.debug("Exception when trying to resolve the JAR location for the JarLoader Agent using the protection domain.", e3);
            }
        }
        if (jarLocation == null && classpathEntries.length == 1 && classpathEntries[0].endsWith(".jar") && JarLoader.checkForAgentClassInJarManifest(jarFilePath = new File(classpathEntries[0]))) {
            jarLocation = jarFilePath;
            log.debug("Found that the class {} resides within the package JAR containing the whole program ('uber-JAR') at {}", (Object)Agent.class.getCanonicalName(), (Object)jarLocation);
        }
        if (jarLocation != null && jarLocation.exists()) {
            AGENT_JAR = jarLocation;
        } else {
            log.error("Unable to find julielab-java-utilities JAR or the correct Agent-Class manifest entry on the classpath. Runtime loading of JAR files will not work.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkForAgentClassInJarManifest(File jarFilePath) {
        try (ZipFile zipFile = new ZipFile(jarFilePath);){
            List<String> manifestLines;
            Optional<String> agentLine;
            ZipEntry zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
            if (zipEntry != null && (agentLine = (manifestLines = IOStreamUtilities.getLinesFromInputStream(zipFile.getInputStream(zipEntry))).stream().filter(line -> line.contains("Agent-Class:") && line.contains(Agent.class.getCanonicalName())).findAny()).isPresent()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            log.debug("Exception when trying to resolve the JAR location for the JarLoader Agent using the single JAR file on the classpath.", e);
        }
        log.debug("There is only a single JAR file on the classpath indicating that the current program is packaged as one single JAR. However, the manifest of this JAR does not specify the Agent required for runtime classpath additions. Add the entry 'Agent-Class: " + Agent.class.getCanonicalName() + "' to the manifest to enable the ability to add elements to the classpath on runtime.");
        return false;
    }
}

