/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;

public class IOStreamUtilities {
    public static BufferedReader getReaderFromInputStream(InputStream is) {
        return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public static List<String> getLinesFromInputStream(InputStream is) throws IOException {
        try (BufferedReader br = IOStreamUtilities.getReaderFromInputStream(is);){
            List<String> list = br.lines().collect(Collectors.toList());
            return list;
        }
    }

    public static String getStringFromInputStream(InputStream is) throws IOException {
        try {
            String string;
            try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
                int length;
                byte[] buffer = new byte[8192];
                while ((length = is.read(buffer)) != -1) {
                    result.write(buffer, 0, length);
                }
                string = result.toString("UTF-8");
            }
            return string;
        }
        finally {
            is.close();
        }
    }
}

