/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.util;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import de.julielab.jcore.pipeline.builder.base.main.ComponentRepository;
import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.base.main.MetaDescription;
import de.julielab.jcore.pipeline.builder.cli.util.PrintLine;
import de.julielab.jcore.pipeline.builder.cli.util.TextIOUtils;
import de.julielab.utilities.aether.MavenArtifact;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.resource.ConfigurableDataResourceSpecifier;
import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.FileResourceSpecifier;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ExternalResourceBinding;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.impl.NameValuePair_impl;
import org.beryx.textio.TextIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPrinter {
    private static final Logger log = LoggerFactory.getLogger(StatusPrinter.class);

    public static void printComponentStatus(Description description, Verbosity verbosity, TextIO textIO) {
        List<PrintLine> records = StatusPrinter.getComponentStatusRecords(description, verbosity);
        TextIOUtils.printLines(records.stream(), textIO);
    }

    public static void printComponentStatus(Description description, TextIO textIO) {
        StatusPrinter.printComponentStatus(description, Verbosity.BRIEF, textIO);
    }

    public static void printComponentMetaData(MetaDescription metaDescription, TextIO textIO) {
        String name = metaDescription.getName();
        ComponentRepository module = metaDescription.getModule();
        TextIOUtils.printLines(Stream.of(TextIOUtils.createPrintLine("Component Name: ", "fixed", name, "default"), TextIOUtils.createPrintLine("Component Module: ", "fixed", module != null ? module.getName() : "<unknown>", "default")), textIO);
    }

    public static void printComponentMetaData(Description description, TextIO textIO) {
        StatusPrinter.printComponentMetaData(description.getMetaDescription(), textIO);
    }

    private static List<PrintLine> getComponentStatusRecords(Description description, Verbosity verbosity) {
        ArrayList<PrintLine> records = new ArrayList<PrintLine>();
        if (!description.getMetaDescription().isPear().booleanValue()) {
            DescriptorStatusLineCreator descriptorStatusLineCreator = new DescriptorStatusLineCreator(records, verbosity);
            ExternalResourcesAdder externalResourcesAdderAdder = new ExternalResourcesAdder(records, verbosity);
            descriptorStatusLineCreator.accept(description);
            if (description.getDescriptor() instanceof AnalysisEngineDescription) {
                externalResourcesAdderAdder.accept(description);
            }
        } else {
            Function<String, String> color = str -> description.isActive() ? str : "deactivatedcomponent";
            records.add(TextIOUtils.createPrintLine("  - " + description.getName(), color.apply("componentname")));
            records.add(TextIOUtils.createPrintLine("    This is a PEAR and thus not configurable.", color.apply("param")));
            records.add(TextIOUtils.createPrintLine("    Path: " + description.getLocation(), color.apply("param")));
        }
        return records;
    }

    public static void printPipelineStatus(JCoReUIMAPipeline pipeline, Verbosity verbosity, TextIO textIO) {
        List<PrintLine> records = StatusPrinter.getPipelineStatusRecords(pipeline, verbosity);
        TextIOUtils.printLines(records.stream(), textIO);
    }

    private static List<PrintLine> getPipelineStatusRecords(JCoReUIMAPipeline pipeline, Verbosity verbosity) {
        ArrayList<PrintLine> records = new ArrayList<PrintLine>();
        DescriptorStatusLineCreator descriptorStatusLineCreator = new DescriptorStatusLineCreator(records, verbosity);
        records.add(TextIOUtils.createPrintLine("Collection Reader:", "header"));
        if (pipeline.getCrDescription() != null) {
            descriptorStatusLineCreator.accept(pipeline.getCrDescription());
        } else {
            records.add(TextIOUtils.createPrintLine("    none", "empty"));
        }
        if (pipeline.getCmDelegates() != null && !pipeline.getCmDelegates().isEmpty()) {
            records.add(TextIOUtils.createPrintLine("CAS Multipliers:", "header"));
            pipeline.getCmDelegates().stream().map(d -> StatusPrinter.getComponentStatusRecords(d, d.isActive() ? verbosity : Verbosity.MINIMAL)).forEach(records::addAll);
        }
        records.add(TextIOUtils.createPrintLine("Analysis Engines:", "header"));
        if (pipeline.getAeDelegates() == null || pipeline.getAeDelegates().isEmpty()) {
            records.add(TextIOUtils.createPrintLine("    none", "empty"));
        } else {
            if (pipeline.getAeFlowController() != null) {
                records.addAll(StatusPrinter.getComponentStatusRecords(pipeline.getAeFlowController(), verbosity));
            }
            pipeline.getAeDelegates().stream().map(d -> StatusPrinter.getComponentStatusRecords(d, d.isActive() ? verbosity : Verbosity.MINIMAL)).forEach(records::addAll);
        }
        if (pipeline.getCcDelegates() != null && !pipeline.getCcDelegates().isEmpty()) {
            records.add(TextIOUtils.createPrintLine("CAS Consumers:", "header"));
            if (pipeline.getCcFlowController() != null) {
                records.addAll(StatusPrinter.getComponentStatusRecords(pipeline.getCcFlowController(), verbosity));
            }
            pipeline.getCcDelegates().stream().map(d -> StatusPrinter.getComponentStatusRecords(d, d.isActive() ? verbosity : Verbosity.MINIMAL)).forEach(records::addAll);
        }
        Stream cmStream = pipeline.getCmDelegates() != null ? pipeline.getCmDelegates().stream() : Stream.empty();
        Stream aeStream = pipeline.getAeDelegates() != null ? pipeline.getAeDelegates().stream() : Stream.empty();
        Stream ccStream = pipeline.getCcDelegates() != null ? pipeline.getCcDelegates().stream() : Stream.empty();
        Stream<Description> aes = Stream.concat(Stream.concat(cmStream, aeStream), ccStream).filter(d -> d.getDescriptor() instanceof AnalysisEngineDescription);
        Map<String, List<ExternalResourceDescription>> resourcesByName = aes.filter(ae -> ae.isActive()).map(Description::getDescriptorAsAnalysisEngineDescription).filter(ae -> ae.getResourceManagerConfiguration() != null).filter(ae -> ae.getResourceManagerConfiguration() != null).flatMap(ae -> Stream.of(ae.getResourceManagerConfiguration().getExternalResources())).collect(Collectors.groupingBy(ExternalResourceDescription::getName));
        resourcesByName.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).forEach(e -> records.add(TextIOUtils.createPrintLine("Configuration error: There are multiple external resources with the name " + (String)e.getKey() + ".\n    Go to the configuration dialog and adapt the names.", "error")));
        Multiset existingDescriptorNames = pipeline.getExistingDescriptorNames();
        for (String name : existingDescriptorNames.elementSet()) {
            int count = existingDescriptorNames.count((Object)name);
            if (count <= 1) continue;
            records.add(TextIOUtils.createPrintLine("Configuration error: There are " + count + " components with the name '" + name + "'. Component names must be unique.", "error"));
        }
        LinkedHashMultimap component2unsatisfiedTypeCapability = LinkedHashMultimap.create();
        HashSet existingOutputCapability = new HashSet();
        if (pipeline.getCrDescription() != null) {
            pipeline.getCrDescription().getOutputCapabilities().forEach(existingOutputCapability::add);
        }
        pipeline.getCmDelegates().stream().flatMap(d -> d.getOutputCapabilities().stream()).forEach(existingOutputCapability::add);
        pipeline.getAeDelegates().stream().flatMap(d -> d.getOutputCapabilities().stream()).forEach(existingOutputCapability::add);
        pipeline.getCcDelegates().stream().flatMap(d -> d.getOutputCapabilities().stream()).forEach(existingOutputCapability::add);
        pipeline.getCmDelegates().stream().filter(Description::isActive).forEach(arg_0 -> StatusPrinter.lambda$getPipelineStatusRecords$15(existingOutputCapability, (Multimap)component2unsatisfiedTypeCapability, arg_0));
        pipeline.getAeDelegates().stream().filter(Description::isActive).forEach(arg_0 -> StatusPrinter.lambda$getPipelineStatusRecords$17(existingOutputCapability, (Multimap)component2unsatisfiedTypeCapability, arg_0));
        pipeline.getCcDelegates().stream().filter(Description::isActive).forEach(arg_0 -> StatusPrinter.lambda$getPipelineStatusRecords$19(existingOutputCapability, (Multimap)component2unsatisfiedTypeCapability, arg_0));
        if (!component2unsatisfiedTypeCapability.isEmpty()) {
            records.add(TextIOUtils.createPrintLine("There are unsatisfied input capabilities:", "warn"));
            for (String componentName : component2unsatisfiedTypeCapability.keySet()) {
                records.add(TextIOUtils.createPrintLine("    Component " + componentName + " requires: " + component2unsatisfiedTypeCapability.get((Object)componentName).stream().collect(Collectors.joining(", ")), "default"));
            }
        }
        return records;
    }

    private static /* synthetic */ void lambda$getPipelineStatusRecords$19(Set existingOutputCapability, Multimap component2unsatisfiedTypeCapability, Description cc) {
        cc.getInputCapabilities().stream().filter(Predicate.not(existingOutputCapability::contains)).forEach(capability -> component2unsatisfiedTypeCapability.put((Object)cc.getName(), capability));
    }

    private static /* synthetic */ void lambda$getPipelineStatusRecords$17(Set existingOutputCapability, Multimap component2unsatisfiedTypeCapability, Description ae) {
        ae.getInputCapabilities().stream().filter(Predicate.not(existingOutputCapability::contains)).forEach(capability -> component2unsatisfiedTypeCapability.put((Object)ae.getName(), capability));
    }

    private static /* synthetic */ void lambda$getPipelineStatusRecords$15(Set existingOutputCapability, Multimap component2unsatisfiedTypeCapability, Description cm) {
        cm.getInputCapabilities().stream().filter(Predicate.not(existingOutputCapability::contains)).forEach(capability -> component2unsatisfiedTypeCapability.put((Object)cm.getName(), capability));
    }

    private static class ExternalResourcesAdder
    implements Consumer<Description> {
        private final List<PrintLine> records;
        private final Verbosity verbosity;

        public ExternalResourcesAdder(List<PrintLine> records, Verbosity verbosity) {
            this.records = records;
            this.verbosity = verbosity;
        }

        @Override
        public void accept(Description description) {
            if (this.verbosity.ordinal() > Verbosity.MINIMAL.ordinal()) {
                Function<String, String> color = str -> description.isActive() ? str : "deactivatedcomponent";
                AnalysisEngineDescription desc = description.getDescriptorAsAnalysisEngineDescription();
                ExternalResourceDependency[] externalResourceDependencies = desc.getExternalResourceDependencies();
                if (externalResourceDependencies != null && externalResourceDependencies.length > 0) {
                    this.records.add(TextIOUtils.createPrintLine("    External Resources:", color.apply("header")));
                    Set dependenciesToSatisfy = Stream.of(externalResourceDependencies).map(ExternalResourceDependency::getKey).collect(Collectors.toSet());
                    ResourceManagerConfiguration resourceManagerConfiguration = desc.getResourceManagerConfiguration();
                    HashMap<String, String> bindingMap = new HashMap<String, String>();
                    if (resourceManagerConfiguration != null) {
                        ExternalResourceBinding[] externalResourceBindings = resourceManagerConfiguration.getExternalResourceBindings();
                        bindingMap.putAll(Stream.of(externalResourceBindings).collect(Collectors.toMap(ExternalResourceBinding::getKey, ExternalResourceBinding::getResourceName)));
                    }
                    Stream.of(externalResourceDependencies).forEach(dependency -> {
                        if (bindingMap.keySet().contains(dependency.getKey())) {
                            String resourceName = (String)bindingMap.get(dependency.getKey());
                            this.records.add(TextIOUtils.createPrintLine("    " + dependency.getKey() + ": " + resourceName, (String)color.apply("default")));
                            Optional<ExternalResourceDescription> resDescOpt = Stream.of(desc.getResourceManagerConfiguration().getExternalResources()).filter(res -> res.getName().equals(resourceName)).findFirst();
                            if (resDescOpt.isPresent()) {
                                ExternalResourceDescription resourceDesc = resDescOpt.get();
                                this.records.add(TextIOUtils.createPrintLine("       Name: ", (String)color.apply("fixed"), resourceDesc.getName(), (String)color.apply("default")));
                                this.records.add(TextIOUtils.createPrintLine("       Description: ", (String)color.apply("fixed"), resourceDesc.getDescription(), (String)color.apply("default")));
                                this.records.add(TextIOUtils.createPrintLine("       Implementation: ", (String)color.apply("fixed"), resourceDesc.getImplementationName(), (String)color.apply("default")));
                                String url = null;
                                ResourceSpecifier resourceSpecifier = resourceDesc.getResourceSpecifier();
                                if (resourceSpecifier instanceof FileResourceSpecifier) {
                                    url = ((FileResourceSpecifier)resourceSpecifier).getFileUrl();
                                } else if (resourceSpecifier instanceof ConfigurableDataResourceSpecifier) {
                                    url = ((ConfigurableDataResourceSpecifier)resourceSpecifier).getUrl();
                                }
                                this.records.add(TextIOUtils.createPrintLine("       Resource URL: ", StringUtils.isBlank((String)url) ? (String)color.apply("error") : (String)color.apply("fixed"), url, (String)color.apply("default")));
                                if (resourceSpecifier instanceof ConfigurableDataResourceSpecifier) {
                                    ConfigurableDataResourceSpecifier configurableDataResourceSpecifier = (ConfigurableDataResourceSpecifier)resourceSpecifier;
                                    ConfigurationParameter[] declarations = configurableDataResourceSpecifier.getMetaData().getConfigurationParameterDeclarations().getConfigurationParameters();
                                    Map settings = Stream.of(configurableDataResourceSpecifier.getMetaData().getConfigurationParameterSettings().getParameterSettings()).flatMap(Stream::of).collect(Collectors.toMap(NameValuePair::getName, Function.identity()));
                                    for (ConfigurationParameter declaration : declarations) {
                                        String name = declaration.getName();
                                        Object value = Optional.ofNullable((NameValuePair)settings.get(name)).orElseGet(NameValuePair_impl::new).getValue();
                                        String reportLevel = (String)color.apply("default");
                                        if (declaration.isMandatory() && (value == null || StringUtils.isBlank((String)value.toString()))) {
                                            reportLevel = (String)color.apply("error");
                                        }
                                        String valueString = value != null && !value.getClass().isArray() ? value.toString() : (value != null ? Arrays.toString((Object[])value) : "<setting not defined>");
                                        this.records.add(TextIOUtils.createPrintLine("       " + name + ": ", "param", valueString, reportLevel));
                                    }
                                }
                            }
                        } else {
                            this.records.add(TextIOUtils.createPrintLine("    " + dependency.getKey() + ": <not bound>", (String)color.apply("error")));
                        }
                    });
                }
            }
        }
    }

    private static class DescriptorStatusLineCreator
    implements Consumer<Description> {
        private final List<PrintLine> records;
        private final Verbosity verbosity;

        public DescriptorStatusLineCreator(List<PrintLine> records, Verbosity verbosity) {
            this.records = records;
            this.verbosity = verbosity;
        }

        @Override
        public void accept(Description description) {
            try {
                ResourceCreationSpecifier descriptor = (ResourceCreationSpecifier)description.getDescriptor();
                ResourceMetaData metaData = null;
                if (descriptor != null) {
                    metaData = descriptor.getMetaData();
                } else {
                    log.warn("The description with name {} does not have a UIMA descriptor set", (Object)description.getName());
                }
                String componentName = "<no name set in description or meta data>";
                if (description.getName() != null) {
                    componentName = description.getName();
                } else if (metaData != null) {
                    componentName = metaData.getName();
                }
                Function<String, String> color = str -> description.isActive() ? str : "deactivatedcomponent";
                if (description.isActive()) {
                    this.records.add(TextIOUtils.createPrintLine("  - " + componentName, "componentname"));
                } else {
                    this.records.add(TextIOUtils.createPrintLine("  - " + componentName + " (DEACTIVATED)", "deactivatedcomponent"));
                }
                if (this.verbosity == Verbosity.VERBOSE) {
                    this.records.add(TextIOUtils.createPrintLine("    Input Type Capabilities:  " + String.join((CharSequence)",", description.getCapabilities("in")), color.apply("default")));
                    this.records.add(TextIOUtils.createPrintLine("    Output Type Capabilities: " + String.join((CharSequence)",", description.getCapabilities("out")), color.apply("default")));
                }
                if (this.verbosity.ordinal() > Verbosity.MINIMAL.ordinal()) {
                    this.records.add(TextIOUtils.createPrintLine("    Maven artifact: " + this.getArtifactString(description), color.apply("default")));
                    if (metaData != null) {
                        NameValuePair[] parameterSettings = metaData.getConfigurationParameterSettings().getParameterSettings();
                        Set mandatorySet = Stream.of(metaData.getConfigurationParameterDeclarations().getConfigurationParameters()).filter(ConfigurationParameter::isMandatory).map(ConfigurationParameter::getName).collect(Collectors.toSet());
                        if (parameterSettings != null && parameterSettings.length > 0 || !mandatorySet.isEmpty()) {
                            this.records.add(TextIOUtils.createPrintLine("    Mandatory Parameters:", color.apply("parameters")));
                        }
                        if (parameterSettings != null) {
                            for (NameValuePair parameter : parameterSettings) {
                                if (StringUtils.isBlank((String)parameter.getValue().toString()) || !mandatorySet.remove(parameter.getName()) && this.verbosity.ordinal() <= Verbosity.BRIEF.ordinal()) continue;
                                String valueString = parameter.getValue().getClass().isArray() ? Arrays.toString((Object[])parameter.getValue()) : String.valueOf(parameter.getValue());
                                this.records.add(TextIOUtils.createPrintLine("    " + parameter.getName() + ": ", color.apply("param"), valueString, color.apply("default")));
                            }
                        }
                        for (String notSetMandatoryParameter : mandatorySet) {
                            this.records.add(TextIOUtils.createPrintLine("    " + notSetMandatoryParameter + ": <not set>", color.apply("error")));
                        }
                    } else {
                        this.records.add(TextIOUtils.createPrintLine("Cannot read configuration parameters because no descriptor has been loaded.", color.apply("error")));
                    }
                }
            }
            catch (Throwable t) {
                log.error("Error occurred when trying to write the information for component " + description);
                throw t;
            }
        }

        private String getArtifactString(Description description) {
            MavenArtifact artifact = description.getMetaDescription().getMavenArtifactCoordinates();
            String artifactString = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
            if (artifact.getClassifier() != null) {
                artifactString = artifactString + ":" + artifact.getClassifier();
            }
            return artifactString;
        }
    }

    public static enum Verbosity {
        MINIMAL,
        BRIEF,
        VERBOSE;

    }
}

