/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.cli.menu.ArtifactVersionMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.IMenuDialog;
import de.julielab.jcore.pipeline.builder.cli.util.TextIOUtils;
import de.julielab.utilities.aether.AetherUtilities;
import de.julielab.utilities.aether.MavenArtifact;
import de.julielab.utilities.aether.MavenException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.stream.Stream;
import org.beryx.textio.StringInputReader;
import org.beryx.textio.TextIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateAllArtifactsDialog
implements IMenuDialog {
    private static final Logger log = LoggerFactory.getLogger(UpdateAllArtifactsDialog.class);

    public void execute(JCoReUIMAPipeline pipeline, TextIO textIO) {
        ArrayList<Description> itemList = new ArrayList<Description>();
        if (pipeline.getCrDescription() != null) {
            itemList.add(pipeline.getCrDescription());
        }
        if (pipeline.getCmDelegates() != null && !pipeline.getCmDelegates().isEmpty()) {
            itemList.addAll(pipeline.getCmDelegates());
        }
        if (pipeline.getAeDelegates() != null && !pipeline.getAeDelegates().isEmpty()) {
            itemList.addAll(pipeline.getAeDelegates());
        }
        if (pipeline.getCcDelegates() != null && !pipeline.getCcDelegates().isEmpty()) {
            itemList.addAll(pipeline.getCcDelegates());
        }
        if (itemList.isEmpty()) {
            textIO.getTextTerminal().executeWithPropertiesPrefix("warn", t -> t.print("No components selected yet."));
        }
        String updateAll = "Update all component artifacts to their newest available version";
        String selectManually = "Select the version for each component manually";
        String back = "Back";
        String response = (String)((StringInputReader)((StringInputReader)textIO.newStringInputReader().withNumberedPossibleValues((Object[])new String[]{updateAll, selectManually, back})).withDefaultValue((Object)back)).read(new String[]{"Would you like to update all components at once or select a specific version for each component individually?"});
        if (updateAll.equals(response)) {
            for (Description description : itemList) {
                if (description.getMetaDescription().isPear().booleanValue()) {
                    String msg = "Description \"" + description.getName() + "\" is a PEAR and cannot be updated automatically.";
                    textIO.getTextTerminal().print(msg + "\n");
                    log.info(msg);
                    continue;
                }
                try {
                    String newestVersion = AetherUtilities.getNewestVersion((MavenArtifact)description.getMetaDescription().getMavenArtifactCoordinates());
                    description.getMetaDescription().getMavenArtifactCoordinates().setVersion(newestVersion);
                    textIO.getTextTerminal().print("Set artifact version of component " + description.getName() + " to " + newestVersion + System.getProperty("line.separator"));
                }
                catch (MavenException e) {
                    log.error("Could not set the new version to component {}", (Object)description.getName(), (Object)e);
                }
            }
        } else {
            HashSet<CallSite> alreadySpecifiedArtifacts = new HashSet<CallSite>();
            for (Description description : itemList) {
                MavenArtifact coordinates = description.getMetaDescription().getMavenArtifactCoordinates();
                if (alreadySpecifiedArtifacts.add((CallSite)((Object)(coordinates.getGroupId() + ":" + coordinates.getArtifactId())))) {
                    new ArtifactVersionMenuItem(description).selectVersion(textIO, pipeline);
                    continue;
                }
                TextIOUtils.printLines(Stream.of(TextIOUtils.createPrintLine("Skipping component " + description.getName() + " because the version of the artifact " + coordinates.getGroupId() + ":" + coordinates.getArtifactId() + " has already selected for another component." + System.getProperty("line.separator"), "emphasis")), textIO);
            }
        }
    }

    @Override
    public String getName() {
        return "Update All Artifacts";
    }

    public String toString() {
        return this.getName();
    }
}

