/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import com.google.common.collect.Multiset;
import de.julielab.jcore.pipeline.builder.base.exceptions.PipelineIOException;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.cli.main.PipelineBuilderCLI;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.IMenuDialog;
import java.io.File;
import java.util.Comparator;
import java.util.Deque;
import java.util.Optional;
import org.beryx.textio.BooleanInputReader;
import org.beryx.textio.StringInputReader;
import org.beryx.textio.TextIO;

public class SavePipelineDialog
implements IMenuDialog {
    @Override
    public String getName() {
        return "Save Pipeline";
    }

    public void savePipeline(JCoReUIMAPipeline pipeline, TextIO textIO, Deque<String> path) throws PipelineIOException {
        path.add(this.getName());
        this.printPosition(textIO, path);
        Multiset existingDescriptorNames = pipeline.getExistingDescriptorNames();
        Optional<Integer> max = existingDescriptorNames.stream().map(arg_0 -> ((Multiset)existingDescriptorNames).count(arg_0)).max(Comparator.reverseOrder());
        if (max.isPresent() && max.get() > 1) {
            textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.println("The pipeline cannot be saved because there are multiple components with the same name. Saving the pipeline now would render it invalid and unable to load again."));
        } else {
            String destination;
            PipelineBuilderCLI.pipelinePath = destination = (String)((StringInputReader)textIO.newStringInputReader().withDefaultValue((Object)PipelineBuilderCLI.pipelinePath)).read(new String[]{"Enter the directory to save the pipeline to."});
            File destinationFile = new File(destination);
            boolean store = true;
            boolean storeLibraries = PipelineBuilderCLI.dependenciesHaveChanged;
            if (destinationFile.exists()) {
                Boolean clear;
                Boolean overwrite = (Boolean)((BooleanInputReader)textIO.newBooleanInputReader().withDefaultValue((Object)false)).withFalseInput("N").withTrueInput("Y").read(new String[]{"The path " + destinationFile.getAbsolutePath() + " exists. Do you wish to store to this directory anyway?"});
                if (overwrite.booleanValue() && !PipelineBuilderCLI.dependenciesHaveChanged && (clear = (Boolean)((BooleanInputReader)textIO.newBooleanInputReader().withDefaultValue((Object)false)).withFalseInput("N").withTrueInput("Y").read(new String[]{"Do you want to force to clear and (re-) populate the lib directory? This can be necessary in case the pipeline builder fails to recognize that dependencies have changed."})).booleanValue()) {
                    storeLibraries = true;
                }
                if (!overwrite.booleanValue()) {
                    store = false;
                    textIO.getTextTerminal().println("Aborting.");
                }
            }
            if (store) {
                textIO.getTextTerminal().println("Storing pipeline. It may take a while to gather all transitive dependencies, please wait...");
                pipeline.store(destinationFile, storeLibraries);
                if (storeLibraries) {
                    PipelineBuilderCLI.dependenciesHaveChanged = false;
                }
                textIO.getTextTerminal().println("Saved pipeline to " + destinationFile.getAbsolutePath());
            }
        }
        path.removeLast();
    }

    public String toString() {
        return this.getName();
    }
}

