/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.main.ComponentRepository;
import de.julielab.jcore.pipeline.builder.base.main.Repositories;
import de.julielab.jcore.pipeline.builder.cli.menu.BackMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.MenuItemList;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ILoopableDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.RepositoryAddDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.RepositoryChangeVersionDialog;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;

public class RepositoryManagementDialog
implements ILoopableDialog {
    private final MenuItemList<IMenuItem> itemList = new MenuItemList();

    public RepositoryManagementDialog() {
        this.itemList.add(new RepositoryAddDialog());
        this.itemList.add(new RepositoryChangeVersionDialog());
        this.itemList.add(BackMenuItem.get());
    }

    @Override
    public String getName() {
        return "Manage Component Repositories";
    }

    @Override
    public IMenuItem executeMenuItem(TextIO textIO, Deque<String> path) {
        List repositories = Repositories.getRepositories().collect(Collectors.toList());
        String ls = System.getProperty("line.separator");
        textIO.getTextTerminal().print("The following repositories are currently in use:" + ls);
        for (ComponentRepository repository : repositories) {
            textIO.getTextTerminal().print(repository.getName() + ": " + repository.getVersion() + ls);
        }
        IMenuItem choice = (IMenuItem)((GenericInputReader)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(this.itemList)).withDefaultValue((Object)BackMenuItem.get())).read(new String[]{"Choose an option:"});
        if (choice instanceof ILoopableDialog) {
            ((ILoopableDialog)choice).enterInputLoop(textIO, path);
        }
        return choice;
    }

    public String toString() {
        return this.getName();
    }
}

