/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import com.google.common.collect.Sets;
import de.julielab.jcore.pipeline.builder.base.main.ComponentRepository;
import de.julielab.jcore.pipeline.builder.base.main.Repositories;
import de.julielab.jcore.pipeline.builder.cli.menu.BackMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.NoopMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ILoopableDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.RepositoryCreateDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.RepositorySelectVersionDialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryAddDialog
implements ILoopableDialog {
    private static final Logger log = LoggerFactory.getLogger(RepositoryAddDialog.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMenuItem executeMenuItem(TextIO textIO, Deque<String> path) {
        path.add("Add a repository");
        this.clearTerminal(textIO);
        this.printPosition(textIO, path);
        try {
            Object choice;
            block9: {
                TreeSet currentlyUsed = Repositories.getRepositories().collect(Collectors.toCollection(() -> new TreeSet<ComponentRepository>(Comparator.comparing(ComponentRepository::getName))));
                TreeSet defaultRepositories = Repositories.JCORE_REPOSITORIES.stream().collect(Collectors.toCollection(() -> new TreeSet<ComponentRepository>(Comparator.comparing(ComponentRepository::getName))));
                Sets.SetView unusedDefaultRepositories = Sets.difference((Set)defaultRepositories, (Set)currentlyUsed);
                ArrayList<IMenuItem> items = new ArrayList<IMenuItem>((Collection<IMenuItem>)unusedDefaultRepositories);
                items.add(new RepositoryCreateDialog());
                items.add(BackMenuItem.get());
                List menuItemStrings = items.stream().map(item -> {
                    if (item instanceof ComponentRepository) {
                        return ((ComponentRepository)item).getName();
                    }
                    return item.toString();
                }).collect(Collectors.toList());
                String chosenString = (String)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(menuItemStrings)).read(new String[]{"\nChoose an option to add a default repository or create a new one."});
                choice = items.get(menuItemStrings.indexOf(chosenString));
                try {
                    if (!(choice instanceof ComponentRepository)) break block9;
                    ComponentRepository repo = (ComponentRepository)choice;
                    if (repo.getVersion() == null) {
                        new RepositorySelectVersionDialog(repo).execute(textIO, path);
                        Repositories.addRepositories((ComponentRepository[])new ComponentRepository[]{repo});
                    }
                    NoopMenuItem noopMenuItem = new NoopMenuItem();
                    return noopMenuItem;
                }
                catch (IOException e) {
                    log.error("Could not add the chosen repository", (Throwable)e);
                }
            }
            if (choice instanceof RepositoryCreateDialog) {
                // empty if block
            }
            IMenuItem iMenuItem = (IMenuItem)choice;
            return iMenuItem;
        }
        finally {
            path.pop();
        }
    }

    @Override
    public String getName() {
        return "Add Component Repositories";
    }

    public String toString() {
        return this.getName();
    }
}

