/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.cli.menu.BackMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.IMenuDialog;
import de.julielab.utilities.aether.MavenArtifact;
import java.io.File;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;

public class ParentPomSettingDialog
implements IMenuDialog {
    public void execute(JCoReUIMAPipeline pipeline, TextIO textIO, Deque<String> path) {
        this.clearTerminal(textIO);
        path.add(this.getName());
        this.printPosition(textIO, path);
        String linesep = System.getProperty("line.separator");
        textIO.getTextTerminal().print("Setting a pipeline parent POM is optional and typically only required if some of the employed components exhibit a library version conflict. In this case, a parent POM may specify the version to use in the dependencyManagement section." + linesep);
        String currentPom = pipeline.getParentPom() != null ? pipeline.getParentPom().getGroupId() + ":" + pipeline.getParentPom().getArtifactId() + ":" + pipeline.getParentPom().getVersion() + "(file: " + pipeline.getParentPom().getFile().getAbsolutePath() + ")" : "<none>";
        textIO.getTextTerminal().print("Current parent POM: " + currentPom + linesep);
        List<Object> pomSourceOptions = Arrays.asList("Specify parent through maven coordinates", "Specify parent POM file", BackMenuItem.get());
        Object sourceChoice = ((GenericInputReader)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(pomSourceOptions)).withDefaultValue((Object)BackMenuItem.get())).read(new String[]{"Choose an option:"});
        if (pomSourceOptions.indexOf(sourceChoice) == 0) {
            String groupId = (String)textIO.newStringInputReader().read(new String[]{"Specify the groupId:"});
            String artifactId = (String)textIO.newStringInputReader().read(new String[]{"Specify the artifactId:"});
            String version = (String)textIO.newStringInputReader().read(new String[]{"Specify the version:"});
            MavenArtifact artifact = new MavenArtifact(groupId, artifactId, version);
            artifact.setPackaging("pom");
            pipeline.setParentPom(artifact);
        } else if (pomSourceOptions.indexOf(sourceChoice) == 1) {
            String parentPath = (String)textIO.newStringInputReader().read(new String[]{"Specify the path to the POM file:"});
            MavenArtifact artifact = new MavenArtifact();
            artifact.setFile(new File(parentPath));
            pipeline.setParentPom(artifact);
        }
        path.pop();
    }

    @Override
    public String getName() {
        return "Set pipeline components parent POM";
    }

    public String toString() {
        return this.getName();
    }
}

