/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.configurations.PipelineBuilderConstants;
import de.julielab.jcore.pipeline.builder.base.exceptions.GithubInformationException;
import de.julielab.jcore.pipeline.builder.base.exceptions.PipelineIOException;
import de.julielab.jcore.pipeline.builder.base.main.ComponentMetaInformationService;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.base.main.MetaDescription;
import de.julielab.jcore.pipeline.builder.base.main.Repositories;
import de.julielab.jcore.pipeline.builder.cli.main.PipelineBuilderCLI;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.QuitMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.RefreshComponentRepositoryMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.StorePomMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.AddComponentDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.AddFlowControllerDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ConfigurePipelineDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ILoopablePipelineManipulationDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.LoadPipelineDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ParentPomSettingDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.RepositoryManagementDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.SavePipelineDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.SpecifyStatusVerbosityDialog;
import de.julielab.jcore.pipeline.builder.cli.util.MenuItemExecutionException;
import de.julielab.jcore.pipeline.builder.cli.util.StatusPrinter;
import de.julielab.jcore.pipeline.builder.cli.util.TextIOUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;

public class IndexDialog
implements ILoopablePipelineManipulationDialog {
    public static final QuitMenuItem QUIT_MENU_ITEM = new QuitMenuItem();
    private Map<PipelineBuilderConstants.JcoreMeta.Category, List<MetaDescription>> categoryMap;
    private List<IMenuItem> menuItems;

    public IndexDialog() throws GithubInformationException {
        this.initComponentRepository(false);
    }

    private void initComponentRepository(boolean loadNew) throws GithubInformationException {
        this.categoryMap = new HashMap<PipelineBuilderConstants.JcoreMeta.Category, List<MetaDescription>>();
        ComponentMetaInformationService.getInstance().getMetaInformation(Boolean.valueOf(loadNew)).forEach(md -> {
            for (PipelineBuilderConstants.JcoreMeta.Category category : md.getCategories()) {
                this.categoryMap.compute(category, (k, v) -> {
                    ArrayList<MetaDescription> ret = v;
                    if (ret == null) {
                        ret = new ArrayList<MetaDescription>();
                    }
                    ret.add((MetaDescription)md);
                    return ret;
                });
            }
        });
        this.menuItems = new ArrayList<IMenuItem>();
        this.menuItems.add(new AddComponentDialog(this.categoryMap, PipelineBuilderConstants.JcoreMeta.Category.reader));
        this.menuItems.add(new AddComponentDialog(this.categoryMap, PipelineBuilderConstants.JcoreMeta.Category.multiplier));
        this.menuItems.add(new AddComponentDialog(this.categoryMap, PipelineBuilderConstants.JcoreMeta.Category.ae));
        this.menuItems.add(new AddComponentDialog(this.categoryMap, PipelineBuilderConstants.JcoreMeta.Category.consumer));
        this.menuItems.add(new AddFlowControllerDialog(this.categoryMap));
        this.menuItems.add(new ConfigurePipelineDialog());
        this.menuItems.add(new SavePipelineDialog());
        this.menuItems.add(new LoadPipelineDialog());
        this.menuItems.add(new SpecifyStatusVerbosityDialog());
        this.menuItems.add(new RepositoryManagementDialog());
        this.menuItems.add(new RefreshComponentRepositoryMenuItem());
        this.menuItems.add(new ParentPomSettingDialog());
        this.menuItems.add(new StorePomMenuItem());
        this.menuItems.add(QUIT_MENU_ITEM);
    }

    @Override
    public String getName() {
        return "Index";
    }

    @Override
    public IMenuItem executeMenuItem(JCoReUIMAPipeline pipeline, TextIO textIO, Deque<String> path) {
        IMenuItem choice;
        block20: {
            this.printPosition(textIO, path);
            StatusPrinter.printPipelineStatus(pipeline, PipelineBuilderCLI.statusVerbosity, textIO);
            if (Repositories.getRepositories().count() == 0L) {
                TextIOUtils.printLine(TextIOUtils.createPrintLine("There are currently no component repositories active. Navigate to the repository management dialog to add components to build pipelines from.", "warn"), textIO);
            }
            choice = (IMenuItem)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(this.menuItems)).read(new String[]{"\nAdd or remove components from your pipeline."});
            this.clearTerminal(textIO);
            try {
                if (choice instanceof ILoopablePipelineManipulationDialog) {
                    ((ILoopablePipelineManipulationDialog)choice).enterInputLoop(pipeline, textIO, path);
                    break block20;
                }
                if (choice instanceof SavePipelineDialog) {
                    try {
                        ((SavePipelineDialog)choice).savePipeline(pipeline, textIO, path);
                    }
                    catch (PipelineIOException e) {
                        e.printStackTrace();
                        textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.print("Saving the pipeline failed: " + e.getMessage()));
                    }
                    break block20;
                }
                if (choice instanceof LoadPipelineDialog) {
                    try {
                        ((LoadPipelineDialog)choice).loadPipeline(pipeline, textIO, path);
                    }
                    catch (PipelineIOException e) {
                        e.printStackTrace();
                        textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.print("Loading the pipeline failed: " + e.getMessage()));
                    }
                    break block20;
                }
                if (choice instanceof RefreshComponentRepositoryMenuItem) {
                    try {
                        textIO.getTextTerminal().print("Refreshing component repository...");
                        this.initComponentRepository(true);
                        textIO.getTextTerminal().println("Done.");
                        break block20;
                    }
                    catch (GithubInformationException e) {
                        throw new MenuItemExecutionException(e);
                    }
                }
                if (choice instanceof SpecifyStatusVerbosityDialog) {
                    ((SpecifyStatusVerbosityDialog)choice).chooseVerbosity(textIO);
                } else if (choice instanceof RepositoryManagementDialog) {
                    ((RepositoryManagementDialog)choice).enterInputLoop(textIO, path);
                    textIO.getTextTerminal().executeWithPropertiesPrefix("emphasis", t -> t.print("Applying repository changes. It might take a while to fetch remote component meta data." + System.getProperty("line.separator")));
                    Repositories.saveRepositoryConfiguration();
                    this.initComponentRepository(false);
                    this.clearTerminal(textIO);
                } else if (choice instanceof ParentPomSettingDialog) {
                    ((ParentPomSettingDialog)choice).execute(pipeline, textIO, path);
                } else if (choice instanceof StorePomMenuItem) {
                    ((StorePomMenuItem)choice).execute(pipeline, textIO);
                }
            }
            catch (Exception e) {
                textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.print("An unexpected exception occurred: " + e.getMessage()));
                e.printStackTrace();
            }
        }
        return choice;
    }
}

