/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.configurations.PipelineBuilderConstants;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.cli.main.PipelineBuilderCLI;
import de.julielab.jcore.pipeline.builder.cli.menu.BackMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.ComponentSelectionMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.MenuItemList;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ILoopablePipelineManipulationDialog;
import de.julielab.jcore.pipeline.builder.cli.util.MenuItemExecutionException;
import de.julielab.jcore.pipeline.builder.cli.util.StatusPrinter;
import java.util.Deque;
import java.util.EnumSet;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;

public abstract class AbstractComponentSelectionDialog
implements ILoopablePipelineManipulationDialog {
    protected MenuItemList<IMenuItem> itemList;

    protected void init(JCoReUIMAPipeline pipeline, EnumSet<PipelineBuilderConstants.JcoreMeta.Category> categories) {
        EnumSet<PipelineBuilderConstants.JcoreMeta.Category> categoriesForSelection = EnumSet.allOf(PipelineBuilderConstants.JcoreMeta.Category.class);
        if (!categories.isEmpty()) {
            categoriesForSelection = categories;
        }
        this.itemList = new MenuItemList();
        if (pipeline.getCrDescription() != null && categoriesForSelection.contains(PipelineBuilderConstants.JcoreMeta.Category.reader)) {
            this.itemList.add(new ComponentSelectionMenuItem(pipeline.getCrDescription()));
        }
        if (pipeline.getCmDelegates() != null && !pipeline.getCmDelegates().isEmpty() && categoriesForSelection.contains(PipelineBuilderConstants.JcoreMeta.Category.multiplier)) {
            pipeline.getCmDelegates().stream().map(ComponentSelectionMenuItem::new).forEach(this.itemList::add);
        }
        if (pipeline.getAeFlowController() != null && categoriesForSelection.contains(PipelineBuilderConstants.JcoreMeta.Category.flowcontroller)) {
            this.itemList.add(new ComponentSelectionMenuItem(pipeline.getAeFlowController()));
        }
        if (pipeline.getAeDelegates() != null && !pipeline.getAeDelegates().isEmpty() && categoriesForSelection.contains(PipelineBuilderConstants.JcoreMeta.Category.ae)) {
            pipeline.getAeDelegates().stream().map(ComponentSelectionMenuItem::new).forEach(this.itemList::add);
        }
        if (pipeline.getCcFlowController() != null && categoriesForSelection.contains(PipelineBuilderConstants.JcoreMeta.Category.flowcontroller)) {
            this.itemList.add(new ComponentSelectionMenuItem(pipeline.getCcFlowController()));
        }
        if (pipeline.getCcDelegates() != null && !pipeline.getCcDelegates().isEmpty() && categoriesForSelection.contains(PipelineBuilderConstants.JcoreMeta.Category.consumer)) {
            pipeline.getCcDelegates().stream().map(ComponentSelectionMenuItem::new).forEach(this.itemList::add);
        }
        this.itemList.add(BackMenuItem.get());
    }

    @Override
    public IMenuItem executeMenuItem(JCoReUIMAPipeline pipeline, TextIO textIO, Deque<String> path) throws MenuItemExecutionException {
        this.init(pipeline, EnumSet.allOf(PipelineBuilderConstants.JcoreMeta.Category.class));
        this.printPosition(textIO, path);
        StatusPrinter.printPipelineStatus(pipeline, PipelineBuilderCLI.statusVerbosity, textIO);
        IMenuItem choice = (IMenuItem)((GenericInputReader)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(this.itemList)).withDefaultValue((Object)BackMenuItem.get())).read(new String[]{"\nChoose a component."});
        this.clearTerminal(textIO);
        return choice;
    }

    public String toString() {
        return this.getName();
    }
}

