/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu;

import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.cli.main.PipelineBuilderCLI;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.utilities.aether.MavenArtifact;
import de.julielab.utilities.aether.MavenException;
import de.julielab.utilities.aether.MavenProjectUtilities;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.maven.model.Model;
import org.beryx.textio.TextIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorePomMenuItem
implements IMenuItem {
    private static final Logger log = LoggerFactory.getLogger(StorePomMenuItem.class);

    @Override
    public String getName() {
        return "Write a Maven POM for debugging";
    }

    public void execute(JCoReUIMAPipeline pipeline, TextIO textIO) {
        File pipelinePath = new File(PipelineBuilderCLI.pipelinePath);
        if (!pipelinePath.exists()) {
            textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.print("Cannot store pom.xml because the pipeline has not been saved yet and thus, no pipeline directory exists." + System.getProperty("line.separator")));
            return;
        }
        File pomFile = Path.of(PipelineBuilderCLI.pipelinePath, "pom.xml").toFile();
        textIO.getTextTerminal().print("Writing file " + pomFile + ".\n");
        try (InputStream is = this.getClass().getResourceAsStream("/pom_template.xml");
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(pomFile));){
            int read;
            ByteBuffer bb = ByteBuffer.allocate(8192);
            while ((read = is.read(bb.array())) != -1) {
                bb.position(read);
                bb.flip();
                ((OutputStream)os).write(bb.array(), 0, bb.limit());
                bb.position(0);
            }
        }
        catch (IOException e) {
            textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.print("Could not write the POM due to an I/O exception: " + e.getMessage() + "\n"));
            log.error("IOException while trying to write {}", (Object)pomFile, (Object)e);
        }
        Stream.Builder<MavenArtifact> builder = Stream.builder();
        if (pipeline.getCrDescription() != null) {
            builder.add(pipeline.getCrDescription().getMetaDescription().getMavenArtifact());
        }
        if (pipeline.getCmDelegates() != null) {
            pipeline.getCmDelegates().stream().filter(Objects::nonNull).map(d -> d.getMetaDescription().getMavenArtifact()).forEach(builder::add);
        }
        if (pipeline.getAeDelegates() != null) {
            pipeline.getAeDelegates().stream().filter(Objects::nonNull).map(d -> d.getMetaDescription().getMavenArtifact()).forEach(builder::add);
        }
        if (pipeline.getCcDelegates() != null) {
            pipeline.getCcDelegates().stream().filter(Objects::nonNull).map(d -> d.getMetaDescription().getMavenArtifact()).forEach(builder::add);
        }
        try {
            Model model = MavenProjectUtilities.addDependenciesToModel((File)pomFile, builder.build());
            MavenProjectUtilities.writeModel((File)pomFile, (Model)model);
        }
        catch (MavenException e) {
            log.error("Exception while adding dependencies to the pipeline Maven model POM file", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Exception while trying to store Maven model with dependencies to {}", (Object)pomFile, (Object)e);
        }
    }

    public String toString() {
        return this.getName();
    }
}

