/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.main;

import de.julielab.jcore.pipeline.builder.base.exceptions.GithubInformationException;
import de.julielab.jcore.pipeline.builder.base.exceptions.PipelineIOException;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.base.main.Repositories;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.IndexDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.RepositoryAddDialog;
import de.julielab.jcore.pipeline.builder.cli.util.MenuItemExecutionException;
import de.julielab.jcore.pipeline.builder.cli.util.StatusPrinter;
import java.io.File;
import java.util.ArrayDeque;
import org.beryx.textio.TextIO;
import org.beryx.textio.TextIoFactory;
import org.beryx.textio.TextTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineBuilderCLI {
    private static final Logger log = LoggerFactory.getLogger(PipelineBuilderCLI.class);
    public static String pipelinePath = "pipeline";
    public static StatusPrinter.Verbosity statusVerbosity = StatusPrinter.Verbosity.BRIEF;
    public static boolean dependenciesHaveChanged = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.setProperty("de.julielab.prerequisitechecksenabled", "true");
        TextIO textIO = null;
        JCoReUIMAPipeline pipeline = new JCoReUIMAPipeline();
        try {
            if (args.length > 0) {
                pipeline.setLoadDirectory(new File(args[0]));
                pipeline.load(true);
                pipelinePath = args[0];
            }
            if (args.length > 1 && args[1].equalsIgnoreCase("-s")) {
                log.info("Storing pipeline to {} and updating libraries.", (Object)pipelinePath);
                pipeline.store(new File(pipelinePath), true);
            } else {
                textIO = TextIoFactory.getTextIO();
                if (Repositories.loadActiveRepositories().isEmpty()) {
                    new RepositoryAddDialog().enterInputLoop(textIO, new ArrayDeque<String>());
                }
                IndexDialog indexDialog = new IndexDialog();
                indexDialog.clearTerminal(textIO);
                textIO.getTextTerminal().executeWithPropertiesPrefix("welcome", t -> t.println("Welcome to the JCoRe Pipeline Builder"));
                textIO.getTextTerminal().executeWithPropertiesPrefix("default", t -> t.println("This tool is supposed to help with the creation of UIMA workflows using components from the JCoRe repository. While the tool tries to be as transparent and helpful as possible, a basic understanding of UIMA, JCoRe and the individual JCoRe components is necessary. For help and pointers to the adequate documentation, please refer to the README of the pipeline modules at https://github.com/JULIELab/jcore-pipeline-modules"));
                indexDialog.enterInputLoop(pipeline, textIO, new ArrayDeque<String>());
            }
        }
        catch (GithubInformationException | MenuItemExecutionException e) {
            if (e instanceof GithubInformationException || e.getCause() instanceof GithubInformationException) {
                log.debug("Error when loading component list", e);
                String ls = System.getProperty("line.separator");
                textIO.getTextTerminal().executeWithPropertiesPrefix("error", arg_0 -> PipelineBuilderCLI.lambda$main$2(ls, (Exception)e, arg_0));
            } else if (e instanceof MenuItemExecutionException) {
                log.debug("Error when running menu", e.getCause());
            } else {
                log.error("Error occurred while running application menu", e);
            }
        }
        catch (PipelineIOException e) {
            log.error("Could not load the pipeline at {}: ", (Object)pipeline.getLoadDirectory(), (Object)e);
        }
        finally {
            if (textIO != null) {
                textIO.getTextTerminal().getProperties().setPromptColor("black");
                textIO.dispose();
            }
        }
    }

    private static /* synthetic */ void lambda$main$2(String ls, Exception e, TextTerminal t) {
        t.print("Could not load JCoRe component list, the program is aborted." + ls + "The error is: " + e.getMessage() + ls);
    }
}

