/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.util;

import de.julielab.jcore.pipeline.builder.base.main.ComponentRepository;
import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.base.main.MetaDescription;
import de.julielab.jcore.pipeline.builder.cli.util.PrintLine;
import de.julielab.jcore.pipeline.builder.cli.util.TextIOUtils;
import de.julielab.utilities.aether.MavenArtifact;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.resource.ConfigurableDataResourceSpecifier;
import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.FileResourceSpecifier;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ExternalResourceBinding;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.impl.NameValuePair_impl;
import org.beryx.textio.TextIO;

public class StatusPrinter {
    public static void printComponentStatus(Description description, boolean brief, TextIO textIO) {
        List<PrintLine> records = StatusPrinter.getComponentStatusRecords(description, brief);
        TextIOUtils.printLines(records.stream(), textIO);
    }

    public static void printComponentStatus(Description description, TextIO textIO) {
        StatusPrinter.printComponentStatus(description, true, textIO);
    }

    public static void printComponentMetaData(MetaDescription metaDescription, TextIO textIO) {
        String name = metaDescription.getName();
        ComponentRepository module = metaDescription.getModule();
        TextIOUtils.printLines(Stream.of(TextIOUtils.createPrintLine("Component Name: ", "fixed", name, "default"), TextIOUtils.createPrintLine("Component Module: ", "fixed", module.getName(), "default")), textIO);
    }

    public static void printComponentMetaData(Description description, TextIO textIO) {
        StatusPrinter.printComponentMetaData(description.getMetaDescription(), textIO);
    }

    private static List<PrintLine> getComponentStatusRecords(Description description, boolean brief) {
        ArrayList<PrintLine> records = new ArrayList<PrintLine>();
        if (!description.getMetaDescription().isPear().booleanValue()) {
            ParameterAdder parameterAdder = new ParameterAdder(records, brief);
            ExternalResourcesAdder externalResourcesAdderAdder = new ExternalResourcesAdder(records);
            parameterAdder.accept(description);
            if (description.getDescriptor() instanceof AnalysisEngineDescription) {
                externalResourcesAdderAdder.accept(description);
            }
        } else {
            records.add(TextIOUtils.createPrintLine("  - " + description.getName(), "componentname"));
            records.add(TextIOUtils.createPrintLine("    This is a PEAR and thus not configurable.", "param"));
            records.add(TextIOUtils.createPrintLine("    Path: " + description.getLocation(), "param"));
        }
        return records;
    }

    public static void printPipelineStatus(JCoReUIMAPipeline pipeline, TextIO textIO) {
        StatusPrinter.printPipelineStatus(pipeline, true, textIO);
    }

    public static void printPipelineStatus(JCoReUIMAPipeline pipeline, boolean brief, TextIO textIO) {
        List<PrintLine> records = StatusPrinter.getPipelineStatusRecords(pipeline, brief);
        TextIOUtils.printLines(records.stream(), textIO);
    }

    private static List<PrintLine> getPipelineStatusRecords(JCoReUIMAPipeline pipeline, boolean brief) {
        ArrayList<PrintLine> records = new ArrayList<PrintLine>();
        ParameterAdder parameterAdder = new ParameterAdder(records, brief);
        records.add(TextIOUtils.createPrintLine("Collection Reader:", "header"));
        if (pipeline.getCrDescription() != null) {
            parameterAdder.accept(pipeline.getCrDescription());
        } else {
            records.add(TextIOUtils.createPrintLine("    none", "empty"));
        }
        if (pipeline.getCmDelegates() != null && !pipeline.getCmDelegates().isEmpty()) {
            records.add(TextIOUtils.createPrintLine("CAS Multipliers:", "header"));
            pipeline.getCmDelegates().stream().map(d -> StatusPrinter.getComponentStatusRecords(d, brief)).forEach(records::addAll);
        }
        records.add(TextIOUtils.createPrintLine("Analysis Engines:", "header"));
        if (pipeline.getAeDelegates() == null || pipeline.getAeDelegates().isEmpty()) {
            records.add(TextIOUtils.createPrintLine("    none", "empty"));
        } else {
            pipeline.getAeDelegates().stream().map(d -> StatusPrinter.getComponentStatusRecords(d, brief)).forEach(records::addAll);
        }
        if (pipeline.getCcDelegates() != null && !pipeline.getCcDelegates().isEmpty()) {
            records.add(TextIOUtils.createPrintLine("CAS Consumers:", "header"));
            pipeline.getCcDelegates().stream().map(d -> StatusPrinter.getComponentStatusRecords(d, brief)).forEach(records::addAll);
        }
        Stream cmStream = pipeline.getCmDelegates() != null ? pipeline.getCmDelegates().stream() : Stream.empty();
        Stream aeStream = pipeline.getAeDelegates() != null ? pipeline.getAeDelegates().stream() : Stream.empty();
        Stream ccStream = pipeline.getCcDelegates() != null ? pipeline.getCcDelegates().stream() : Stream.empty();
        Stream<Description> aes = Stream.concat(Stream.concat(cmStream, aeStream), ccStream).filter(d -> d.getDescriptor() instanceof AnalysisEngineDescription);
        Map<String, List<ExternalResourceDescription>> resourcesByName = aes.map(Description::getDescriptorAsAnalysisEngineDescription).filter(ae -> ae.getResourceManagerConfiguration() != null).filter(ae -> ae.getResourceManagerConfiguration() != null).flatMap(ae -> Stream.of(ae.getResourceManagerConfiguration().getExternalResources())).collect(Collectors.groupingBy(er -> er.getName()));
        resourcesByName.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).forEach(e -> records.add(TextIOUtils.createPrintLine("Configuration error: There are multiple external resources with the name " + (String)e.getKey() + ".\n    Go to the configuration dialog and adapt the names.", "error")));
        return records;
    }

    private static class ExternalResourcesAdder
    implements Consumer<Description> {
        private List<PrintLine> records;

        public ExternalResourcesAdder(List<PrintLine> records) {
            this.records = records;
        }

        @Override
        public void accept(Description description) {
            Function<String, String> color = str -> description.isActive() ? str : "deactivatedcomponent";
            AnalysisEngineDescription desc = description.getDescriptorAsAnalysisEngineDescription();
            ExternalResourceDependency[] externalResourceDependencies = desc.getExternalResourceDependencies();
            if (externalResourceDependencies != null && externalResourceDependencies.length > 0) {
                this.records.add(TextIOUtils.createPrintLine("    External Resources:", color.apply("header")));
                Set dependenciesToSatisfy = Stream.of(externalResourceDependencies).map(ExternalResourceDependency::getKey).collect(Collectors.toSet());
                ResourceManagerConfiguration resourceManagerConfiguration = desc.getResourceManagerConfiguration();
                HashMap<String, String> bindingMap = new HashMap<String, String>();
                if (resourceManagerConfiguration != null) {
                    ExternalResourceBinding[] externalResourceBindings = resourceManagerConfiguration.getExternalResourceBindings();
                    bindingMap.putAll(Stream.of(externalResourceBindings).collect(Collectors.toMap(ExternalResourceBinding::getKey, ExternalResourceBinding::getResourceName)));
                }
                Stream.of(externalResourceDependencies).forEach(dependency -> {
                    if (bindingMap.keySet().contains(dependency.getKey())) {
                        String resourceName = (String)bindingMap.get(dependency.getKey());
                        this.records.add(TextIOUtils.createPrintLine("    " + dependency.getKey() + ": " + resourceName, (String)color.apply("default")));
                        Optional<ExternalResourceDescription> resDescOpt = Stream.of(desc.getResourceManagerConfiguration().getExternalResources()).filter(res -> res.getName().equals(resourceName)).findFirst();
                        if (resDescOpt.isPresent()) {
                            ExternalResourceDescription resourceDesc = resDescOpt.get();
                            this.records.add(TextIOUtils.createPrintLine("       Name: ", (String)color.apply("fixed"), resourceDesc.getName(), (String)color.apply("default")));
                            this.records.add(TextIOUtils.createPrintLine("       Description: ", (String)color.apply("fixed"), resourceDesc.getDescription(), (String)color.apply("default")));
                            this.records.add(TextIOUtils.createPrintLine("       Implementation: ", (String)color.apply("fixed"), resourceDesc.getImplementationName(), (String)color.apply("default")));
                            String url = null;
                            ResourceSpecifier resourceSpecifier = resourceDesc.getResourceSpecifier();
                            if (resourceSpecifier instanceof FileResourceSpecifier) {
                                url = ((FileResourceSpecifier)resourceSpecifier).getFileUrl();
                            } else if (resourceSpecifier instanceof ConfigurableDataResourceSpecifier) {
                                url = ((ConfigurableDataResourceSpecifier)resourceSpecifier).getUrl();
                            }
                            this.records.add(TextIOUtils.createPrintLine("       Resource URL: ", StringUtils.isBlank((String)url) ? (String)color.apply("error") : (String)color.apply("fixed"), url, (String)color.apply("default")));
                            if (resourceSpecifier instanceof ConfigurableDataResourceSpecifier) {
                                ConfigurableDataResourceSpecifier configurableDataResourceSpecifier = (ConfigurableDataResourceSpecifier)resourceSpecifier;
                                ConfigurationParameter[] declarations = configurableDataResourceSpecifier.getMetaData().getConfigurationParameterDeclarations().getConfigurationParameters();
                                Map settings = Stream.of(configurableDataResourceSpecifier.getMetaData().getConfigurationParameterSettings().getParameterSettings()).flatMap(Stream::of).collect(Collectors.toMap(NameValuePair::getName, Function.identity()));
                                for (int i = 0; i < declarations.length; ++i) {
                                    ConfigurationParameter declaration = declarations[i];
                                    String name = declaration.getName();
                                    Object value = Optional.of(settings.get(name)).orElseGet(NameValuePair_impl::new).getValue();
                                    String reportLevel = (String)color.apply("default");
                                    if (declaration.isMandatory() && (value == null || StringUtils.isBlank((String)value.toString()))) {
                                        reportLevel = (String)color.apply("error");
                                    }
                                    this.records.add(TextIOUtils.createPrintLine("       " + name + ": ", "param", value.toString(), reportLevel));
                                }
                            }
                        }
                    } else {
                        this.records.add(TextIOUtils.createPrintLine("    " + dependency.getKey() + ": <not bound>", (String)color.apply("error")));
                    }
                });
            }
        }
    }

    private static class ParameterAdder
    implements Consumer<Description> {
        private List<PrintLine> records;
        private boolean brief;

        public ParameterAdder(List<PrintLine> records, boolean brief) {
            this.records = records;
            this.brief = brief;
        }

        @Override
        public void accept(Description description) {
            ResourceMetaData metaData = ((ResourceCreationSpecifier)description.getDescriptor()).getMetaData();
            Function<String, String> color = str -> description.isActive() ? str : "deactivatedcomponent";
            if (description.isActive()) {
                this.records.add(TextIOUtils.createPrintLine("  - " + metaData.getName(), "componentname"));
            } else {
                this.records.add(TextIOUtils.createPrintLine("  - " + metaData.getName() + " (DEACTIVATED)", "deactivatedcomponent"));
            }
            this.records.add(TextIOUtils.createPrintLine("    Maven artifact: " + this.getArtifactString(description), color.apply("default")));
            NameValuePair[] parameterSettings = metaData.getConfigurationParameterSettings().getParameterSettings();
            Set mandatorySet = Stream.of(metaData.getConfigurationParameterDeclarations().getConfigurationParameters()).filter(ConfigurationParameter::isMandatory).map(ConfigurationParameter::getName).collect(Collectors.toSet());
            if (parameterSettings != null && parameterSettings.length > 0 || !mandatorySet.isEmpty()) {
                this.records.add(TextIOUtils.createPrintLine("    Mandatory Parameters:", color.apply("parameters")));
            }
            if (parameterSettings != null) {
                for (NameValuePair parameter : parameterSettings) {
                    if (StringUtils.isBlank((String)parameter.getValue().toString()) || !mandatorySet.remove(parameter.getName()) && this.brief) continue;
                    String valueString = parameter.getValue().getClass().isArray() ? Arrays.toString((Object[])parameter.getValue()) : String.valueOf(parameter.getValue());
                    this.records.add(TextIOUtils.createPrintLine("    " + parameter.getName() + ": ", color.apply("param"), valueString, color.apply("default")));
                }
            }
            for (String notSetMandatoryParameter : mandatorySet) {
                this.records.add(TextIOUtils.createPrintLine("    " + notSetMandatoryParameter + ": <not set>", color.apply("error")));
            }
        }

        private String getArtifactString(Description description) {
            MavenArtifact artifact = description.getMetaDescription().getMavenArtifact();
            String artifactString = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
            if (artifact.getClassifier() != null) {
                artifactString = artifactString + ":" + artifact.getClassifier();
            }
            return artifactString;
        }
    }
}

