/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.exceptions.PipelineIOException;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.cli.main.PipelineBuilderCLI;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.IMenuDialog;
import java.io.File;
import java.util.Deque;
import org.beryx.textio.BooleanInputReader;
import org.beryx.textio.StringInputReader;
import org.beryx.textio.TextIO;

public class SavePipelineDialog
implements IMenuDialog {
    @Override
    public String getName() {
        return "Save Pipeline";
    }

    public void savePipeline(JCoReUIMAPipeline pipeline, TextIO textIO, Deque<String> path) throws PipelineIOException {
        String destination;
        path.add(this.getName());
        this.printPosition(textIO, path);
        PipelineBuilderCLI.pipelinePath = destination = (String)((StringInputReader)textIO.newStringInputReader().withDefaultValue((Object)PipelineBuilderCLI.pipelinePath)).read(new String[]{"Enter the directory to save the pipeline to."});
        File destinationFile = new File(destination);
        boolean store = true;
        boolean clearLibDir = false;
        if (destinationFile.exists()) {
            Boolean clear;
            Boolean overwrite = (Boolean)((BooleanInputReader)textIO.newBooleanInputReader().withDefaultValue((Object)false)).withFalseInput("N").withTrueInput("Y").read(new String[]{"The path " + destinationFile.getAbsolutePath() + " exists. Do you wish to store to this directory anyway?"});
            if (overwrite.booleanValue() && (clear = (Boolean)((BooleanInputReader)textIO.newBooleanInputReader().withDefaultValue((Object)false)).withFalseInput("N").withTrueInput("Y").read(new String[]{"Do you want to clear the library directory \"" + destinationFile.getAbsolutePath() + File.separator + "lib" + "\" before storage? This is useful when the version of components has changed."})).booleanValue()) {
                clearLibDir = true;
            }
            if (!overwrite.booleanValue()) {
                store = false;
                textIO.getTextTerminal().println("Aborting.");
            }
        }
        if (store) {
            textIO.getTextTerminal().println("Storing pipeline. It may take a while to gather all transitive dependencies, please wait...");
            pipeline.store(destinationFile, clearLibDir);
            textIO.getTextTerminal().println("Saved pipeline to " + destinationFile.getAbsolutePath());
        }
        path.removeLast();
    }

    public String toString() {
        return this.getName();
    }
}

