/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.vinci.transport.Attributes;
import org.apache.vinci.transport.Frame;
import org.apache.vinci.transport.FrameComponent;
import org.apache.vinci.transport.FrameLeaf;
import org.apache.vinci.transport.FrameTransporter;
import org.apache.vinci.transport.KeyValuePair;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.util.TransportableConverter;
import org.apache.vinci.transport.util.UTFConverter;

public class XTalkTransporter
implements FrameTransporter {
    private static final int OVERSIZE_KEY_LENGTH = 0x40000000;
    public static final byte DOCUMENT_MARKER = 88;
    public static final byte ELEMENT_MARKER = 69;
    public static final byte PI_MARKER = 112;
    public static final byte STRING_MARKER = 115;
    public static final byte VERSION_CODE = 0;
    private static final String OVERSIZE_FIELD = "Oversize field: ";
    public static final byte[] HEADER = new byte[]{88, 0, 0, 0, 0, 1, 69};

    @Override
    public KeyValuePair fromStream(InputStream is, Frame f) throws IOException, EOFException {
        char[] cbuffer = new char[128];
        byte[] buffer = new byte[128];
        int marker = is.read();
        if (marker == -1) {
            throw new EOFException();
        }
        if ((byte)marker != 88) {
            throw new IOException("Expected document marker: " + (char)marker);
        }
        return this.fromStreamWork(is, f, buffer, cbuffer);
    }

    public KeyValuePair fromStreamWork(InputStream is, Frame f) throws IOException {
        return this.fromStreamWork(is, f, new byte[128], new char[128]);
    }

    public KeyValuePair fromStreamWork(InputStream is, Frame f, byte[] buffer, char[] cbuffer) throws IOException {
        int marker;
        int version2 = is.read();
        if ((byte)version2 != 0) {
            throw new IOException("Xtalk version code doesn't match 0: " + version2);
        }
        int top_field_count = XTalkTransporter.readInt(is);
        while ((marker = is.read()) == 112) {
            this.ignorePI(is);
            --top_field_count;
        }
        if ((byte)marker != 69) {
            throw new IOException("Expected element marker: " + (char)marker);
        }
        KeyValuePair return_me = this.consumeRootChildren(is, f, buffer, cbuffer);
        --top_field_count;
        while (top_field_count > 0) {
            marker = is.read();
            if ((byte)marker != 112) {
                throw new IOException("Expected pi marker: " + (char)marker);
            }
            this.ignorePI(is);
            --top_field_count;
        }
        return return_me;
    }

    private Attributes consumeAttributes(InputStream is, byte[] buffer, char[] cbuffer) throws IOException {
        int attribute_count = XTalkTransporter.readInt(is);
        if (attribute_count < 1) {
            return null;
        }
        Attributes map = new Attributes(attribute_count);
        for (int i = 0; i < attribute_count; ++i) {
            String akey = XTalkTransporter.consumeString(is, buffer, cbuffer);
            map.add(akey, XTalkTransporter.consumeLeaf(is, map));
        }
        return map;
    }

    protected void ignorePI(InputStream is) throws IOException {
        XTalkTransporter.ignoreString(is);
        XTalkTransporter.ignoreString(is);
    }

    public KeyValuePair consumeRootChildren(InputStream is, Frame f, byte[] buffer, char[] cbuffer) throws IOException {
        XTalkTransporter.consumeString(is, buffer, cbuffer);
        Attributes attributes = this.consumeAttributes(is, buffer, cbuffer);
        if (attributes != null) {
            f.setAttributes(attributes);
        }
        int field_count = XTalkTransporter.readInt(is);
        KeyValuePair return_me = null;
        if (field_count != 0) {
            int marker = is.read();
            if ((byte)marker == 69) {
                return_me = this.consumeRootElement(is, f, buffer, cbuffer);
                if (--field_count > 0) {
                    marker = is.read();
                } else {
                    return return_me;
                }
            }
            this.consumeChildren(is, f, field_count, marker, buffer, cbuffer);
        }
        return return_me;
    }

    public KeyValuePair consumeRootElement(InputStream is, Frame f, byte[] buffer, char[] cbuffer) throws IOException {
        String tag_name = XTalkTransporter.consumeString(is, buffer, cbuffer);
        Attributes attributes = this.consumeAttributes(is, buffer, cbuffer);
        int sub_field_count = XTalkTransporter.readInt(is);
        KeyValuePair return_me = null;
        FrameComponent value = null;
        if (sub_field_count == 0) {
            value = f.createSubFrame(tag_name, 0);
            if (tag_name.startsWith("vinci:")) {
                return_me = new KeyValuePair(tag_name, new VinciFrame());
            }
        } else {
            int sub_marker = is.read();
            if (sub_field_count == 1 && (byte)sub_marker == 115) {
                value = XTalkTransporter.consumeLeaf(is, f);
                if (tag_name.startsWith("vinci:")) {
                    return_me = new KeyValuePair(tag_name, value);
                }
            } else {
                value = f.createSubFrame(tag_name, sub_field_count);
                if (tag_name.startsWith("vinci:")) {
                    VinciFrame pre_value = new VinciFrame();
                    this.consumeChildren(is, pre_value, sub_field_count, sub_marker, buffer, cbuffer);
                    return_me = new KeyValuePair(tag_name, pre_value);
                    TransportableConverter.convert((Transportable)pre_value, value);
                } else {
                    this.consumeChildren(is, (Frame)value, sub_field_count, sub_marker, buffer, cbuffer);
                }
            }
        }
        if (attributes != null) {
            value.setAttributes(attributes);
        }
        f.add(tag_name, value);
        return return_me;
    }

    public void consumeChildren(InputStream is, Frame f, int field_count, int marker, byte[] buffer, char[] cbuffer) throws IOException {
        while (field_count > 0) {
            switch ((byte)marker) {
                case 112: {
                    this.ignorePI(is);
                    break;
                }
                case 115: {
                    f.add("", XTalkTransporter.consumeLeaf(is, f));
                    break;
                }
                case 69: {
                    String tag_name = XTalkTransporter.consumeString(is, buffer, cbuffer);
                    Attributes attributes = this.consumeAttributes(is, buffer, cbuffer);
                    int sub_field_count = XTalkTransporter.readInt(is);
                    FrameComponent value = null;
                    if (sub_field_count == 0) {
                        value = f.createSubFrame(tag_name, sub_field_count);
                    } else {
                        int sub_marker = is.read();
                        if (sub_field_count == 1 && (byte)sub_marker == 115) {
                            value = XTalkTransporter.consumeLeaf(is, f);
                        } else {
                            value = f.createSubFrame(tag_name, sub_field_count);
                            this.consumeChildren(is, (Frame)value, sub_field_count, sub_marker, buffer, cbuffer);
                        }
                    }
                    if (attributes != null) {
                        value.setAttributes(attributes);
                    }
                    f.add(tag_name, value);
                    break;
                }
                default: {
                    throw new IOException("Unexpected marker while parsing children: " + (char)marker);
                }
            }
            if (--field_count <= 0) continue;
            marker = is.read();
        }
    }

    private static void ignoreString(InputStream is) throws IOException {
        long count;
        long skip_me = XTalkTransporter.readInt(is);
        long skipped = count = 0L;
        do {
            if ((count = is.skip(skip_me - skipped)) >= 0L) continue;
            throw new EOFException();
        } while ((skipped += count) < skip_me);
    }

    public static String consumeString(InputStream is) throws IOException {
        int utflen = XTalkTransporter.readInt(is);
        if (utflen > 0x40000000) {
            throw new IOException(OVERSIZE_FIELD + utflen);
        }
        byte[] bytearr = new byte[utflen];
        XTalkTransporter.readFully(bytearr, is);
        return UTFConverter.convertUTFToString(bytearr);
    }

    public static String consumeString(InputStream is, byte[] buffer, char[] cbuffer) throws IOException {
        int utflen = XTalkTransporter.readInt(is);
        if (utflen > 0x40000000) {
            throw new IOException(OVERSIZE_FIELD + utflen);
        }
        if (buffer.length < utflen) {
            byte[] bytearr = new byte[utflen];
            XTalkTransporter.readFully(bytearr, is);
            return UTFConverter.convertUTFToString(bytearr);
        }
        XTalkTransporter.readFully(buffer, utflen, is);
        int charlen = UTFConverter.convertUTFToString(buffer, 0, utflen, cbuffer);
        return new String(cbuffer, 0, charlen);
    }

    public static int consumeCharacters(InputStream is, byte[] byteBuf, char[] charBuf, int bytesToRead) throws IOException {
        XTalkTransporter.readFully(byteBuf, bytesToRead, is);
        return UTFConverter.convertUTFToString(byteBuf, 0, bytesToRead, charBuf);
    }

    private static FrameLeaf consumeLeaf(InputStream is, Frame f) throws IOException {
        int utflen = XTalkTransporter.readInt(is);
        if (utflen > 0x40000000) {
            throw new IOException(OVERSIZE_FIELD + utflen);
        }
        byte[] bytearr = new byte[utflen];
        XTalkTransporter.readFully(bytearr, is);
        return f.createFrameLeaf(bytearr);
    }

    @Override
    public void toStream(OutputStream os, Frame f) throws IOException {
        byte[] workbuf = new byte[256];
        os.write(HEADER);
        XTalkTransporter.stringToBin("vinci:FRAME", os, workbuf);
        if (f.getAttributes() != null) {
            this.attributesToBin(os, f.getAttributes(), workbuf);
        } else {
            XTalkTransporter.writeInt(0, os);
        }
        this.elementToBin(os, f, workbuf);
    }

    public void elementToBin(OutputStream os, Frame f, byte[] workbuf) throws IOException {
        XTalkTransporter.writeInt(f.getKeyValuePairCount(), os);
        KeyValuePair keyVal = null;
        int total = f.getKeyValuePairCount();
        for (int i = 0; i < total; ++i) {
            keyVal = f.getKeyValuePair(i);
            if (keyVal.key.equals("")) {
                os.write(115);
                byte[] data = ((FrameLeaf)keyVal.value).getData();
                XTalkTransporter.writeInt(data.length, os);
                os.write(data);
                continue;
            }
            os.write(69);
            XTalkTransporter.stringToBin(keyVal.key, os, workbuf);
            Attributes a = keyVal.value.getAttributes();
            if (a != null) {
                this.attributesToBin(os, keyVal.value.getAttributes(), workbuf);
            } else {
                XTalkTransporter.writeInt(0, os);
            }
            if (keyVal.isValueALeaf()) {
                XTalkTransporter.writeInt(1, os);
                os.write(115);
                byte[] data = keyVal.getValueAsLeaf().getData();
                XTalkTransporter.writeInt(data.length, os);
                os.write(data);
                continue;
            }
            this.elementToBin(os, keyVal.getValueAsFrame(), workbuf);
        }
    }

    public static void stringToBin(String str, OutputStream os) throws IOException {
        byte[] write_me = UTFConverter.convertStringToUTF(str);
        XTalkTransporter.writeInt(write_me.length, os);
        os.write(write_me);
    }

    public static void stringToBin(String str, OutputStream os, byte[] buffer) throws IOException {
        int len;
        byte[] newbuf = buffer.length < str.length() * 3 ? (buffer.length < (len = UTFConverter.calculateUTFLength(str)) ? new byte[len] : buffer) : buffer;
        int newlen = UTFConverter.convertStringToUTF(str, newbuf);
        XTalkTransporter.writeInt(newlen, os);
        os.write(newbuf, 0, newlen);
    }

    public static void stringToBin(char[] str, int begin, int len, OutputStream os) throws IOException {
        byte[] write_me = UTFConverter.convertStringToUTF(str, begin, len);
        XTalkTransporter.writeInt(write_me.length, os);
        os.write(write_me);
    }

    public static void stringToBin(char[] str, int begin, int len, OutputStream os, byte[] buffer) throws IOException {
        int byteslen;
        byte[] newbuf = buffer.length < (len - begin) * 3 ? (buffer.length < (byteslen = UTFConverter.calculateUTFLength(str, begin, len)) ? new byte[byteslen] : buffer) : buffer;
        int newlen = UTFConverter.convertStringToUTF(str, begin, len, newbuf);
        XTalkTransporter.writeInt(newlen, os);
        os.write(newbuf, 0, newlen);
    }

    public static void writeInt(int write_me, OutputStream out) throws IOException {
        out.write(write_me >>> 24);
        out.write(write_me >>> 16);
        out.write(write_me >>> 8);
        out.write(write_me);
    }

    public static int readInt(InputStream in) throws IOException {
        int c4;
        int c3;
        int c2;
        int c1 = in.read();
        if ((c1 | (c2 = in.read()) | (c3 = in.read()) | (c4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (c1 << 24) + (c2 << 16) + (c3 << 8) + c4;
    }

    public static void readFully(byte[] b, InputStream in) throws IOException {
        XTalkTransporter.readFully(b, b.length, in);
    }

    public static void readFully(byte[] b, int length, InputStream in) throws IOException {
        int count;
        for (int read_so_far = 0; read_so_far < length; read_so_far += count) {
            count = in.read(b, read_so_far, length - read_so_far);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public void attributesToBin(OutputStream os, Attributes attributes, byte[] workbuf) throws IOException {
        int size = attributes.getKeyValuePairCount();
        XTalkTransporter.writeInt(size, os);
        for (int i = 0; i < size; ++i) {
            KeyValuePair k = attributes.getKeyValuePair(i);
            XTalkTransporter.stringToBin(k.key, os, workbuf);
            byte[] write_me = ((FrameLeaf)k.value).getData();
            XTalkTransporter.writeInt(write_me.length, os);
            os.write(write_me);
        }
    }
}

