/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.metadata.cpe;

import java.util.ArrayList;
import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.collection.impl.metadata.cpe.CasProcessorCpeObject;
import org.apache.uima.collection.impl.metadata.cpe.CpeIntegratedCasProcessorImpl;
import org.apache.uima.collection.impl.metadata.cpe.CpeLocalCasProcessorImpl;
import org.apache.uima.collection.impl.metadata.cpe.CpeRemoteCasProcessorImpl;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.collection.metadata.CpeCasProcessors;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLParser;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CpeCasProcessorsImpl
extends MetaDataObject_impl
implements CpeCasProcessors {
    private static final long serialVersionUID = -5532660061637797550L;
    private static final int DEFAULT_POOL_SIZE = 1;
    private ArrayList casProcessors = new ArrayList();
    private boolean dropCasOnException;
    private int casPoolSize = 1;
    private int processingUnitThreadCount = 1;
    private int inputQueueSize;
    private int outputQueueSize;
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("casProcessors", new PropertyXmlInfo[]{new PropertyXmlInfo("allCpeCasProcessors", null)});

    @Override
    public void setOutputQueueSize(int aOutputQueueSize) throws CpeDescriptorException {
        this.outputQueueSize = aOutputQueueSize;
    }

    @Override
    public int getOutputQueueSize() {
        return this.outputQueueSize;
    }

    @Override
    public void setInputQueueSize(int aInputQueueSize) throws CpeDescriptorException {
        this.inputQueueSize = aInputQueueSize;
    }

    @Override
    public int getInputQueueSize() {
        return this.inputQueueSize;
    }

    @Override
    public void setConcurrentPUCount(int aConcurrentPUCount) throws CpeDescriptorException {
        this.processingUnitThreadCount = aConcurrentPUCount;
    }

    @Override
    public int getConcurrentPUCount() {
        return this.processingUnitThreadCount;
    }

    @Override
    public void addCpeCasProcessor(CpeCasProcessor aCasProcessor, int aInsertPosition) throws CpeDescriptorException {
        this.casProcessors.add(aInsertPosition, aCasProcessor);
    }

    @Override
    public void addCpeCasProcessor(CpeCasProcessor aCasProcessor) throws CpeDescriptorException {
        this.casProcessors.add(aCasProcessor);
    }

    @Override
    public CpeCasProcessor getCpeCasProcessor(int aPosition) throws CpeDescriptorException {
        if (aPosition <= this.casProcessors.size()) {
            return (CpeCasProcessor)this.casProcessors.get(aPosition);
        }
        throw new CpeDescriptorException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_array_index__WARNING", new Object[]{Thread.currentThread().getName(), "CpeCasProcessor"}));
    }

    @Override
    public CpeCasProcessor[] getAllCpeCasProcessors() throws CpeDescriptorException {
        CpeCasProcessor[] processors = new CpeCasProcessor[this.casProcessors.size()];
        this.casProcessors.toArray(processors);
        return processors;
    }

    public void setAllCpeCasProcessors(CpeCasProcessor[] aCpeProcessors) throws CpeDescriptorException {
        for (int i = 0; aCpeProcessors != null && i < aCpeProcessors.length; ++i) {
            this.casProcessors.add(aCpeProcessors[i]);
        }
    }

    @Override
    public void removeCpeCasProcessor(int aPosition) throws CpeDescriptorException {
        if (aPosition > this.casProcessors.size()) {
            throw new CpeDescriptorException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_array_index__WARNING", new Object[]{Thread.currentThread().getName()}));
        }
        this.casProcessors.remove(aPosition);
    }

    public CpeCasProcessor[] removeCpeCasProcessor(int aPosition, boolean flag) throws CpeDescriptorException {
        if (aPosition <= this.casProcessors.size()) {
            this.casProcessors.remove(aPosition);
            return this.getAllCpeCasProcessors();
        }
        throw new CpeDescriptorException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_array_index__WARNING", new Object[]{Thread.currentThread().getName()}));
    }

    @Override
    public void removeAllCpeCasProcessors() throws CpeDescriptorException {
        this.casProcessors.clear();
    }

    @Override
    public void setPoolSize(int aPoolSize) throws CpeDescriptorException {
        this.casPoolSize = aPoolSize;
    }

    public int getPoolSize() throws CpeDescriptorException {
        return this.casPoolSize;
    }

    public void setDropCasOnException(boolean aDropCasOnException) throws CpeDescriptorException {
        this.dropCasOnException = aDropCasOnException;
    }

    @Override
    public boolean getDropCasOnException() {
        return this.dropCasOnException;
    }

    @Override
    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        try {
            this.setDropCasOnException(Boolean.valueOf(aElement.getAttribute("dropCasOnException")));
        }
        catch (Exception e) {
            throw new InvalidXMLException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_attribute_from_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), "casProcessors", "dropCasOnException", "casProcessors"});
        }
        String cps = aElement.getAttribute("casPoolSize");
        if (cps != null && cps.trim().length() > 0) {
            try {
                this.setPoolSize(Integer.parseInt(cps));
            }
            catch (Exception e) {
                throw new InvalidXMLException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_attribute_from_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), "casProcessors", "casPoolSize", "casProcessors"});
            }
        }
        if (aElement.getAttribute("processingUnitThreadCount") != null) {
            try {
                this.setConcurrentPUCount(Integer.parseInt(aElement.getAttribute("processingUnitThreadCount")));
            }
            catch (Exception e) {
                throw new InvalidXMLException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_attribute_from_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), "casProcessors", "processingUnitThreadCount", "casProcessors"});
            }
        } else {
            throw new InvalidXMLException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_attribute_from_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), "casProcessors", "processingUnitThreadCount", "casProcessors"});
        }
        try {
            if (this.getPoolSize() == 0) {
                String oqs;
                String iqs = aElement.getAttribute("inputQueueSize");
                if (iqs != null && iqs.length() > 0) {
                    this.setInputQueueSize(Integer.parseInt(iqs));
                }
                if ((oqs = aElement.getAttribute("outputQueueSize")) != null && oqs.length() > 0) {
                    this.setOutputQueueSize(Integer.parseInt(oqs));
                }
            }
        }
        catch (Exception e) {
            throw new InvalidXMLException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_attribute_from_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), "casProcessors", "field", "casProcessors"});
        }
        NodeList nodes = aElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            NamedNodeMap lMap;
            Node depNode;
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            CasProcessorCpeObject cp = null;
            if (node.getNodeName().equals("casProcessor") && (depNode = (lMap = node.getAttributes()).getNamedItem("deployment")) != null) {
                String lDeployMode = depNode.getNodeValue();
                if ("integrated".equals(lDeployMode)) {
                    cp = new CpeIntegratedCasProcessorImpl();
                } else if ("remote".equals(lDeployMode)) {
                    cp = new CpeRemoteCasProcessorImpl();
                } else if ("local".equals(lDeployMode)) {
                    cp = new CpeLocalCasProcessorImpl(false);
                }
            }
            if (cp != null) {
                cp.buildFromXMLElement((Element)node, aParser, aOptions);
            }
            this.casProcessors.add(cp);
        }
    }

    @Override
    public void toXML(ContentHandler aContentHandler, boolean aWriteDefaultNamespaceAttribute) throws SAXException {
        XmlizationInfo inf = this.getXmlizationInfo();
        AttributesImpl attrs = this.getXMLAttributes();
        if (aWriteDefaultNamespaceAttribute && inf.namespace != null) {
            attrs.addAttribute("", "xmlns", "xmlns", null, inf.namespace);
        }
        aContentHandler.startElement(inf.namespace, inf.elementTagName, inf.elementTagName, attrs);
        for (int i = 0; i < this.casProcessors.size(); ++i) {
            ((CpeCasProcessor)this.casProcessors.get(i)).toXML(aContentHandler, aWriteDefaultNamespaceAttribute);
        }
        aContentHandler.endElement(inf.namespace, inf.elementTagName, inf.elementTagName);
    }

    @Override
    protected AttributesImpl getXMLAttributes() {
        AttributesImpl attrs = super.getXMLAttributes();
        if (this.isDropCasOnException()) {
            attrs.addAttribute("", "dropCasOnException", "dropCasOnException", "CDATA", String.valueOf(this.isDropCasOnException()));
        }
        attrs.addAttribute("", "casPoolSize", "casPoolSize", "CDATA", String.valueOf(this.getCasPoolSize()));
        attrs.addAttribute("", "processingUnitThreadCount", "processingUnitThreadCount", "CDATA", String.valueOf(this.getConcurrentPUCount()));
        if (this.getCasPoolSize() == 0) {
            attrs.addAttribute("", "inputQueueSize", "inputQueueSize", "CDATA", String.valueOf(this.getInputQueueSize()));
            attrs.addAttribute("", "outputQueueSize", "outputQueueSize", "CDATA", String.valueOf(this.getOutputQueueSize()));
        }
        return attrs;
    }

    @Override
    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }

    @Override
    public int getCasPoolSize() {
        try {
            return this.getPoolSize();
        }
        catch (CpeDescriptorException cpeDescriptorException) {
            return 1;
        }
    }

    public boolean isDropCasOnException() {
        return this.getDropCasOnException();
    }
}

