/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIndexRepository;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.DebugNameValuePair;
import org.apache.uima.cas.text.AnnotationFS;

public class DebugFSLogicalStructure {
    private static final String[] indexKinds = new String[]{"Sorted", "Set", "Bag"};

    public static Object getDebugLogicalStructure_FeatureStructure(FeatureStructure fs) {
        if (fs instanceof StringArrayFS) {
            return ((StringArrayFS)fs).toArray();
        }
        if (fs instanceof FloatArrayFS) {
            return ((FloatArrayFS)fs).toArray();
        }
        if (fs instanceof IntArrayFS) {
            return ((IntArrayFS)fs).toArray();
        }
        if (fs instanceof ArrayFS) {
            return ((ArrayFS)fs).toArray();
        }
        CASImpl cas = (CASImpl)fs.getCAS();
        TypeSystem ts = cas.getTypeSystem();
        Type fsType = fs.getType();
        if (ts.subsumes(ts.getType("uima.cas.FloatList"), fsType)) {
            return DebugFSLogicalStructure.floatListToArray(fs);
        }
        if (ts.subsumes(ts.getType("uima.cas.IntegerList"), fsType)) {
            return DebugFSLogicalStructure.integerListToArray(fs);
        }
        if (ts.subsumes(ts.getType("uima.cas.StringList"), fsType)) {
            return DebugFSLogicalStructure.stringListToArray(fs);
        }
        if (ts.subsumes(ts.getType("uima.cas.FSList"), fsType)) {
            return DebugFSLogicalStructure.fsListToArray(fs);
        }
        String typeName = fsType.getName();
        List<Feature> features = fsType.getFeatures();
        int nbrFeats = features.size();
        boolean isAnnotation = false;
        boolean isJCasClass = false;
        if (fs.getClass().getName().equals(typeName)) {
            isJCasClass = true;
        }
        if (ts.subsumes(cas.getAnnotationType(), fsType)) {
            isAnnotation = true;
        }
        DebugNameValuePair[] result = new DebugNameValuePair[(isJCasClass ? 0 : 1) + (isAnnotation ? 3 : nbrFeats)];
        int i = 0;
        if (!isJCasClass) {
            result[i++] = new DebugNameValuePair("CasType", typeName);
        }
        if (isAnnotation) {
            DebugNameValuePair[] featResults = new DebugNameValuePair[nbrFeats];
            DebugFSLogicalStructure.fillFeatures(featResults, 0, fs, features);
            result[i++] = new DebugNameValuePair("Features", featResults);
            result[i++] = new DebugNameValuePair("Covered Text", ((AnnotationFS)fs).getCoveredText());
            result[i++] = new DebugNameValuePair("SubAnnotations", new UnexpandedFeatureStructures((AnnotationFS)fs));
        } else {
            DebugFSLogicalStructure.fillFeatures(result, isJCasClass ? 0 : 1, fs, features);
        }
        return result;
    }

    private static void fillFeatures(DebugNameValuePair[] result, int startOffset, FeatureStructure fs, List<Feature> features) {
        int nbrFeats = features.size();
        int i = startOffset;
        for (int j = 0; j < nbrFeats; ++j) {
            Feature feat = features.get(j);
            DebugNameValuePair nv = new DebugNameValuePair(feat.getShortName(), null);
            String rangeTypeName = feat.getRange().getName();
            if ("uima.cas.Integer".equals(rangeTypeName)) {
                nv.setValue(fs.getIntValue(feat));
            } else if ("uima.cas.Float".equals(rangeTypeName)) {
                nv.setValue(Float.valueOf(fs.getFloatValue(feat)));
            } else if ("uima.cas.Boolean".equals(rangeTypeName)) {
                nv.setValue(fs.getBooleanValue(feat));
            } else if ("uima.cas.Byte".equals(rangeTypeName)) {
                nv.setValue(fs.getByteValue(feat));
            } else if ("uima.cas.Short".equals(rangeTypeName)) {
                nv.setValue(fs.getShortValue(feat));
            } else if ("uima.cas.Long".equals(rangeTypeName)) {
                nv.setValue(fs.getLongValue(feat));
            } else if ("uima.cas.Double".equals(rangeTypeName)) {
                nv.setValue(fs.getDoubleValue(feat));
            } else if ("uima.cas.String".equals(rangeTypeName)) {
                nv.setValue(fs.getStringValue(feat));
            } else {
                nv.setValue(fs.getFeatureValue(feat));
            }
            result[i++] = nv;
        }
    }

    public static Object getDebugLogicalStructure_Features(AnnotationFS fs) {
        boolean isJCasClass = false;
        Type fsType = fs.getType();
        String typeName = fsType.getName();
        if (fs.getClass().getName().equals(typeName)) {
            isJCasClass = true;
        }
        DebugNameValuePair[] result = new DebugNameValuePair[3 + (isJCasClass ? 0 : 1)];
        int i = 0;
        if (!isJCasClass) {
            result[i++] = new DebugNameValuePair("CasType", typeName);
        }
        DebugFSLogicalStructure.fillFeatures(result, i, fs, fsType.getFeatures());
        return result;
    }

    public static FeatureStructure[] getDebugLogicalStructure_SubAnnotations(AnnotationFS fs) {
        return DebugFSLogicalStructure.getIndexContents(fs.getCAS().getAnnotationIndex().subiterator(fs));
    }

    private static FeatureStructure[] getIndexContents(FSIterator<? extends FeatureStructure> it) {
        return DebugFSLogicalStructure.iteratorToArray(it, FeatureStructure.class);
    }

    private static FeatureStructure[] getIndexContents(FSIndex<? extends FeatureStructure> fsIndex) {
        return DebugFSLogicalStructure.getIndexContents(fsIndex.iterator());
    }

    public static IndexInfo[] getIndexes(CAS cas) {
        Iterator<String> it = cas.getIndexRepository().getLabels();
        ArrayList<IndexInfo> ll = new ArrayList<IndexInfo>();
        while (it.hasNext()) {
            ll.add(new IndexInfo(cas, it.next()));
        }
        return ll.toArray(new IndexInfo[ll.size()]);
    }

    public static ViewInfo[] getOtherViews(CAS cas) {
        FSIterator<SofaFS> sofaIt = cas.getSofaIterator();
        ArrayList<ViewInfo> r = new ArrayList<ViewInfo>();
        while (sofaIt.hasNext()) {
            SofaFS item = (SofaFS)sofaIt.next();
            CAS oCas = cas.getView(item);
            if (oCas == cas) continue;
            r.add(new ViewInfo(oCas));
        }
        return r.toArray(new ViewInfo[r.size()]);
    }

    private static <T> T[] iteratorToArray(Iterator<? extends T> it, Class<T> c) {
        ArrayList<T> items = new ArrayList<T>();
        while (it.hasNext()) {
            items.add(it.next());
        }
        return items.toArray((Object[])Array.newInstance(c, items.size()));
    }

    public static Object floatListToArray(FeatureStructure fs) {
        ArrayList<Float> list = new ArrayList<Float>();
        TypeSystem ts = fs.getCAS().getTypeSystem();
        Type emptyFSList = ts.getType("uima.cas.EmptyFloatList");
        Feature headFeature = ts.getFeatureByFullName("uima.cas.NonEmptyFloatList:head");
        Feature tailFeature = ts.getFeatureByFullName("uima.cas.NonEmptyFloatList:tail");
        HashSet<FeatureStructure> alreadySeen = new HashSet<FeatureStructure>();
        FeatureStructure currentFs = fs;
        while (currentFs.getType() != emptyFSList) {
            list.add(Float.valueOf(currentFs.getFloatValue(headFeature)));
            FeatureStructure nextFs = currentFs.getFeatureValue(tailFeature);
            if (alreadySeen.contains(nextFs)) {
                return DebugFSLogicalStructure.loopInList(list);
            }
            alreadySeen.add(nextFs);
            currentFs = nextFs;
        }
        float[] floatArray = new float[list.size()];
        for (int i = 0; i < floatArray.length; ++i) {
            floatArray[i] = ((Float)list.get(i)).floatValue();
        }
        return floatArray;
    }

    public static Object integerListToArray(FeatureStructure fs) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        TypeSystem ts = fs.getCAS().getTypeSystem();
        Type emptyFSList = ts.getType("uima.cas.EmptyIntegerList");
        Feature headFeature = ts.getFeatureByFullName("uima.cas.NonEmptyIntegerList:head");
        Feature tailFeature = ts.getFeatureByFullName("uima.cas.NonEmptyIntegerList:tail");
        HashSet<FeatureStructure> alreadySeen = new HashSet<FeatureStructure>();
        FeatureStructure currentFs = fs;
        while (currentFs.getType() != emptyFSList) {
            list.add(currentFs.getIntValue(headFeature));
            FeatureStructure nextFs = currentFs.getFeatureValue(tailFeature);
            if (alreadySeen.contains(nextFs)) {
                return DebugFSLogicalStructure.loopInList(list);
            }
            alreadySeen.add(nextFs);
            currentFs = nextFs;
        }
        int[] intArray = new int[list.size()];
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = (Integer)list.get(i);
        }
        return intArray;
    }

    public static Object stringListToArray(FeatureStructure fs) {
        ArrayList<String> list = new ArrayList<String>();
        TypeSystem ts = fs.getCAS().getTypeSystem();
        Type emptyFSList = ts.getType("uima.cas.EmptyStringList");
        Feature headFeature = ts.getFeatureByFullName("uima.cas.NonEmptyStringList:head");
        Feature tailFeature = ts.getFeatureByFullName("uima.cas.NonEmptyStringList:tail");
        HashSet<FeatureStructure> alreadySeen = new HashSet<FeatureStructure>();
        FeatureStructure currentFs = fs;
        while (currentFs.getType() != emptyFSList) {
            list.add(currentFs.getStringValue(headFeature));
            FeatureStructure nextFs = currentFs.getFeatureValue(tailFeature);
            if (alreadySeen.contains(nextFs)) {
                return DebugFSLogicalStructure.loopInList(list);
            }
            alreadySeen.add(nextFs);
            currentFs = nextFs;
        }
        return list.toArray(new String[list.size()]);
    }

    public static Object fsListToArray(FeatureStructure fs) {
        ArrayList<FeatureStructure> list = new ArrayList<FeatureStructure>();
        TypeSystem ts = fs.getCAS().getTypeSystem();
        Type emptyFSList = ts.getType("uima.cas.EmptyFSList");
        Feature headFeature = ts.getFeatureByFullName("uima.cas.NonEmptyFSList:head");
        Feature tailFeature = ts.getFeatureByFullName("uima.cas.NonEmptyFSList:tail");
        HashSet<FeatureStructure> alreadySeen = new HashSet<FeatureStructure>();
        FeatureStructure currentFs = fs;
        while (currentFs.getType() != emptyFSList) {
            list.add(currentFs.getFeatureValue(headFeature));
            FeatureStructure nextFs = currentFs.getFeatureValue(tailFeature);
            if (alreadySeen.contains(nextFs)) {
                return DebugFSLogicalStructure.loopInList(list);
            }
            alreadySeen.add(nextFs);
            currentFs = nextFs;
        }
        return list.toArray(new FeatureStructure[list.size()]);
    }

    private static Object loopInList(List<?> list) {
        Object[] array = new Object[list.size() + 1];
        for (int i = 0; i < list.size(); ++i) {
            Object v = list.get(i);
            array[i] = v instanceof Integer ? ((Integer)v).toString() : (v instanceof Float ? ((Float)v).toString() : list.get(i));
        }
        array[list.size()] = "... loop in list";
        return array;
    }

    public static class IndexInfo {
        public String indexName;
        public FSIndex<FeatureStructure> fsIndex;
        protected CAS cas;

        public IndexInfo(CAS cas, String indexName) {
            this(cas, indexName, null);
        }

        public IndexInfo(CAS cas, String indexName, Type type) {
            this.indexName = indexName;
            this.cas = cas;
            this.fsIndex = type == null ? cas.getIndexRepository().getIndex(indexName) : cas.getIndexRepository().getIndex(indexName, type);
        }

        public Object getKind() {
            return indexKinds[this.fsIndex.getIndexingStrategy()];
        }

        public Object getType() {
            return this.fsIndex.getType();
        }

        public Object getContents() {
            return DebugFSLogicalStructure.getIndexContents(this.fsIndex);
        }

        public Object getSubTypes() {
            FSIndexRepository ir = this.cas.getIndexRepository();
            Type type = this.fsIndex.getType();
            List<Type> subtypes = this.cas.getTypeSystem().getProperlySubsumedTypes(type);
            DebugNameValuePair[] r = new DebugNameValuePair[subtypes.size()];
            int i = 0;
            for (Type stype : subtypes) {
                r[i++] = new DebugNameValuePair("Type: " + stype.getName(), new UnexpandedFeatureStructures(ir.getIndex(this.indexName, stype)));
            }
            return r;
        }

        public String toString() {
            return this.indexName + "[" + this.fsIndex.getType().getName() + ", " + this.fsIndex.size() + " entries]";
        }
    }

    public static class ViewInfo {
        private CAS cas;

        public ViewInfo(CAS cas) {
            this.cas = cas;
        }

        public String toString() {
            SofaFS sofaFS = this.cas.getSofa();
            if (null == sofaFS) {
                return "No Sofa";
            }
            return sofaFS.getSofaID();
        }

        public Object getSofa() {
            return this.cas.getSofa();
        }
    }

    private static class UnexpandedFeatureStructures {
        private FeatureStructure[] items = null;
        private AnnotationFS constrainingFS = null;
        private boolean isContainedFS = false;
        private FSIndex<? extends FeatureStructure> fsIndex = null;
        private boolean isIndex = false;

        public UnexpandedFeatureStructures(AnnotationFS constrainingFS) {
            this.constrainingFS = constrainingFS;
            this.isContainedFS = true;
        }

        public UnexpandedFeatureStructures(FSIndex<? extends FeatureStructure> fsIndex) {
            this.fsIndex = fsIndex;
            this.isIndex = true;
        }

        public String toString() {
            if (this.isIndex) {
                return "" + this.fsIndex.size() + " entries";
            }
            return "Expand to show";
        }

        public FeatureStructure[] getItems() {
            if (null != this.items) {
                return this.items;
            }
            if (this.isContainedFS) {
                this.items = DebugFSLogicalStructure.getDebugLogicalStructure_SubAnnotations(this.constrainingFS);
                return this.items;
            }
            if (this.isIndex) {
                this.items = DebugFSLogicalStructure.getIndexContents(this.fsIndex);
                return this.items;
            }
            return null;
        }
    }
}

