/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.Recycler;
import io.github.lukehutch.fastclasspathscanner.utils.SingletonMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class NestedJarHandler {
    private final ConcurrentLinkedDeque<File> tempFiles = new ConcurrentLinkedDeque();
    private final SingletonMap<String, Map.Entry<File, Set<String>>> nestedPathToJarfileAndRootRelativePathsMap;
    private final SingletonMap<String, Recycler<ZipFile, IOException>> canonicalPathToZipFileRecyclerMap;
    private final InterruptionChecker interruptionChecker;
    private final LogNode log;
    public static final String TEMP_FILENAME_LEAF_SEPARATOR = "---";

    public NestedJarHandler(final InterruptionChecker interruptionChecker, final LogNode log) {
        this.interruptionChecker = interruptionChecker;
        this.log = log;
        this.canonicalPathToZipFileRecyclerMap = new SingletonMap<String, Recycler<ZipFile, IOException>>(){

            @Override
            public Recycler<ZipFile, IOException> newInstance(final String canonicalPath) throws Exception {
                return new Recycler<ZipFile, IOException>(){

                    @Override
                    public ZipFile newInstance() throws IOException {
                        return new ZipFile(canonicalPath);
                    }
                };
            }
        };
        this.nestedPathToJarfileAndRootRelativePathsMap = new SingletonMap<String, Map.Entry<File, Set<String>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Map.Entry<File, Set<String>> newInstance(String nestedJarPath) throws Exception {
                int lastPlingIdx = nestedJarPath.lastIndexOf(33);
                if (lastPlingIdx < 0) {
                    File canonicalFile;
                    File pathFile;
                    boolean isRemote = nestedJarPath.startsWith("http://") || nestedJarPath.startsWith("https://");
                    File file = pathFile = isRemote ? NestedJarHandler.this.downloadTempFile(nestedJarPath, log) : new File(nestedJarPath);
                    if (isRemote && pathFile == null) {
                        if (log == null) return null;
                        log.log(nestedJarPath, "Could not download jarfile " + nestedJarPath);
                        return null;
                    }
                    try {
                        canonicalFile = pathFile.getCanonicalFile();
                    }
                    catch (IOException | SecurityException e) {
                        if (log == null) return null;
                        log.log(nestedJarPath, "Path component " + nestedJarPath + " could not be canonicalized: " + e);
                        return null;
                    }
                    if (!ClasspathUtils.canRead(canonicalFile)) {
                        if (log == null) return null;
                        log.log(nestedJarPath, "Path component " + nestedJarPath + " does not exist");
                        return null;
                    }
                    if (!canonicalFile.isFile()) {
                        if (log == null) return null;
                        log.log(nestedJarPath, "Path component " + nestedJarPath + "  is not a file (expected a jarfile)");
                        return null;
                    }
                    File bareZipfile = NestedJarHandler.this.stripSFXHeader(canonicalFile, log);
                    HashSet rootRelativePaths = new HashSet();
                    return new AbstractMap.SimpleEntry<File, Set<String>>(bareZipfile, rootRelativePaths);
                }
                String parentPath = nestedJarPath.substring(0, lastPlingIdx);
                String childPath = nestedJarPath.substring(lastPlingIdx + 1);
                if (childPath.startsWith("/")) {
                    childPath = childPath.substring(1);
                }
                try {
                    Map.Entry parentJarfileAndRootRelativePaths = (Map.Entry)NestedJarHandler.this.nestedPathToJarfileAndRootRelativePathsMap.getOrCreateSingleton(parentPath);
                    File parentJarfile = (File)parentJarfileAndRootRelativePaths.getKey();
                    if (parentJarfile == null) {
                        return null;
                    }
                    if (!parentJarfile.getPath().equals(parentPath)) {
                        return (Map.Entry)NestedJarHandler.this.nestedPathToJarfileAndRootRelativePathsMap.getOrCreateSingleton(parentJarfile.getPath() + "!" + childPath);
                    }
                    Recycler parentJarRecycler = (Recycler)NestedJarHandler.this.canonicalPathToZipFileRecyclerMap.getOrCreateSingleton(parentJarfile.getCanonicalPath());
                    ZipFile parentZipFile = null;
                    try {
                        parentZipFile = (ZipFile)parentJarRecycler.acquire();
                        ZipEntry childZipEntry = parentZipFile.getEntry(childPath);
                        if (childZipEntry == null) {
                            if (log != null) {
                                log.log(nestedJarPath, "Child path component " + childPath + " does not exist in jarfile " + parentPath);
                            }
                            Map.Entry<File, Set<String>> entry = null;
                            return entry;
                        }
                        if (childZipEntry.isDirectory()) {
                            if (log != null) {
                                log.log(nestedJarPath, "Child path component " + childPath + " in jarfile " + parentPath + " is a directory, not a file -- using as scanning root");
                            }
                            ((Set)parentJarfileAndRootRelativePaths.getValue()).add(childPath);
                            Map.Entry entry = parentJarfileAndRootRelativePaths;
                            return entry;
                        }
                        File childTempFile = NestedJarHandler.this.unzipToTempFile(parentZipFile, childZipEntry);
                        if (interruptionChecker.checkAndReturn()) {
                            Map.Entry<File, Set<String>> entry = null;
                            return entry;
                        }
                        HashSet rootRelativePaths = new HashSet();
                        AbstractMap.SimpleEntry<File, Set<String>> simpleEntry = new AbstractMap.SimpleEntry<File, Set<String>>(childTempFile, rootRelativePaths);
                        return simpleEntry;
                    }
                    finally {
                        parentJarRecycler.release(parentZipFile);
                    }
                }
                catch (InterruptedException e) {
                    interruptionChecker.interrupt();
                    throw e;
                }
            }
        };
    }

    public Recycler<ZipFile, IOException> getZipFileRecycler(String canonicalPath) throws Exception {
        try {
            return this.canonicalPathToZipFileRecyclerMap.getOrCreateSingleton(canonicalPath);
        }
        catch (InterruptedException e) {
            this.interruptionChecker.interrupt();
            throw e;
        }
    }

    public Map.Entry<File, Set<String>> getInnermostNestedJar(String nestedJarPath) throws Exception {
        try {
            return this.nestedPathToJarfileAndRootRelativePathsMap.getOrCreateSingleton(nestedJarPath);
        }
        catch (InterruptedException e) {
            this.interruptionChecker.interrupt();
            throw e;
        }
    }

    private File downloadTempFile(String jarURL, LogNode log) {
        LogNode subLog = log == null ? null : log.log(jarURL, "Downloading URL " + jarURL);
        File tempFile = null;
        try {
            String suffix = TEMP_FILENAME_LEAF_SEPARATOR + jarURL.replace('/', '_').replace(':', '_').replace('?', '_').replace('&', '_').replace('=', '_');
            tempFile = File.createTempFile("FastClasspathScanner-", suffix);
            tempFile.deleteOnExit();
            this.tempFiles.add(tempFile);
            URL url = new URL(jarURL);
            try (InputStream inputStream = url.openStream();){
                Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            if (subLog != null) {
                subLog.addElapsedTime();
            }
        }
        catch (Exception e) {
            if (subLog != null) {
                subLog.log("Could not download " + jarURL, e);
            }
            return null;
        }
        if (subLog != null) {
            subLog.log("Downloaded to temporary file " + tempFile);
            subLog.log("***** Note that it is time-consuming to scan jars at http(s) addresses, they must be downloaded for every scan, and the same jars must also be separately downloaded by the ClassLoader *****");
        }
        return tempFile;
    }

    public File unzipToTempFile(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        String zipEntryPath = zipEntry.getName();
        if (zipEntryPath.startsWith("/")) {
            zipEntryPath = zipEntryPath.substring(1);
        }
        String zipEntryLeaf = zipEntryPath.substring(zipEntryPath.lastIndexOf(47) + 1);
        File tempFile = File.createTempFile("FastClasspathScanner-", TEMP_FILENAME_LEAF_SEPARATOR + zipEntryLeaf);
        tempFile.deleteOnExit();
        this.tempFiles.add(tempFile);
        LogNode subLog = null;
        if (this.log != null) {
            String qualifiedPath = zipFile.getName() + "!/" + zipEntryPath;
            subLog = this.log.log(qualifiedPath, "Unzipping zip entry " + qualifiedPath);
            subLog.log("Extracted to temporary file " + tempFile.getPath());
        }
        try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
            Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if (subLog != null) {
            subLog.addElapsedTime();
        }
        return tempFile;
    }

    private File stripSFXHeader(File zipfile, LogNode log) throws IOException {
        long sfxHeaderBytes = JarUtils.countBytesBeforePKMarker(zipfile);
        if (sfxHeaderBytes == 0L) {
            return zipfile;
        }
        File bareZipfile = File.createTempFile("FastClasspathScanner-", TEMP_FILENAME_LEAF_SEPARATOR + JarUtils.leafName(zipfile.getName()));
        bareZipfile.deleteOnExit();
        this.tempFiles.add(bareZipfile);
        if (log != null) {
            log.log("Zipfile " + zipfile + " contains an SFX header of " + sfxHeaderBytes + " bytes. Stripping off header to create bare zipfile " + bareZipfile);
        }
        JarUtils.stripSFXHeader(zipfile, sfxHeaderBytes, bareZipfile);
        return bareZipfile;
    }

    public void close(LogNode log) {
        LogNode rmLog;
        LogNode logNode = rmLog = this.tempFiles.isEmpty() || log == null ? null : log.log("Removing temporary files");
        while (!this.tempFiles.isEmpty()) {
            File head = this.tempFiles.remove();
            String string = head.getPath();
            boolean success = head.delete();
            if (log == null) continue;
            rmLog.log((success ? "Removed" : "Unable to remove") + " " + string);
        }
        try {
            for (Recycler recycler : this.canonicalPathToZipFileRecyclerMap.values()) {
                recycler.close();
            }
            this.canonicalPathToZipFileRecyclerMap.clear();
        }
        catch (InterruptedException e) {
            this.interruptionChecker.interrupt();
        }
    }
}

