/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import com.ximpleware.NavException;
import com.ximpleware.XPathEvalException;
import com.ximpleware.extended.AutoPilotHuge;
import com.ximpleware.extended.NavExceptionHuge;
import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import com.ximpleware.extended.XPathParseExceptionHuge;
import de.julielab.xml.AbstractFieldValueSource;
import de.julielab.xml.FieldValueRetrievalException;
import de.julielab.xml.JulieXMLBuffer;
import de.julielab.xml.JulieXMLTools;
import de.julielab.xml.Options;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

class XPathNavigatorHuge
extends AbstractFieldValueSource {
    private VTDNavHuge vn;
    private AutoPilotHuge apFE;
    private AutoPilotHuge apXP;
    private Options options;

    public XPathNavigatorHuge(VTDNavHuge nv, AutoPilotHuge apForEach, AutoPilotHuge apXPath, Options options) throws XPathEvalException, NavException, XPathEvalExceptionHuge, NavExceptionHuge, XPathParseExceptionHuge {
        this.vn = nv;
        this.apFE = apForEach;
        this.apXP = apXPath;
        if (this.apFE == null) {
            this.apFE = this.apXP;
            this.apXP = new AutoPilotHuge(this.vn);
            this.apXP.selectXPath(".");
        }
        this.options = options;
    }

    @Override
    public Object getFieldValue() throws FieldValueRetrievalException {
        ArrayList<String> retList = new ArrayList<String>();
        try {
            while (this.apFE.evalXPath() != -1) {
                if (this.options.returnXMLFragment) {
                    long[] fragment = this.vn.getElementFragment();
                    long offset = fragment[0];
                    long length = fragment[1];
                    try {
                        JulieXMLBuffer mb = (JulieXMLBuffer)this.vn.getXML();
                        byte[] fragmentBytes = mb.getFragment(offset, length);
                        retList.add(new String(fragmentBytes));
                    }
                    catch (ClassCastException e) {
                        JulieXMLTools.LOG.error("Casting from com.ximpleware.extended.IByteBuffer to " + JulieXMLBuffer.class.getName() + " failed. You must pass an Instance of" + JulieXMLBuffer.class.getName() + " to the VTDGenHuge object which contains the XML data to be parsed.");
                        e.printStackTrace();
                    }
                } else {
                    retList.add(this.apXP.evalXPathToString());
                }
                this.apXP.resetXPath();
            }
        }
        catch (NavExceptionHuge | XPathEvalExceptionHuge | IOException e) {
            throw new FieldValueRetrievalException(e);
        }
        this.apFE.resetXPath();
        Object retobj = null;
        if (retList.size() > 0) {
            retobj = this.options.returnArray ? retList.toArray(new String[retList.size()]) : (retList.size() > 1 ? StringUtils.join(retList, this.options.concatString) : retList.get(0));
            if (this.options.performGzip) {
                return this.gzipContent(retobj);
            }
            return retobj;
        }
        return null;
    }
}

