/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.util;

import de.julielab.jcore.pipeline.builder.cli.util.PrintElement;
import de.julielab.jcore.pipeline.builder.cli.util.PrintLine;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.beryx.textio.InputReader;
import org.beryx.textio.TextIO;

public class TextIOUtils {
    public static void printLines(Stream<PrintLine> records, TextIO textIO) {
        String LS = System.getProperty("line.separator");
        records.forEach(line -> {
            line.forEach(record -> textIO.getTextTerminal().executeWithPropertiesPrefix(record.getPrefix(), t -> t.print(record != null && record.getText() != null ? record.getText() : "<null>")));
            textIO.getTextTerminal().executeWithPropertiesPrefix("default", t -> t.print(LS));
        });
    }

    public static List<PrintElement> createPrintElements(String ... input) {
        PrintLine elements = new PrintLine();
        for (int i = 0; i < input.length; ++i) {
            String s = input[i];
            if (i % 2 != 1) continue;
            elements.add(new PrintElement(input[i - 1], input[i]));
        }
        return elements;
    }

    public static PrintLine createPrintLine(String ... input) {
        return (PrintLine)TextIOUtils.createPrintElements(input);
    }

    public static PrintElement createPrintElement(String text, String prefix) {
        return new PrintElement(text, prefix);
    }

    public static void printElements(Stream<PrintElement> printElements, TextIO textIO) {
        printElements.forEach(e -> textIO.getTextTerminal().executeWithPropertiesPrefix(e.getPrefix(), t -> t.print(e.getText())));
    }

    public static class EmptyStringParser<T>
    implements Function<String, InputReader.ParseResult<Object>> {
        public static final Object EMPTY_VALUE = new Object();
        private Function<String, T> converter;
        private String typeName;

        public EmptyStringParser(Function<String, T> converter, String typeName) {
            this.converter = converter;
            this.typeName = typeName;
        }

        @Override
        public InputReader.ParseResult<Object> apply(String s) {
            if (s.isEmpty()) {
                return new InputReader.ParseResult<Object>(EMPTY_VALUE);
            }
            try {
                T convertedValue = this.converter.apply(s);
                return new InputReader.ParseResult<Object>(convertedValue);
            }
            catch (NumberFormatException e) {
                return new InputReader.ParseResult<Object>(EMPTY_VALUE, "Enter a " + this.typeName + " value.");
            }
        }
    }
}

