/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities.prerequisites;

import de.julielab.java.utilities.prerequisites.ParameterChecker;
import de.julielab.java.utilities.prerequisites.PrerequisiteChecker;
import de.julielab.java.utilities.prerequisites.SupplierChecker;
import java.util.function.Supplier;

public class NullChecker<T>
extends ParameterChecker {
    public NullChecker(PrerequisiteChecker prerequisiteChecker, T ... objects) {
        super(prerequisiteChecker, objects);
    }

    static void check(PrerequisiteChecker prerequisiteChecker, Object item, String name) {
        if (item == null) {
            prerequisiteChecker.addErrorMessage("The object with name \"" + name + "\" is null.");
        }
    }

    @Override
    public void check() {
        if (this.items.length == 0) {
            NullChecker.check(this.prerequisiteChecker, null, this.getName(0));
        }
        for (int i = 0; i < this.items.length; ++i) {
            Object object = this.items[i];
            String name = this.getName(i);
            NullChecker.check(this.prerequisiteChecker, object, name);
            if (!(object instanceof Supplier)) continue;
            SupplierChecker.get(this.prerequisiteChecker, (Supplier)object, name).ifPresent(o -> NullChecker.check(this.prerequisiteChecker, o, name));
        }
    }
}

