/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.xpath;

import com.ximpleware.Expr;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;

public class UnaryExpr
extends Expr {
    public int op;
    public Expr operand;

    public UnaryExpr(int n, Expr expr) {
        this.op = n;
        this.operand = expr;
    }

    @Override
    public final String toString() {
        return "-" + this.operand;
    }

    @Override
    public final boolean evalBoolean(VTDNav vTDNav) {
        return this.operand.evalBoolean(vTDNav);
    }

    @Override
    public final double evalNumber(VTDNav vTDNav) {
        return -1.0 * this.operand.evalNumber(vTDNav);
    }

    @Override
    public final int evalNodeSet(VTDNav vTDNav) throws XPathEvalException {
        throw new XPathEvalException("UnaryExpr can't eval to a node set!");
    }

    @Override
    public final String evalString(VTDNav vTDNav) {
        double d = this.operand.evalNumber(vTDNav);
        if (d == (double)((int)d)) {
            return "" + (int)d;
        }
        return "" + d;
    }

    @Override
    public final void reset(VTDNav vTDNav) {
        this.operand.reset(vTDNav);
    }

    @Override
    public final boolean isNodeSet() {
        return false;
    }

    @Override
    public final boolean isNumerical() {
        return true;
    }

    @Override
    public final boolean isString() {
        return false;
    }

    @Override
    public final boolean isBoolean() {
        return false;
    }

    @Override
    public final boolean requireContextSize() {
        return this.operand.requireContextSize();
    }

    @Override
    public final void setContextSize(int n) {
        this.operand.setContextSize(n);
    }

    @Override
    public final void setPosition(int n) {
        this.operand.setPosition(n);
    }

    @Override
    public final int adjust(int n) {
        return 0;
    }

    @Override
    public final boolean isFinal() {
        return this.operand.isFinal();
    }

    @Override
    public final void markCacheable() {
        this.operand.markCacheable();
    }

    @Override
    public final void markCacheable2() {
        this.operand.markCacheable2();
    }

    @Override
    public final void clearCache() {
        this.operand.clearCache();
    }
}

