/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Collection;
import org.apache.uima.UIMAFramework;
import org.apache.uima.fit.factory.ConfigurationParameterFactory;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;

public final class ResourceCreationSpecifierFactory {
    private ResourceCreationSpecifierFactory() {
    }

    public static ResourceCreationSpecifier createResourceCreationSpecifier(URL descriptorURL, Object[] parameters) throws InvalidXMLException, IOException {
        return ResourceCreationSpecifierFactory.createResourceCreationSpecifier(new XMLInputSource(descriptorURL), parameters);
    }

    public static ResourceCreationSpecifier createResourceCreationSpecifier(XMLInputSource xmlInput, Object[] parameters) throws InvalidXMLException {
        ConfigurationParameterFactory.ensureParametersComeInPairs(parameters);
        XMLParser parser2 = UIMAFramework.getXMLParser();
        ResourceCreationSpecifier specifier = (ResourceCreationSpecifier)parser2.parseResourceSpecifier(xmlInput);
        ResourceCreationSpecifierFactory.setConfigurationParameters(specifier, parameters);
        return specifier;
    }

    public static ResourceCreationSpecifier createResourceCreationSpecifier(String descriptorPath, Object[] parameters) throws InvalidXMLException, IOException {
        return ResourceCreationSpecifierFactory.createResourceCreationSpecifier(new XMLInputSource(descriptorPath), parameters);
    }

    public static void setConfigurationParameters(ResourceCreationSpecifier specifier, Object ... configurationData) {
        if (configurationData == null || configurationData.length == 0) {
            return;
        }
        ConfigurationParameterFactory.ensureParametersComeInPairs(configurationData);
        ConfigurationParameter[] configurationParameters = new ConfigurationParameter[configurationData.length / 2];
        Object[] configurationValues = new Object[configurationData.length / 2];
        for (int i = 0; i < configurationValues.length; ++i) {
            ConfigurationParameter param;
            String name = (String)configurationData[i * 2];
            Object value = configurationData[i * 2 + 1];
            configurationParameters[i] = param = ConfigurationParameterFactory.createPrimitiveParameter(name, value.getClass(), null, false);
            configurationValues[i] = ConfigurationParameterFactory.convertParameterValue(param, value);
        }
        ResourceCreationSpecifierFactory.setConfigurationParameters(specifier, configurationParameters, configurationValues);
    }

    public static void setConfigurationParameters(ResourceCreationSpecifier specifier, ConfigurationParameter[] configurationParameters, Object[] configurationValues) {
        ResourceCreationSpecifierFactory.setConfigurationParameters(specifier.getMetaData(), configurationParameters, configurationValues);
    }

    public static void setConfigurationParameters(ResourceMetaData metaData, ConfigurationParameter[] configurationParameters, Object[] configurationValues) {
        ConfigurationParameterDeclarations paramDecls = metaData.getConfigurationParameterDeclarations();
        ConfigurationParameterSettings paramSettings = metaData.getConfigurationParameterSettings();
        for (int i = 0; i < configurationParameters.length; ++i) {
            Object value;
            ConfigurationParameter decl = paramDecls.getConfigurationParameter(null, configurationParameters[i].getName());
            if (paramDecls != null && decl == null) {
                paramDecls.addConfigurationParameter(configurationParameters[i]);
                decl = configurationParameters[i];
            }
            if ((value = configurationValues[i]) != null && decl.isMultiValued() && !ResourceCreationSpecifierFactory.isMultiValue(value)) {
                value = Array.newInstance(value.getClass(), 1);
                Array.set(value, 0, configurationValues[i]);
            }
            paramSettings.setParameterValue(configurationParameters[i].getName(), value);
        }
    }

    private static boolean isMultiValue(Object aObject) {
        if (aObject != null) {
            return aObject instanceof Collection || aObject.getClass().isArray();
        }
        return false;
    }
}

