/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.metadata.cpe;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.collection.impl.metadata.cpe.CasProcessorCpeObject;
import org.apache.uima.collection.impl.metadata.cpe.CpeDescriptorFactory;
import org.apache.uima.collection.impl.metadata.cpe.NameValuePairImpl;
import org.apache.uima.collection.metadata.CasProcessorDeploymentParam;
import org.apache.uima.collection.metadata.CasProcessorDeploymentParams;
import org.apache.uima.collection.metadata.CasProcessorExecArg;
import org.apache.uima.collection.metadata.CasProcessorExecutable;
import org.apache.uima.collection.metadata.CasProcessorRunInSeperateProcess;
import org.apache.uima.collection.metadata.CasProcessorRuntimeEnvParam;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.collection.metadata.CpeLocalCasProcessor;
import org.apache.uima.collection.metadata.NameValuePair;

public class CpeLocalCasProcessorImpl
extends CasProcessorCpeObject
implements CpeLocalCasProcessor {
    private static final long serialVersionUID = -2239520502855587544L;

    public CpeLocalCasProcessorImpl() {
        try {
            super.setDeployment("local");
            this.addDefaults();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CpeLocalCasProcessorImpl(boolean initializeWithDefaultValues) {
        try {
            super.setDeployment("local");
            if (initializeWithDefaultValues) {
                this.addDefaults();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected CpeLocalCasProcessorImpl(String aName, String aSoFa) throws CpeDescriptorException {
        try {
            super.setName(aName);
            super.setDeployment("local");
            this.addDefaults();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CpeDescriptorException(e.getMessage());
        }
    }

    private CasProcessorRunInSeperateProcess getBaseRunInSeperateProcess() throws CpeDescriptorException {
        CasProcessorRunInSeperateProcess sepProcess = this.getRunInSeperateProcess();
        if (sepProcess == null) {
            sepProcess = CpeDescriptorFactory.produceRunInSeperateProcess();
            CasProcessorExecutable exe = CpeDescriptorFactory.produceCasProcessorExecutable();
            exe.setExecutable("default");
            sepProcess.setExecutable(exe);
            this.setRunInSeperateProcess(sepProcess);
        }
        return sepProcess;
    }

    @Override
    public void addExecArg(String aArgValue) throws CpeDescriptorException {
        CasProcessorRunInSeperateProcess sepProcess = this.getBaseRunInSeperateProcess();
        CasProcessorExecutable exe = sepProcess.getExecutable();
        CasProcessorExecArg execArg = CpeDescriptorFactory.produceCasProcessorExecArg();
        execArg.setArgValue(aArgValue);
        exe.addCasProcessorExecArg(execArg);
    }

    public void removeExecArg(int aIndex) throws CpeDescriptorException {
        CasProcessorExecutable exe;
        CasProcessorRunInSeperateProcess rip = this.getRunInSeparateProcess();
        if (rip != null && (exe = rip.getExecutable()) != null) {
            exe.removeCasProcessorExecArg(aIndex);
        }
    }

    public List getExecArgs() throws CpeDescriptorException {
        CasProcessorExecutable exe;
        ArrayList<CasProcessorExecArg> list = new ArrayList<CasProcessorExecArg>();
        CasProcessorRunInSeperateProcess rip = this.getRunInSeparateProcess();
        if (rip != null && (exe = rip.getExecutable()) != null) {
            CasProcessorExecArg[] args = exe.getAllCasProcessorExecArgs();
            for (int i = 0; args != null && i < args.length; ++i) {
                list.add(args[i]);
            }
        }
        return list;
    }

    @Override
    protected void addDefaults() throws CpeDescriptorException {
        if (this.getRunInSeperateProcess() == null) {
            CasProcessorRunInSeperateProcess sepProcess = CpeDescriptorFactory.produceRunInSeperateProcess();
            CasProcessorExecutable exe = CpeDescriptorFactory.produceCasProcessorExecutable();
            exe.setExecutable("default");
            sepProcess.setExecutable(exe);
            this.setRunInSeperateProcess(sepProcess);
        }
        if (this.getDeploymentParams() == null) {
            CasProcessorDeploymentParams deployParams = CpeDescriptorFactory.produceDeployParams();
            CasProcessorDeploymentParam param = CpeDescriptorFactory.produceDeployParam();
            param.setParameterName("vnsHost");
            param.setParameterType("String");
            param.setParameterValue("127.0.0.1");
            deployParams.add(param);
            param = CpeDescriptorFactory.produceDeployParam();
            param.setParameterName("vnsPort");
            param.setParameterType("String");
            param.setParameterValue("9904");
            deployParams.add(param);
            this.setDeploymentParams(deployParams);
        }
        super.addDefaults();
    }

    @Override
    public boolean isJava() throws CpeDescriptorException {
        CasProcessorExecutable exe;
        CasProcessorRunInSeperateProcess rip = this.getRunInSeparateProcess();
        if (rip != null && (exe = rip.getExecutable()) != null) {
            return exe.getExecutable().equalsIgnoreCase("java");
        }
        return false;
    }

    @Override
    public void addExecEnv(String aEnvKeyName, String aEnvKeyValue) throws CpeDescriptorException {
        CasProcessorExecutable exe;
        CasProcessorRunInSeperateProcess rip = this.getRunInSeparateProcess();
        if (rip != null && (exe = rip.getExecutable()) != null) {
            NameValuePair nvp;
            ArrayList<CasProcessorRuntimeEnvParam> envs = exe.getEnvs();
            boolean replacedExisiting = false;
            for (int i = 0; envs != null && i < envs.size(); ++i) {
                nvp = (NameValuePair)((Object)envs.get(i));
                if (!nvp.getName().equals(aEnvKeyName)) continue;
                nvp.setValue(aEnvKeyValue);
                replacedExisiting = true;
                break;
            }
            if (envs != null && !replacedExisiting) {
                nvp = new NameValuePairImpl(aEnvKeyName, aEnvKeyValue);
                envs.add((CasProcessorRuntimeEnvParam)((Object)nvp));
            }
        }
    }

    public List getExecEnv() throws CpeDescriptorException {
        CasProcessorExecutable exe;
        CasProcessorRunInSeperateProcess rip = this.getRunInSeparateProcess();
        if (rip != null && (exe = rip.getExecutable()) != null) {
            return exe.getEnvs();
        }
        return new ArrayList();
    }

    public void removeExecEnv(int aIndex) throws CpeDescriptorException {
        CasProcessorExecutable exe;
        CasProcessorRunInSeperateProcess rip = this.getRunInSeparateProcess();
        if (rip != null && (exe = rip.getExecutable()) != null) {
            if (aIndex > exe.getEnvs().size()) {
                return;
            }
            exe.getEnvs().remove(aIndex);
        }
    }

    @Override
    public void setExecutable(String aCasProcessorExecutable) throws CpeDescriptorException {
        CasProcessorExecutable exe;
        CasProcessorRunInSeperateProcess rip = this.getRunInSeparateProcess();
        if (rip != null && (exe = rip.getExecutable()) != null) {
            exe.setExecutable(aCasProcessorExecutable);
        }
    }

    @Override
    public String getExecutable() throws CpeDescriptorException {
        CasProcessorExecutable exe;
        CasProcessorRunInSeperateProcess rip = this.getRunInSeparateProcess();
        if (rip != null && (exe = rip.getExecutable()) != null) {
            return exe.getExecutable();
        }
        return null;
    }

    @Override
    public void setIsJava(boolean aJava) throws CpeDescriptorException {
        CasProcessorExecutable exe;
        CasProcessorRunInSeperateProcess rip = this.getRunInSeparateProcess();
        if (rip != null && (exe = rip.getExecutable()) != null && aJava) {
            exe.setExecutable("java");
        }
    }

    @Override
    public void setRunInSeperateProcess(CasProcessorRunInSeperateProcess aSepProcess) throws CpeDescriptorException {
        super.setRunInSeparateProcess(aSepProcess);
    }

    @Override
    public CasProcessorRunInSeperateProcess getRunInSeperateProcess() throws CpeDescriptorException {
        return super.getRunInSeparateProcess();
    }
}

