/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.base.main;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.julielab.jcore.pipeline.builder.base.configurations.PipelineBuilderConstants;
import de.julielab.jcore.pipeline.builder.base.main.ComponentRepository;
import de.julielab.jcore.pipeline.builder.base.main.GitHubRepository;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Repositories {
    public static final ComponentRepository[] JCORE_REPOSITORIES = new ComponentRepository[]{new GitHubRepository("jcore-base", "2.3.0-SNAPSHOT", "JULIELab"), new GitHubRepository("jcore-projects", "2.3.0-SNAPSHOT", "JULIELab")};
    private static final Logger log = LoggerFactory.getLogger(Repositories.class);

    private Repositories() {
    }

    public static ComponentRepository[] findRepositories() {
        File repositoriesFile = new File(PipelineBuilderConstants.JcoreMeta.LOCAL_STORAGE + File.separator + "repositories.json");
        ObjectMapper om = new ObjectMapper();
        try {
            if (repositoriesFile.exists()) {
                return om.readValue(repositoriesFile, ComponentRepository[].class);
            }
            om.writeValue(new FileOutputStream(repositoriesFile), (Object)JCORE_REPOSITORIES);
            return JCORE_REPOSITORIES;
        }
        catch (IOException e) {
            log.error("Could not load available repositories: ", e);
            return new ComponentRepository[0];
        }
    }

    public static ComponentRepository[] addRepositories(ComponentRepository ... repositories) throws IOException {
        File repositoriesFile = new File(PipelineBuilderConstants.JcoreMeta.LOCAL_STORAGE + File.separator + "repositories.json");
        ObjectMapper om = new ObjectMapper();
        if (repositoriesFile.exists()) {
            List<ComponentRepository> repositoryList = Stream.concat(Stream.of((Object[])om.readValue(repositoriesFile, ComponentRepository[].class)), Stream.of(repositories)).collect(Collectors.toList());
            om.writeValue(new FileOutputStream(repositoriesFile), repositoryList);
            return repositoryList.toArray(new ComponentRepository[repositoryList.size()]);
        }
        om.writeValue(new FileOutputStream(repositoriesFile), (Object)repositories);
        return repositories;
    }

    public static File getJcoreMetaFile(ComponentRepository repository) {
        return new File(new StringJoiner(File.separator).add(PipelineBuilderConstants.JcoreMeta.LOCAL_STORAGE).add(repository.getName()).add(repository.getVersion()).add("componentlist.json").toString());
    }

    static {
        File localdir = new File(PipelineBuilderConstants.JcoreMeta.LOCAL_STORAGE);
        if (!localdir.exists()) {
            localdir.mkdirs();
        }
    }
}

