/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.beryx.textio.InputReader;
import org.beryx.textio.TextTerminal;

public abstract class ComparableInputReader<T extends Comparable<T>, B extends ComparableInputReader<T, B>>
extends InputReader<T, B> {
    protected T minVal;
    protected T maxVal;

    protected abstract String typeNameWithIndefiniteArticle();

    public ComparableInputReader(Supplier<TextTerminal<?>> textTerminalSupplier) {
        super(textTerminalSupplier);
        this.parseErrorMessagesProvider = (val, propName) -> Arrays.asList(this.getDefaultErrorMessage(val), this.getStandardMinMaxErrorMessage());
        this.valueCheckers.add((val, propName) -> this.getMinMaxErrorMessage(val));
    }

    public B withMinVal(T minVal) {
        this.minVal = minVal;
        return (B)this;
    }

    public B withMaxVal(T maxVal) {
        this.maxVal = maxVal;
        return (B)this;
    }

    protected List<String> getMinMaxErrorMessage(T val) {
        if (this.isInRange(val)) {
            return null;
        }
        return Collections.singletonList(this.getStandardMinMaxErrorMessage());
    }

    private String getStandardMinMaxErrorMessage() {
        if (this.minVal != null && this.maxVal != null) {
            return "Expected " + this.typeNameWithIndefiniteArticle() + " value between " + this.minVal + " and " + this.maxVal + ".";
        }
        if (this.minVal != null) {
            return "Expected " + this.typeNameWithIndefiniteArticle() + " value greater than or equal to " + this.minVal + ".";
        }
        if (this.maxVal != null) {
            return "Expected " + this.typeNameWithIndefiniteArticle() + " value less than or equal to " + this.maxVal + ".";
        }
        return "Expected " + this.typeNameWithIndefiniteArticle() + " value.";
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException {
        super.checkConfiguration();
        if (this.minVal != null && this.maxVal != null && this.minVal.compareTo(this.maxVal) > 0) {
            throw new IllegalArgumentException("minVal = " + this.minVal + ", maxVal = " + this.maxVal);
        }
    }

    public boolean isInRange(T val) {
        return !(this.minVal != null && this.minVal.compareTo(val) > 0 || this.maxVal != null && this.maxVal.compareTo(val) < 0);
    }
}

