/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.cli.menu.BackMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.ParameterEditingMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ILoopableDialog;
import de.julielab.jcore.pipeline.builder.cli.util.StatusPrinter;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.uima.resource.ConfigurableDataResourceSpecifier;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.FileResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ExternalResourceBinding;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalResourceConfigurationDialog
implements ILoopableDialog {
    private static final Logger log = LoggerFactory.getLogger(ExternalResourceConfigurationDialog.class);
    private Description description;
    private ExternalResourceDescription resourceDescription;

    public ExternalResourceConfigurationDialog(Description description, ExternalResourceDescription resourceDescription) {
        this.description = description;
        this.resourceDescription = resourceDescription;
    }

    @Override
    public IMenuItem executeMenuItem(TextIO textIO, Deque<String> path) {
        StatusPrinter.printComponentStatus(this.description, textIO);
        ArrayList<IMenuItem> itemList = new ArrayList<IMenuItem>();
        IMenuItem resourceUrlItem = new IMenuItem(){

            @Override
            public String getName() {
                return "Resource Url";
            }

            public String toString() {
                return this.getName();
            }
        };
        IMenuItem resourceNameItem = new IMenuItem(){

            @Override
            public String getName() {
                return "Resource Name";
            }

            public String toString() {
                return this.getName();
            }
        };
        IMenuItem resourceDescItem = new IMenuItem(){

            @Override
            public String getName() {
                return "Resource Description";
            }

            public String toString() {
                return this.getName();
            }
        };
        itemList.add(resourceUrlItem);
        itemList.add(resourceNameItem);
        itemList.add(resourceDescItem);
        if (this.resourceDescription.getResourceSpecifier() instanceof FileResourceSpecifier) {
            IMenuItem response = (IMenuItem)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(itemList)).read("Select the parameter you want to change:");
            if (response.equals(resourceUrlItem)) {
                FileResourceSpecifier spec = (FileResourceSpecifier)this.resourceDescription.getResourceSpecifier();
                String url = (String)textIO.newStringInputReader().read("Enter the new file URL:");
                spec.setFileUrl(url);
            } else if (response.equals(resourceNameItem)) {
                this.renameExternalResource(textIO);
            } else if (response.equals(resourceDescItem)) {
                String desc = (String)textIO.newStringInputReader().read("Enter the new resource description:");
                this.resourceDescription.setDescription(desc);
            }
            return new BackMenuItem();
        }
        if (this.resourceDescription.getResourceSpecifier() instanceof ConfigurableDataResourceSpecifier) {
            ConfigurableDataResourceSpecifier spec = (ConfigurableDataResourceSpecifier)this.resourceDescription.getResourceSpecifier();
            Stream.of(spec.getMetaData().getConfigurationParameterDeclarations().getConfigurationParameters()).map(p -> new ParameterEditingMenuItem(this.resourceDescription.getResourceSpecifier(), (ConfigurationParameter)p)).forEach(itemList::add);
            itemList.add(new BackMenuItem());
            IMenuItem response = (IMenuItem)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(itemList)).read("Select the parameter you want to change:");
            if (response.equals(resourceUrlItem)) {
                String url = (String)textIO.newStringInputReader().read("Enter the new resource URL:");
                spec.setUrl(url);
            } else if (response.equals(resourceNameItem)) {
                this.renameExternalResource(textIO);
            } else if (response.equals(resourceDescItem)) {
                String desc = (String)textIO.newStringInputReader().read("Enter the new resource description:");
                this.resourceDescription.setDescription(desc);
            } else if (response instanceof ParameterEditingMenuItem) {
                ParameterEditingMenuItem item = (ParameterEditingMenuItem)response;
                item.setParameterValue(textIO);
            } else {
                return response;
            }
            this.clearTerminal(textIO);
            return response;
        }
        return new BackMenuItem();
    }

    private void renameExternalResource(TextIO textIO) {
        String oldname = this.resourceDescription.getName();
        String name = (String)textIO.newStringInputReader().read("Enter the new resource name:");
        this.resourceDescription.setName(name);
        Optional<ExternalResourceBinding> any = Stream.of(this.description.getDescriptorAsAnalysisEngineDescription().getResourceManagerConfiguration().getExternalResourceBindings()).filter(binding -> binding.getResourceName().equals(oldname)).findAny();
        if (any.isPresent()) {
            any.get().setResourceName(name);
        }
    }

    @Override
    public String getName() {
        return "Configure External Resource";
    }

    public String toString() {
        return this.getName();
    }
}

