/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.exceptions.DescriptorLoadingException;
import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.base.main.MetaDescription;
import de.julielab.jcore.pipeline.builder.cli.menu.DescriptorSelectionMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.MenuItemList;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.IMenuDialog;
import java.util.Deque;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;

public class SingleDescriptionSelectionDialog
implements IMenuDialog {
    private final MenuItemList<DescriptorSelectionMenuItem> menuItems;
    private MetaDescription metaDescription;

    public SingleDescriptionSelectionDialog(MetaDescription metaDescription, Predicate<Description> descriptionFilter) throws DescriptorLoadingException {
        this.metaDescription = metaDescription;
        this.menuItems = metaDescription.getJCoReDescriptions().stream().filter(descriptionFilter).map(DescriptorSelectionMenuItem::new).sorted().collect(Collectors.toCollection(MenuItemList::new));
    }

    public void chooseDescription(TextIO textIO, Deque<String> path) throws DescriptorLoadingException {
        if (this.menuItems.size() == 1) {
            this.metaDescription.setChosenDescriptor(((DescriptorSelectionMenuItem)this.menuItems.get(0)).getDescription().getXmlName());
        } else {
            path.add(this.getName());
            this.printPosition(textIO, path);
            DescriptorSelectionMenuItem choice = (DescriptorSelectionMenuItem)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(this.menuItems)).read(new String[]{"\nChoose a specific descriptor."});
            this.clearTerminal(textIO);
            this.metaDescription.setChosenDescriptor(choice.getDescription().getLocation());
            path.removeLast();
        }
    }

    @Override
    public String getName() {
        return "Choose Descriptor";
    }
}

