/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.configurations.PipelineBuilderConstants;
import de.julielab.jcore.pipeline.builder.base.exceptions.GithubInformationException;
import de.julielab.jcore.pipeline.builder.base.exceptions.PipelineIOException;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.base.main.JcoreGithubInformationService;
import de.julielab.jcore.pipeline.builder.base.main.MetaDescription;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.QuitMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.RefreshComponentRepositoryMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.AddComponentDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ConfigurePipelineDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ILoopablePipelineManipulationDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.LoadPipelineDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.SavePipelineDialog;
import de.julielab.jcore.pipeline.builder.cli.util.MenuItemExecutionException;
import de.julielab.jcore.pipeline.builder.cli.util.StatusPrinter;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;

public class IndexDialog
implements ILoopablePipelineManipulationDialog {
    private Map<PipelineBuilderConstants.JcoreMeta.Category, List<MetaDescription>> categoryMap;
    private List<IMenuItem> menuItems;

    public IndexDialog() throws GithubInformationException {
        this.initComponentRepository(false);
    }

    private void initComponentRepository(boolean loadNew) throws GithubInformationException {
        this.categoryMap = new HashMap<PipelineBuilderConstants.JcoreMeta.Category, List<MetaDescription>>();
        JcoreGithubInformationService.getInstance().getMetaInformation(Boolean.valueOf(loadNew)).forEach(md -> {
            for (PipelineBuilderConstants.JcoreMeta.Category category : md.getCategories()) {
                this.categoryMap.compute(category, (k, v) -> {
                    ArrayList<MetaDescription> ret = v;
                    if (ret == null) {
                        ret = new ArrayList<MetaDescription>();
                    }
                    ret.add((MetaDescription)md);
                    return ret;
                });
            }
        });
        this.menuItems = new ArrayList<IMenuItem>();
        this.menuItems.add(new AddComponentDialog(this.categoryMap, PipelineBuilderConstants.JcoreMeta.Category.reader));
        this.menuItems.add(new AddComponentDialog(this.categoryMap, PipelineBuilderConstants.JcoreMeta.Category.multiplier));
        this.menuItems.add(new AddComponentDialog(this.categoryMap, PipelineBuilderConstants.JcoreMeta.Category.ae));
        this.menuItems.add(new AddComponentDialog(this.categoryMap, PipelineBuilderConstants.JcoreMeta.Category.consumer));
        this.menuItems.add(new ConfigurePipelineDialog());
        this.menuItems.add(new SavePipelineDialog());
        this.menuItems.add(new LoadPipelineDialog());
        this.menuItems.add(new RefreshComponentRepositoryMenuItem());
        this.menuItems.add(new QuitMenuItem());
    }

    @Override
    public String getName() {
        return "Index";
    }

    @Override
    public IMenuItem executeMenuItem(JCoReUIMAPipeline pipeline, TextIO textIO, Deque<String> path) throws MenuItemExecutionException {
        IMenuItem choice;
        block11: {
            this.printPosition(textIO, path);
            StatusPrinter.printPipelineStatus(pipeline, textIO);
            choice = (IMenuItem)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(this.menuItems)).read(new String[]{"\nAdd or remove components from your pipeline."});
            this.clearTerminal(textIO);
            try {
                if (choice instanceof ILoopablePipelineManipulationDialog) {
                    ((ILoopablePipelineManipulationDialog)choice).enterInputLoop(pipeline, textIO, path);
                    break block11;
                }
                if (choice instanceof SavePipelineDialog) {
                    try {
                        ((SavePipelineDialog)choice).savePipeline(pipeline, textIO, path);
                    }
                    catch (PipelineIOException e) {
                        e.printStackTrace();
                        textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.print("Saving the pipeline failed: " + e.getMessage()));
                    }
                    break block11;
                }
                if (choice instanceof LoadPipelineDialog) {
                    try {
                        ((LoadPipelineDialog)choice).loadPipeline(pipeline, textIO, path);
                    }
                    catch (PipelineIOException e) {
                        e.printStackTrace();
                        textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.print("Loading the pipeline failed: " + e.getMessage()));
                    }
                    break block11;
                }
                if (!(choice instanceof RefreshComponentRepositoryMenuItem)) break block11;
                try {
                    textIO.getTextTerminal().print("Refreshing component repository...");
                    this.initComponentRepository(true);
                    textIO.getTextTerminal().println("Done.");
                }
                catch (GithubInformationException e) {
                    throw new MenuItemExecutionException(e);
                }
            }
            catch (Exception e) {
                textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.print("An unexpected exception occurred: " + e.getMessage()));
                e.printStackTrace();
            }
        }
        return choice;
    }
}

