/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.exceptions.PipelineIOException;
import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.IMenuDialog;
import de.julielab.jcore.pipeline.builder.cli.util.ArtifactLoader;
import de.julielab.jcore.pipeline.builder.cli.util.MenuItemExecutionException;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.fit.factory.ExternalResourceFactory;
import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalResourceDefinitionDialog
implements IMenuDialog {
    private static final Logger log = LoggerFactory.getLogger(ExternalResourceDefinitionDialog.class);
    private JCoReUIMAPipeline pipeline;
    private Description description;

    public ExternalResourceDefinitionDialog(JCoReUIMAPipeline pipeline, Description description) {
        this.pipeline = pipeline;
        this.description = description;
    }

    @Override
    public String getName() {
        return null;
    }

    public void createExternalResourceBinding(TextIO textIO, ExternalResourceDependency dependency) throws MenuItemExecutionException {
        String LS = System.getProperty("line.separator");
        textIO.getTextTerminal().print(String.format("Define an external resource for the resource dependency %s.%sDescription: %s%s", dependency.getKey(), LS, dependency.getDescription(), LS));
        String sharedResourceObjectClass = null;
        String dependencyInterfaceName = dependency.getInterfaceName();
        try {
            textIO.getTextTerminal().println("Loading the libraries of the pipeline in order to find eligible external resource implementations for the resource interface " + dependencyInterfaceName + "...");
            if (log.isTraceEnabled()) {
                this.pipeline.getClasspathElements().forEach(e -> log.trace("Loading classpath element {}", e));
            }
            this.pipeline.getClasspathElements().forEach(ArtifactLoader::loadArtifact);
            if (!StringUtils.isBlank((CharSequence)dependencyInterfaceName)) {
                Class<?> forName = Class.forName(dependencyInterfaceName);
                FastClasspathScanner fcs = new FastClasspathScanner(new String[0]);
                ArrayList<String> list = new ArrayList<String>();
                fcs.matchClassesImplementing(forName, list::add);
                textIO.getTextTerminal().printf("Searching for implementations of the external resource dependency interface %s...", new Object[]{dependencyInterfaceName});
                fcs.scan();
                list.add("<class not listed>");
                Object response = ((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(list)).read(new String[]{"Select an implementation of the external resource interface."});
                sharedResourceObjectClass = response.toString().equals("<class not listed>") ? (String)textIO.newStringInputReader().read(new String[]{"Enter the implementation name. It must be on the classpath when the pipeline is run."}) : ((Class)response).getCanonicalName();
            }
            String resourceUrl = (String)textIO.newStringInputReader().read(new String[]{"Specify the URL pointing to the external resource:"});
            String resourceName = (String)textIO.newStringInputReader().read(new String[]{"Specify a human readable resource name:"});
            String resourceDescription = (String)textIO.newStringInputReader().read(new String[]{"Specify a description for the resource:"});
            Class<?> implementationClass = null;
            while (implementationClass == null && !StringUtils.isBlank((CharSequence)dependencyInterfaceName)) {
                try {
                    implementationClass = Class.forName(sharedResourceObjectClass);
                }
                catch (ClassNotFoundException e2) {
                    String message = "The resource implementation class " + sharedResourceObjectClass + " could not be found.";
                    textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.print(message));
                    sharedResourceObjectClass = (String)textIO.newStringInputReader().withMinLength(0).read(new String[]{"Provide a new class name of hit enter to abort:"});
                    if (!StringUtils.isBlank((CharSequence)sharedResourceObjectClass)) continue;
                    return;
                }
            }
            ExternalResourceDescription externalResourceDescription = ExternalResourceFactory.createExternalResourceDescription((String)resourceName, implementationClass, (String)resourceUrl, (Object[])new Object[0]);
            externalResourceDescription.setDescription(resourceDescription);
            ExternalResourceFactory.bindExternalResource((ResourceCreationSpecifier)((ResourceCreationSpecifier)this.description.getDescriptor()), (String)dependency.getKey(), (ExternalResourceDescription)externalResourceDescription);
            this.clearTerminal(textIO);
        }
        catch (PipelineIOException | ClassNotFoundException e3) {
            throw new MenuItemExecutionException(e3);
        }
    }

    public String toString() {
        return this.getName();
    }
}

