/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.cli.menu.BackMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.ParameterEditingMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ILoopableDialog;
import de.julielab.jcore.pipeline.builder.cli.util.StatusPrinter;
import java.util.ArrayList;
import java.util.Deque;
import java.util.stream.Stream;
import org.apache.uima.resource.ConfigurableDataResourceSpecifier;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.FileResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;

public class ExternalResourceConfigurationDialog
implements ILoopableDialog {
    private Description description;
    private ExternalResourceDescription resourceDescription;

    public ExternalResourceConfigurationDialog(Description description, ExternalResourceDescription resourceDescription) {
        this.description = description;
        this.resourceDescription = resourceDescription;
    }

    @Override
    public IMenuItem executeMenuItem(TextIO textIO, Deque<String> path) {
        StatusPrinter.printComponentStatus(this.description, textIO);
        if (this.resourceDescription.getResourceSpecifier() instanceof FileResourceSpecifier) {
            FileResourceSpecifier spec = (FileResourceSpecifier)this.resourceDescription.getResourceSpecifier();
            String url = (String)textIO.newStringInputReader().read(new String[]{"Enter the new file URL:"});
            spec.setFileUrl(url);
            return new BackMenuItem();
        }
        if (this.resourceDescription.getResourceSpecifier() instanceof ConfigurableDataResourceSpecifier) {
            ConfigurableDataResourceSpecifier spec = (ConfigurableDataResourceSpecifier)this.resourceDescription.getResourceSpecifier();
            ArrayList<IMenuItem> itemList = new ArrayList<IMenuItem>();
            IMenuItem resourceUrlItem = new IMenuItem(){

                @Override
                public String getName() {
                    return "Resource Url";
                }

                public String toString() {
                    return this.getName();
                }
            };
            itemList.add(resourceUrlItem);
            Stream.of(spec.getMetaData().getConfigurationParameterDeclarations().getConfigurationParameters()).map(p -> new ParameterEditingMenuItem(this.resourceDescription.getResourceSpecifier(), (ConfigurationParameter)p)).forEach(itemList::add);
            itemList.add(new BackMenuItem());
            IMenuItem response = (IMenuItem)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(itemList)).read(new String[]{"Select the parameter you want to change:"});
            if (response.equals(resourceUrlItem)) {
                String url = (String)textIO.newStringInputReader().read(new String[]{"Enter the new resource URL:"});
                spec.setUrl(url);
            } else if (response instanceof ParameterEditingMenuItem) {
                ParameterEditingMenuItem item = (ParameterEditingMenuItem)response;
                item.setParameterValue(textIO);
            } else {
                return response;
            }
            this.clearTerminal(textIO);
            return response;
        }
        return new BackMenuItem();
    }

    @Override
    public String getName() {
        return "Configure External Resource";
    }

    public String toString() {
        return this.getName();
    }
}

