/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.cli.menu.BackMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.ExternalResourceDependencyDefinitionMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.ExternalResourceEditingMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.MenuItemList;
import de.julielab.jcore.pipeline.builder.cli.menu.MultiValuedParameterEditingMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.ParameterEditingMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ExternalResourceConfigurationDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ExternalResourceDefinitionDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ILoopablePipelineManipulationDialog;
import de.julielab.jcore.pipeline.builder.cli.util.MenuItemExecutionException;
import de.julielab.jcore.pipeline.builder.cli.util.StatusPrinter;
import java.util.Collections;
import java.util.Deque;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.impl.ExternalResourceDependency_impl;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ExternalResourceBinding;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.StringInputReader;
import org.beryx.textio.TextIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescriptorConfigurationDialog
implements ILoopablePipelineManipulationDialog {
    private static final Logger log = LoggerFactory.getLogger(DescriptorConfigurationDialog.class);
    private MenuItemList<IMenuItem> itemList;
    private Description description;

    public DescriptorConfigurationDialog(Description description) {
        this.description = description;
        this.createMenuItems(description);
    }

    private void createMenuItems(Description description) {
        this.itemList = new MenuItemList();
        description.getConfigurationParameters().values().stream().map(p -> {
            if (p.isMultiValued()) {
                return new MultiValuedParameterEditingMenuItem(description, (ConfigurationParameter)p);
            }
            return new ParameterEditingMenuItem((ResourceSpecifier)description.getDescriptor(), (ConfigurationParameter)p);
        }).forEach(this.itemList::add);
        Collections.sort(this.itemList);
        MenuItemList externalResourceItems = new MenuItemList();
        if (description.getDescriptor() instanceof AnalysisEngineDescription) {
            ExternalResourceDependency[] externalResourceDependencies = description.getDescriptorAsAnalysisEngineDescription().getExternalResourceDependencies();
            Stream.of(externalResourceDependencies).map(ExternalResourceEditingMenuItem::new).forEach(externalResourceItems::add);
            Collections.sort(externalResourceItems);
            this.itemList.addAll(externalResourceItems);
        }
        if (description.getDescriptor() instanceof AnalysisEngineDescription) {
            this.itemList.add(new ExternalResourceDependencyDefinitionMenuItem());
        }
        this.itemList.add(new BackMenuItem());
    }

    @Override
    public String getName() {
        return "Configure Descriptor";
    }

    @Override
    public IMenuItem executeMenuItem(JCoReUIMAPipeline pipeline, TextIO textIO, Deque<String> path) {
        this.printPosition(textIO, path);
        StatusPrinter.printComponentStatus(this.description, false, textIO);
        StatusPrinter.printComponentMetaData(this.description, textIO);
        IMenuItem choice = (IMenuItem)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(this.itemList)).read(new String[]{"\nChoose a parameter or external resource dependency."});
        if (choice instanceof ParameterEditingMenuItem) {
            ParameterEditingMenuItem item = (ParameterEditingMenuItem)choice;
            item.setParameterValue(textIO);
            this.clearTerminal(textIO);
        } else if (choice instanceof MultiValuedParameterEditingMenuItem) {
            MultiValuedParameterEditingMenuItem item = (MultiValuedParameterEditingMenuItem)choice;
            item.setParameterValue(textIO);
            this.clearTerminal(textIO);
        } else if (choice instanceof ExternalResourceEditingMenuItem) {
            ExternalResourceEditingMenuItem item = (ExternalResourceEditingMenuItem)choice;
            Optional<Object> resourceBinding = Optional.empty();
            if (this.description.getDescriptorAsAnalysisEngineDescription().getResourceManagerConfiguration() != null) {
                resourceBinding = Stream.of(this.description.getDescriptorAsAnalysisEngineDescription().getResourceManagerConfiguration().getExternalResourceBindings()).filter(b -> b.getKey().equals(item.getDependency().getKey())).findFirst();
            }
            try {
                String answer = "new";
                if (resourceBinding.isPresent()) {
                    answer = (String)((StringInputReader)textIO.newStringInputReader().withInlinePossibleValues((Object[])new String[]{"edit", "new"})).read(new String[]{"Dou you want to edit the existing resource or create a new one?"});
                }
                if (answer.equals("new")) {
                    new ExternalResourceDefinitionDialog(pipeline, this.description).createExternalResourceBinding(textIO, item.getDependency());
                } else {
                    String resourceName = ((ExternalResourceBinding)resourceBinding.get()).getResourceName();
                    Optional<ExternalResourceDescription> resource = Stream.of(this.description.getDescriptorAsAnalysisEngineDescription().getResourceManagerConfiguration().getExternalResources()).filter(res -> res.getName().equals(resourceName)).findFirst();
                    if (resource.isPresent()) {
                        new ExternalResourceConfigurationDialog(this.description, resource.get()).enterInputLoop(textIO, path);
                    }
                }
            }
            catch (MenuItemExecutionException e) {
                log.error("External resource configuration failed: ", (Throwable)e);
            }
        } else if (choice instanceof ExternalResourceDependencyDefinitionMenuItem) {
            this.clearTerminal(textIO);
            String key = (String)textIO.newStringInputReader().read(new String[]{"Specify the key of the resource dependency:"});
            String description = (String)textIO.newStringInputReader().read(new String[]{"Specify the description of the resource dependency:"});
            String interfaceName = (String)textIO.newStringInputReader().read(new String[]{"Specify the interface name of the resource dependency:"});
            boolean isOptional = (Boolean)textIO.newBooleanInputReader().read(new String[]{"Is this dependency optional?"});
            ExternalResourceDependency_impl dep = new ExternalResourceDependency_impl();
            dep.setInterfaceName(interfaceName);
            dep.setKey(key);
            dep.setOptional(isOptional);
            dep.setDescription(description);
            ExternalResourceDependency[] externalResourceDependencies = this.description.getDescriptorAsAnalysisEngineDescription().getExternalResourceDependencies();
            ExternalResourceDependency[] newDependencies = new ExternalResourceDependency[externalResourceDependencies != null ? externalResourceDependencies.length + 1 : 1];
            if (externalResourceDependencies != null) {
                System.arraycopy(externalResourceDependencies, 0, newDependencies, 0, externalResourceDependencies.length);
            }
            newDependencies[newDependencies.length - 1] = dep;
            this.description.getDescriptorAsAnalysisEngineDescription().setExternalResourceDependencies(newDependencies);
            this.createMenuItems(this.description);
            if (((Boolean)textIO.newBooleanInputReader().read(new String[]{"Do you which to define an external resource for the new dependency?"})).booleanValue()) {
                try {
                    new ExternalResourceDefinitionDialog(pipeline, this.description).createExternalResourceBinding(textIO, (ExternalResourceDependency)dep);
                }
                catch (MenuItemExecutionException e) {
                    log.error("External resource configuration failed: ", (Throwable)e);
                }
            }
        }
        return choice;
    }
}

