/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.cli.menu.BackMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.MenuItemList;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ArtifactVersionDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ComponentConfigurationSelectionDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ILoopablePipelineManipulationDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.RemoveComponentDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ReorderComponentsDialog;
import de.julielab.jcore.pipeline.builder.cli.util.MenuItemExecutionException;
import de.julielab.jcore.pipeline.builder.cli.util.StatusPrinter;
import java.util.Deque;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;

public class ConfigurePipelineDialog
implements ILoopablePipelineManipulationDialog {
    private MenuItemList<IMenuItem> itemList;

    @Override
    public IMenuItem executeMenuItem(JCoReUIMAPipeline pipeline, TextIO textIO, Deque<String> path) throws MenuItemExecutionException {
        this.init(pipeline);
        this.printPosition(textIO, path);
        StatusPrinter.printPipelineStatus(pipeline, textIO);
        IMenuItem choice = (IMenuItem)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(this.itemList)).read(new String[]{"\nChoose an action to perform on your pipeline."});
        this.clearTerminal(textIO);
        if (!(choice instanceof BackMenuItem)) {
            ILoopablePipelineManipulationDialog dialog = (ILoopablePipelineManipulationDialog)choice;
            dialog.enterInputLoop(pipeline, textIO, path);
        }
        this.clearTerminal(textIO);
        return choice;
    }

    private void init(JCoReUIMAPipeline pipeline) {
        this.itemList = new MenuItemList();
        this.itemList.add(new ComponentConfigurationSelectionDialog());
        this.itemList.add(new ReorderComponentsDialog());
        this.itemList.add(new RemoveComponentDialog());
        this.itemList.add(new ArtifactVersionDialog());
        this.itemList.add(new BackMenuItem());
    }

    @Override
    public String getName() {
        return "Configure Pipeline";
    }

    public String toString() {
        return this.getName();
    }
}

