/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.configurations.PipelineBuilderConstants;
import de.julielab.jcore.pipeline.builder.base.exceptions.DescriptorLoadingException;
import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.base.main.MetaDescription;
import de.julielab.jcore.pipeline.builder.cli.menu.BackMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.EditMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.MenuItemList;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ILoopablePipelineManipulationDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.SingleDescriptionSelectionDialog;
import de.julielab.jcore.pipeline.builder.cli.util.StatusPrinter;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddComponentDialog
implements ILoopablePipelineManipulationDialog {
    private static final Logger log = LoggerFactory.getLogger(AddComponentDialog.class);
    private final List<MetaDescription> aeDescriptions;
    private final PipelineBuilderConstants.JcoreMeta.Category category;
    private MenuItemList<IMenuItem> menuItemList;

    public AddComponentDialog(Map<PipelineBuilderConstants.JcoreMeta.Category, List<MetaDescription>> categoryMap, PipelineBuilderConstants.JcoreMeta.Category category) {
        this.aeDescriptions = categoryMap.getOrDefault(category, Collections.emptyList());
        this.category = category;
        this.menuItemList = new MenuItemList();
        for (MetaDescription aeDesc : this.aeDescriptions) {
            this.menuItemList.add(new EditMenuItem(aeDesc, category));
        }
        Collections.sort(this.menuItemList);
        this.menuItemList.add(new BackMenuItem());
    }

    @Override
    public IMenuItem executeMenuItem(JCoReUIMAPipeline pipeline, TextIO textIO, Deque<String> path) {
        IMenuItem iMenuItem;
        boolean errorPrinted;
        IMenuItem choice;
        block19: {
            this.printPosition(textIO, path);
            StatusPrinter.printPipelineStatus(pipeline, textIO);
            choice = (IMenuItem)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(this.menuItemList)).read(new String[]{"\nChoose a component."});
            errorPrinted = false;
            try {
                if (!(choice instanceof EditMenuItem)) break block19;
                EditMenuItem addItem = (EditMenuItem)choice;
                MetaDescription description = addItem.getDescription();
                textIO.getTextTerminal().print("Loading component..." + System.getProperty("line.separator"));
                Collection jCoReDescriptions = null;
                try {
                    jCoReDescriptions = description.getJCoReDescriptions();
                }
                catch (DescriptorLoadingException e) {
                    this.clearTerminal(textIO);
                    textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.println("Could not load the component due to an exception: " + e.getMessage()));
                    errorPrinted = true;
                    throw e;
                }
                this.clearTerminal(textIO);
                if (jCoReDescriptions.size() > 1) {
                    new SingleDescriptionSelectionDialog(description, d -> d.getCategory() == this.category).chooseDescription(textIO, path);
                } else {
                    this.clearTerminal(textIO);
                }
                Description jCoReDescription = description.getChosenDescriptor().clone();
                if (jCoReDescription != null) {
                    try {
                        switch (this.category) {
                            case reader: {
                                pipeline.setCrDescription(jCoReDescription);
                                break;
                            }
                            case multiplier: {
                                pipeline.addCasMultiplier(jCoReDescription);
                                break;
                            }
                            case ae: {
                                pipeline.addDelegateAe(jCoReDescription);
                                break;
                            }
                            case consumer: {
                                pipeline.addCcDesc(jCoReDescription);
                                break;
                            }
                            default: {
                                textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.println("Could not set the component because it belongs to the unsupported component category \"" + this.category.name() + "\"."));
                                errorPrinted = true;
                            }
                        }
                        this.clearTerminal(textIO);
                    }
                    catch (Exception e) {
                        textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.print("Could not add the analysis engine: " + e.getMessage()));
                        errorPrinted = true;
                        e.printStackTrace();
                    }
                } else {
                    textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.println("Could not add the analysis engine because there is no descriptor."));
                    errorPrinted = true;
                }
            }
            catch (DescriptorLoadingException e) {
                log.debug("Could not load descriptors", (Throwable)e);
            }
            catch (CloneNotSupportedException e) {
                log.error("Could not clone the description", (Throwable)e);
            }
        }
        IMenuItem iMenuItem2 = iMenuItem = this.category == PipelineBuilderConstants.JcoreMeta.Category.reader ? new BackMenuItem() : choice;
        if (iMenuItem instanceof BackMenuItem && !errorPrinted) {
            this.clearTerminal(textIO);
        }
        if (choice instanceof EditMenuItem) {
            textIO.getTextTerminal().executeWithPropertiesPrefix("emphasis", t -> t.println("Added component:"));
            StatusPrinter.printComponentMetaData(((EditMenuItem)choice).getDescription(), textIO);
            textIO.getTextTerminal().println(System.getProperty("line.separator"));
        }
        return iMenuItem;
    }

    @Override
    public String getName() {
        switch (this.category) {
            case reader: {
                return "Collection Reader";
            }
            case multiplier: {
                return "CAS Multiplier";
            }
            case ae: {
                return "Analysis Engine";
            }
            case consumer: {
                return "CAS Consumer";
            }
        }
        return "<unsupported component category>";
    }

    public String toString() {
        return this.getName();
    }
}

