/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu;

import de.julielab.java.utilities.prerequisites.PrerequisiteChecker;
import de.julielab.jcore.pipeline.builder.base.connectors.MavenConnector;
import de.julielab.jcore.pipeline.builder.base.exceptions.MavenException;
import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.base.main.MavenArtifact;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.beryx.textio.StringInputReader;
import org.beryx.textio.TextIO;

public class ArtifactVersionMenuItem
implements IMenuItem {
    private Description description;

    public ArtifactVersionMenuItem(Description description) {
        this.description = description;
    }

    public void selectVersion(TextIO textIO) {
        PrerequisiteChecker.checkThat().notNull(new Object[]{this.description}).supplyNotNull(new Supplier[]{() -> this.description.getMetaDescription()}).supplyNotNull(new Supplier[]{() -> this.description.getMetaDescription().getMavenArtifact()}).withNames(new String[]{"Description", "MetaDescription", "MavenArtifact"}).execute();
        MavenArtifact artifact = this.description.getMetaDescription().getMavenArtifact();
        try {
            List versionList = MavenConnector.getVersions((MavenArtifact)artifact).collect(Collectors.toList());
            if (versionList.isEmpty()) {
                textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.print("No versions available for component " + this.description.getName() + ", Maven artifact " + artifact));
                return;
            }
            Collections.reverse(versionList);
            String selectedVersion = (String)((StringInputReader)((StringInputReader)textIO.newStringInputReader().withNumberedPossibleValues(versionList)).withDefaultValue(versionList.get(0))).read(new String[]{"These are the available versions for the component " + this.description.getName() + ":"});
            this.description.getMetaDescription().getMavenArtifact().setVersion(selectedVersion);
        }
        catch (MavenException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return this.description.getName();
    }
}

