package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.cli.menu.BackMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.ParameterEditingMenuItem;
import de.julielab.jcore.pipeline.builder.cli.util.StatusPrinter;
import org.apache.uima.resource.ConfigurableDataResourceSpecifier;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.FileResourceSpecifier;
import org.beryx.textio.TextIO;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.stream.Stream;

public class ExternalResourceConfigurationDialog implements ILoopableDialog {

    private Description description;
    private ExternalResourceDescription resourceDescription;

    public ExternalResourceConfigurationDialog(Description description, ExternalResourceDescription resourceDescription) {
        this.description = description;
        this.resourceDescription = resourceDescription;
    }

    public IMenuItem executeMenuItem(TextIO textIO, Deque<String> path) {
        StatusPrinter.printComponentStatus(description, textIO);
        if (resourceDescription.getResourceSpecifier() instanceof FileResourceSpecifier) {
            FileResourceSpecifier spec = (FileResourceSpecifier) resourceDescription.getResourceSpecifier();
            String url = textIO.newStringInputReader().read("Enter the new file URL:");
            spec.setFileUrl(url);
            return new BackMenuItem();
        } else if (resourceDescription.getResourceSpecifier() instanceof ConfigurableDataResourceSpecifier) {
            ConfigurableDataResourceSpecifier spec = (ConfigurableDataResourceSpecifier) resourceDescription.getResourceSpecifier();
            List<IMenuItem> itemList = new ArrayList<>();
            IMenuItem resourceUrlItem = new IMenuItem() {
                @Override
                public String getName() {
                    return "Resource Url";
                }

                @Override
                public String toString() {
                    return getName();
                }
            };
            itemList.add(resourceUrlItem);
            Stream.of(spec.getMetaData().getConfigurationParameterDeclarations().
                    getConfigurationParameters()).
                    map(p -> new ParameterEditingMenuItem(resourceDescription.getResourceSpecifier(), p)).
                    forEach(itemList::add);
            itemList.add(new BackMenuItem());
            IMenuItem response = textIO.<IMenuItem>newGenericInputReader(null).withNumberedPossibleValues(itemList).
                    read("Select the parameter you want to change:");
            if (response.equals(resourceUrlItem)) {
                String url = textIO.newStringInputReader().read("Enter the new resource URL:");
                spec.setUrl(url);
            } else if (response instanceof ParameterEditingMenuItem) {
                ParameterEditingMenuItem item = (ParameterEditingMenuItem) response;
                item.setParameterValue(textIO);
            } else return response;
            clearTerminal(textIO);
            return response;
        }
        return new BackMenuItem();
    }

    @Override
    public String getName() {
        return "Configure External Resource";
    }

    @Override
    public String toString() {
        return getName();
    }


}
