/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.engine;

import java.util.ArrayList;
import org.apache.uima.UIMAFramework;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.base_cpm.BaseStatusCallbackListener;
import org.apache.uima.collection.impl.EntityProcessStatusImpl;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;

public class CPMThreadGroup
extends ThreadGroup {
    private ArrayList callbackListeners = null;
    private ProcessTrace procTr = null;

    public CPMThreadGroup(String name) {
        super(name);
    }

    public CPMThreadGroup(ThreadGroup parent, String name) {
        super(parent, name);
    }

    public void setListeners(ArrayList aListenerList) {
        this.callbackListeners = aListenerList;
    }

    public void setProcessTrace(ProcessTrace aProcessTrace) {
        this.procTr = aProcessTrace;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        block4: {
            System.out.println("ThreadGroup.uncaughtException()-Got Error");
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_unhandled_error__SEVERE", new Object[]{Thread.currentThread().getName(), e.getClass().getName()});
            }
            try {
                for (int i = 0; this.callbackListeners != null && i < this.callbackListeners.size(); ++i) {
                    this.notifyListener((BaseStatusCallbackListener)this.callbackListeners.get(i), e);
                }
            }
            catch (Throwable tr) {
                if (!UIMAFramework.getLogger().isLoggable(Level.FINER)) break block4;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINER, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception__FINER", new Object[]{Thread.currentThread().getName(), tr.getClass().getName()});
                tr.printStackTrace();
            }
        }
    }

    private void notifyListener(BaseStatusCallbackListener aStatCL, Throwable e) {
        EntityProcessStatusImpl enProcSt = new EntityProcessStatusImpl(this.procTr);
        enProcSt.addEventStatus("Process", "Failed", e);
        ((StatusCallbackListener)aStatCL).entityProcessComplete(null, enProcSt);
    }

    public void cleanup() {
        this.callbackListeners = null;
        this.procTr = null;
    }
}

