/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import java.util.Deque;
import java.util.stream.Collectors;
import org.beryx.textio.TextIO;
import org.beryx.textio.TextTerminal;
import org.beryx.textio.jline.JLineTextTerminal;
import org.beryx.textio.swing.SwingTextTerminal;

public interface IMenuDialog
extends IMenuItem {
    default public void printPosition(TextIO textIO, Deque<String> path) {
        String LS = System.getProperty("line.separator");
        String pathString = path.stream().collect(Collectors.joining("/"));
        textIO.getTextTerminal().executeWithPropertiesPrefix("path", t -> t.print("You are here: " + pathString));
        textIO.getTextTerminal().executeWithPropertiesPrefix("default", t -> t.print(LS));
    }

    default public void clearTerminal(TextIO textIO) {
        TextTerminal<?> terminal2 = textIO.getTextTerminal();
        Class<?> terminalClass = terminal2.getClass();
        if (terminalClass.equals(SwingTextTerminal.class)) {
            terminal2.resetToBookmark("clearscreen");
            terminal2.setBookmark("clearscreen");
            ((SwingTextTerminal)terminal2).setPaneBackgroundColor("white");
        } else if (terminalClass.equals(JLineTextTerminal.class)) {
            terminal2.print("\u001b[H\u001b[2J");
        }
    }
}

