/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.interpolation.reflection;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.codehaus.plexus.interpolation.reflection.ClassMap;
import org.codehaus.plexus.interpolation.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionValueExtractor {
    private static final Class<?>[] CLASS_ARGS = new Class[0];
    private static final Object[] OBJECT_ARGS = new Object[0];
    private static final Map<Class<?>, WeakReference<ClassMap>> classMaps = new WeakHashMap();

    private ReflectionValueExtractor() {
    }

    public static Object evaluate(String expression, Object root) throws Exception {
        return ReflectionValueExtractor.evaluate(expression, root, true);
    }

    public static Object evaluate(String expression, Object root, boolean trimRootToken) throws Exception {
        if (trimRootToken) {
            expression = expression.substring(expression.indexOf(46) + 1);
        }
        Object value = root;
        StringTokenizer parser2 = new StringTokenizer(expression, ".");
        while (parser2.hasMoreTokens()) {
            String token = parser2.nextToken();
            if (value == null) {
                return null;
            }
            ClassMap classMap = ReflectionValueExtractor.getClassMap(value.getClass());
            String methodBase = StringUtils.capitalizeFirstLetter(token);
            String methodName = "get" + methodBase;
            Method method = classMap.findMethod(methodName, CLASS_ARGS);
            if (method == null) {
                methodName = "is" + methodBase;
                method = classMap.findMethod(methodName, CLASS_ARGS);
            }
            if (method == null) {
                return null;
            }
            value = method.invoke(value, OBJECT_ARGS);
        }
        return value;
    }

    private static ClassMap getClassMap(Class<?> clazz) {
        ClassMap classMap;
        WeakReference<ClassMap> ref = classMaps.get(clazz);
        if (ref == null || (classMap = (ClassMap)ref.get()) == null) {
            classMap = new ClassMap(clazz);
            classMaps.put(clazz, new WeakReference<ClassMap>(classMap));
        }
        return classMap;
    }
}

