/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.function.Function;
import org.beryx.textio.ReadHandlerData;
import org.beryx.textio.ReadInterruptionStrategy;

public class ReadInterruptionData
extends ReadInterruptionStrategy<ReadInterruptionData> {
    private String returnValue;

    public ReadInterruptionData(ReadInterruptionStrategy.Action action) {
        super(action);
        if (action == ReadInterruptionStrategy.Action.CONTINUE) {
            throw new IllegalArgumentException("Action CONTINUE not allowed for ReadInterruptionData.");
        }
    }

    public static ReadInterruptionData from(ReadHandlerData handlerData, String partialInput) {
        Function<String, String> valueProvider = handlerData.getReturnValueProvider();
        String retVal = valueProvider == null ? null : valueProvider.apply(partialInput);
        return ((ReadInterruptionData)((ReadInterruptionData)new ReadInterruptionData(handlerData.getAction()).withRedrawRequired(handlerData.isRedrawRequired())).withPayload(handlerData.getPayload())).withReturnValue(retVal);
    }

    public ReadInterruptionData withReturnValue(String returnValue) {
        this.returnValue = returnValue;
        return this;
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    @Override
    public String toString() {
        return super.toString() + ", returnValue: " + this.returnValue;
    }
}

