/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.base_cpm.AbortCPMException;
import org.apache.uima.collection.base_cpm.BaseCPM;
import org.apache.uima.collection.base_cpm.BaseCollectionReader;
import org.apache.uima.collection.base_cpm.BaseStatusCallbackListener;
import org.apache.uima.collection.base_cpm.CasProcessor;
import org.apache.uima.collection.base_cpm.RecoverableCollectionReader;
import org.apache.uima.collection.base_cpm.SynchPoint;
import org.apache.uima.collection.impl.EntityProcessStatusImpl;
import org.apache.uima.collection.impl.base_cpm.container.ProcessingContainer;
import org.apache.uima.collection.impl.cpm.Checkpoint;
import org.apache.uima.collection.impl.cpm.CheckpointData;
import org.apache.uima.collection.impl.cpm.container.CPEFactory;
import org.apache.uima.collection.impl.cpm.container.deployer.socket.ProcessControllerAdapter;
import org.apache.uima.collection.impl.cpm.engine.CPMEngine;
import org.apache.uima.collection.impl.cpm.engine.CPMThreadGroup;
import org.apache.uima.collection.impl.cpm.utils.CasMetaData;
import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.collection.impl.cpm.utils.TimerFactory;
import org.apache.uima.collection.metadata.CpeConfiguration;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.ProcessTraceEvent;
import org.apache.uima.util.Progress;
import org.apache.uima.util.UimaTimer;
import org.apache.uima.util.impl.ProcessTrace_impl;

public class BaseCPMImpl
implements BaseCPM,
Runnable {
    private boolean defaultProcessTrace;
    private CPMEngine cpEngine = null;
    private ProcessTrace procTr = null;
    BaseCollectionReader collectionReader = null;
    private Checkpoint checkpoint = null;
    private CheckpointData checkpointData = null;
    private long num2Process = -1L;
    private boolean killed = false;
    private boolean completed = false;
    private CPEFactory cpeFactory = null;
    private boolean useJediiReport = true;
    private Map mEventTypeMap;
    public CPMThreadGroup cpmThreadGroup = null;

    public BaseCPMImpl(CpeDescription aDescriptor) throws Exception {
        this(aDescriptor, null, true, UIMAFramework.getDefaultPerformanceTuningProperties());
        this.cpmThreadGroup = new CPMThreadGroup("CPM Thread Group");
    }

    public BaseCPMImpl(CpeDescription aDescriptor, ResourceManager aResourceManager, boolean aDefaultProcessTrace, Properties aProps) throws Exception {
        this.cpeFactory = new CPEFactory(aDescriptor, aResourceManager);
        this.defaultProcessTrace = aDefaultProcessTrace;
        this.cpmThreadGroup = new CPMThreadGroup("CPM Thread Group");
        this.init(false, aProps);
    }

    public BaseCPMImpl(Boolean mode, String aDescriptor, ResourceManager aResourceManager) throws Exception {
        this.cpmThreadGroup = new CPMThreadGroup("CPM Thread Group");
        this.cpeFactory = new CPEFactory(aResourceManager);
        if (mode == null) {
            this.defaultProcessTrace = true;
            this.cpeFactory.parse();
        } else {
            this.defaultProcessTrace = mode;
            this.cpeFactory.parse(aDescriptor);
        }
        this.init(mode == null, UIMAFramework.getDefaultPerformanceTuningProperties());
    }

    public void setPerformanceTuningSettings(Properties aPerformanceTuningSettings) {
        this.cpEngine.setPerformanceTuningSettings(aPerformanceTuningSettings);
    }

    public void setProcessControllerAdapter(ProcessControllerAdapter aPca) {
        this.cpEngine.setProcessControllerAdapter(aPca);
    }

    public void setJediiReport(boolean aUseJediiReport) {
        this.mEventTypeMap = new HashMap();
        this.mEventTypeMap.put("ANALYSIS_ENGINE", "TAE");
        this.mEventTypeMap.put("ANALYSIS", "Annotator");
        this.mEventTypeMap.put("CAS_PROCESSOR", "CAS Consumer");
        this.useJediiReport = aUseJediiReport;
    }

    public void init(boolean aDummyCasProcessor, Properties aProps) throws Exception {
        block23: {
            String uimaTimerClass = this.cpeFactory.getCPEConfig().getTimerImpl();
            try {
                new TimerFactory(uimaTimerClass);
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) break block23;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_use_default_timer__FINEST", new Object[]{Thread.currentThread().getName()});
            }
        }
        UimaTimer uimaTimer = TimerFactory.getTimer();
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_use_custom_timer__FINEST", new Object[]{Thread.currentThread().getName(), uimaTimer.getClass().getName()});
        }
        this.procTr = new ProcessTrace_impl(uimaTimer, aProps);
        String checkpointFileName = null;
        if (this.cpeFactory.getCPEConfig().getCheckpoint() != null && this.cpeFactory.getCPEConfig().getCheckpoint().getFilePath() != null) {
            checkpointFileName = this.cpeFactory.getCPEConfig().getCheckpoint().getFilePath();
        }
        if (checkpointFileName != null && checkpointFileName.trim().length() > 0) {
            File checkpointFile = new File(checkpointFileName);
            this.checkpoint = new Checkpoint(this, checkpointFileName, this.cpeFactory.getCPEConfig().getCheckpoint().getFrequency());
            if (checkpointFile.exists()) {
                try {
                    Object restoredObject = this.checkpoint.restoreFromCheckpoint();
                    if (restoredObject != null && restoredObject instanceof CheckpointData) {
                        this.checkpointData = (CheckpointData)restoredObject;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.cpEngine = new CPMEngine(this.cpmThreadGroup, this.cpeFactory, this.procTr, this.checkpointData);
        if (!aDummyCasProcessor) {
            int concurrentThreadCount = this.cpeFactory.getCpeDescriptor().getCpeCasProcessors().getConcurrentPUCount();
            for (int threadCount = 0; threadCount < concurrentThreadCount; ++threadCount) {
                CasProcessor[] casProcessors = this.cpeFactory.getCasProcessors();
                for (int i = 0; i < casProcessors.length; ++i) {
                    if (UIMAFramework.getLogger().isLoggable(Level.CONFIG)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_add_cp__CONFIG", new Object[]{Thread.currentThread().getName(), casProcessors[i].getProcessingResourceMetaData().getName()});
                    }
                    this.addCasProcessor(casProcessors[i]);
                }
            }
        }
        int casPoolSize = 0;
        try {
            casPoolSize = this.cpeFactory.getCpeDescriptor().getCpeCasProcessors().getCasPoolSize();
            casPoolSize = casPoolSize == -1 ? 0 : casPoolSize;
            this.cpEngine.setPoolSize(casPoolSize);
        }
        catch (NumberFormatException threadCount) {
            // empty catch block
        }
        try {
            int iqSize = 0;
            if (casPoolSize == 0) {
                iqSize = this.cpeFactory.getCpeDescriptor().getCpeCasProcessors().getInputQueueSize();
            }
            this.cpEngine.setInputQueueSize(casPoolSize == 0 ? iqSize : casPoolSize);
        }
        catch (NumberFormatException e) {
            throw new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_queue_size_not_defined__WARNING", new Object[]{Thread.currentThread().getName(), "inputQueueSize"}));
        }
        try {
            int oqSize = 0;
            if (casPoolSize == 0) {
                oqSize = this.cpeFactory.getCpeDescriptor().getCpeCasProcessors().getOutputQueueSize();
            }
            this.cpEngine.setOutputQueueSize(casPoolSize == 0 ? oqSize : casPoolSize + 2);
        }
        catch (NumberFormatException e) {
            throw new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_queue_size_not_defined__WARNING", new Object[]{Thread.currentThread().getName(), "outputQueueSize"}));
        }
        try {
            int threadCount = this.cpeFactory.getCpeDescriptor().getCpeCasProcessors().getConcurrentPUCount();
            this.cpEngine.setConcurrentThreadSize(threadCount);
        }
        catch (NumberFormatException e) {
            throw new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_component_reference__WARNING", new Object[]{Thread.currentThread().getName(), "casProcessors", "processingUnitThreadCount"}));
        }
    }

    public CpeConfiguration getCPEConfig() throws Exception {
        return this.cpeFactory.getCPEConfig();
    }

    @Override
    public CasProcessor[] getCasProcessors() {
        CasProcessor[] casProcs = this.cpEngine.getCasProcessors();
        return casProcs == null ? new CasProcessor[]{} : casProcs;
    }

    @Override
    public void addCasProcessor(CasProcessor aCasProcessor) throws ResourceConfigurationException {
        this.cpEngine.addCasProcessor(aCasProcessor);
    }

    @Override
    public void addCasProcessor(CasProcessor aCasProcessor, int aIndex) throws ResourceConfigurationException {
        this.cpEngine.addCasProcessor(aCasProcessor, aIndex);
    }

    @Override
    public void removeCasProcessor(CasProcessor aCasProcessor) {
        this.cpEngine.removeCasProcessor(0);
    }

    @Override
    public void disableCasProcessor(String aCasProcessorName) {
        this.cpEngine.disableCasProcessor(aCasProcessorName);
    }

    public void enableCasProcessor(String aCasProcessorName) {
        this.cpEngine.enableCasProcessor(aCasProcessorName);
    }

    @Override
    public boolean isSerialProcessingRequired() {
        return false;
    }

    @Override
    public void setSerialProcessingRequired(boolean aRequired) {
    }

    @Override
    public boolean isPauseOnException() {
        return this.cpEngine.isPauseOnException();
    }

    @Override
    public void setPauseOnException(boolean aPause) {
        this.cpEngine.setPauseOnException(aPause);
    }

    @Override
    public void addStatusCallbackListener(BaseStatusCallbackListener aListener) {
        this.cpEngine.addStatusCallbackListener(aListener);
    }

    @Override
    public void removeStatusCallbackListener(BaseStatusCallbackListener aListener) {
        this.cpEngine.removeStatusCallbackListener(aListener);
    }

    @Override
    public void run() {
        block16: {
            Thread.currentThread().setName("BaseCPMImpl-Thread");
            long start = System.currentTimeMillis();
            if (!this.useJediiReport) {
                this.procTr.startEvent("CPM", "CPM PROCESSING TIME", "");
            }
            this.cpEngine.setNumToProcess(this.num2Process);
            try {
                this.cpEngine.deployCasProcessors();
                this.cpEngine.setCollectionReader(this.collectionReader);
                if (this.checkpoint != null) {
                    new Thread(this.checkpoint).start();
                }
                this.cpEngine.start();
                this.cpEngine.join();
                this.completed = true;
                if (!this.killed && this.checkpoint != null) {
                    this.checkpoint.stop();
                    this.checkpoint.delete();
                    this.checkpoint = null;
                }
                this.cpEngine.stopCasProcessors(false);
                if (!this.useJediiReport) {
                    this.procTr.endEvent("CPM", "CPM PROCESSING TIME", "success");
                }
                long end = System.currentTimeMillis();
                if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) break block16;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_total_time_in_cpm__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(end - start)});
            }
            catch (AbortCPMException e) {
                if (!this.useJediiReport) {
                    this.procTr.endEvent("CPM", "CPM PROCESSING TIME", "failed");
                }
                try {
                    this.cpEngine.stopCasProcessors(true);
                }
                catch (Exception ex) {
                    UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, "" + ex);
                }
                this.killed = true;
            }
            catch (Exception e) {
                if (!this.useJediiReport) {
                    this.procTr.endEvent("CPM", "CPM PROCESSING TIME", "failed");
                }
                UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, "" + e);
                this.killed = true;
                ArrayList statusCbL = this.cpEngine.getCallbackListeners();
                EntityProcessStatusImpl enProcSt = new EntityProcessStatusImpl(this.procTr, true);
                enProcSt.addEventStatus("CPM", "Failed", e);
                for (int j = 0; j < statusCbL.size(); ++j) {
                    BaseStatusCallbackListener st = (BaseStatusCallbackListener)statusCbL.get(j);
                    if (st == null || !(st instanceof StatusCallbackListener)) continue;
                    ((StatusCallbackListener)st).entityProcessComplete(null, enProcSt);
                }
            }
        }
        if (this.cpEngine.isKilled()) {
            this.killed = true;
        }
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cpm_stopped__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.killed)});
        }
        ArrayList statusCbL = this.cpEngine.getCallbackListeners();
        for (int j = 0; j < statusCbL.size(); ++j) {
            BaseStatusCallbackListener st = (BaseStatusCallbackListener)statusCbL.get(j);
            if (st == null) continue;
            if (!this.killed) {
                st.collectionProcessComplete();
                continue;
            }
            st.aborted();
        }
    }

    public void finalizeIt() {
        this.cpEngine.cleanup();
    }

    @Deprecated
    public void process(BaseCollectionReader aCollectionReader) throws ResourceInitializationException {
        try {
            this.num2Process = this.cpeFactory.getCPEConfig().getNumToProcess();
        }
        catch (InstantiationException e) {
            throw new ResourceInitializationException(e);
        }
        this.collectionReader = aCollectionReader;
        if (this.cpeFactory.isDefault()) {
            this.cpeFactory.addCollectionReader(this.collectionReader);
        }
        this.cpmThreadGroup.setProcessTrace(this.procTr);
        this.cpmThreadGroup.setListeners(this.cpEngine.getCallbackListeners());
        new Thread(this).start();
    }

    @Override
    public void process() throws ResourceInitializationException {
        try {
            this.num2Process = this.cpeFactory.getCPEConfig().getNumToProcess();
            if (this.collectionReader == null) {
                this.collectionReader = this.cpeFactory.getCollectionReader();
            }
        }
        catch (InstantiationException e) {
            throw new ResourceInitializationException(e);
        }
        catch (Exception e) {
            throw new ResourceInitializationException(e);
        }
        if (this.cpeFactory.isDefault()) {
            this.cpeFactory.addCollectionReader(this.collectionReader);
        }
        this.cpmThreadGroup.setProcessTrace(this.procTr);
        this.cpmThreadGroup.setListeners(this.cpEngine.getCallbackListeners());
        new Thread(this).start();
    }

    @Deprecated
    public void process(BaseCollectionReader aCollectionReader, int aBatchSize) throws ResourceInitializationException {
        this.num2Process = aBatchSize;
        this.collectionReader = aCollectionReader;
        if (this.cpeFactory.isDefault()) {
            this.cpeFactory.addCollectionReader(this.collectionReader);
        }
        this.cpmThreadGroup.setProcessTrace(this.procTr);
        this.cpmThreadGroup.setListeners(this.cpEngine.getCallbackListeners());
        new Thread((ThreadGroup)this.cpmThreadGroup, this).start();
    }

    @Override
    public void setCollectionReader(BaseCollectionReader aCollectionReader) {
        this.collectionReader = aCollectionReader;
        if (this.cpeFactory.isDefault()) {
            this.cpeFactory.addCollectionReader(this.collectionReader);
        }
    }

    @Override
    public BaseCollectionReader getCollectionReader() {
        try {
            if (this.collectionReader == null) {
                this.collectionReader = this.cpeFactory.getCollectionReader();
            }
            return this.collectionReader;
        }
        catch (ResourceConfigurationException e) {
            throw new UIMARuntimeException(e);
        }
    }

    @Override
    public boolean isProcessing() {
        return this.cpEngine.isRunning();
    }

    @Override
    public void pause() {
        this.cpEngine.pauseIt();
        if (this.checkpoint != null) {
            this.checkpoint.doCheckpoint();
            this.checkpoint.pause();
        }
    }

    @Override
    public boolean isPaused() {
        return this.cpEngine.isPaused();
    }

    @Override
    public void resume(boolean aRetryFailed) {
        this.resume();
    }

    @Override
    public void resume() {
        this.cpEngine.resumeIt();
        if (this.checkpoint != null) {
            this.checkpoint.resume();
        }
    }

    public void kill() {
        if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_killing_cpm__WARNING", new Object[]{Thread.currentThread().getName()});
        }
        this.killed = true;
        this.cpEngine.killIt();
        if (this.checkpoint != null && !this.completed) {
            this.checkpoint.doCheckpoint();
            this.checkpoint.stop();
        }
    }

    @Override
    public void stop() {
        if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_stop_cpm__WARNING", new Object[]{Thread.currentThread().getName()});
        }
        this.killed = true;
        this.cpEngine.stopIt();
        if (this.checkpoint != null && !this.completed) {
            this.checkpoint.doCheckpoint();
            this.checkpoint.stop();
        }
    }

    public void asynchStop() {
        if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_asynch_stop_cpm__WARNING", new Object[]{Thread.currentThread().getName()});
        }
        this.killed = true;
        this.cpEngine.asynchStop();
        if (this.checkpoint != null && !this.completed) {
            this.checkpoint.doCheckpoint();
            this.checkpoint.stop();
        }
    }

    private String decodeStatus(int aStatus) {
        try {
            switch (aStatus) {
                case 4: {
                    return "COMPLETED";
                }
                case 3: {
                    return "DISABLED";
                }
                case 1: {
                    return "READY";
                }
                case 2: {
                    return "RUNNING";
                }
                case 5: {
                    return "KILLED";
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return "UNKNOWN";
    }

    private void copyComponentEvents(String aEvType, List aList, ProcessTrace aPTr) throws IOException {
        for (int i = 0; i < aList.size(); ++i) {
            ProcessTraceEvent prEvent = (ProcessTraceEvent)aList.get(i);
            if (aEvType == null || !aEvType.equals(prEvent.getType())) continue;
            aPTr.addEvent(prEvent);
        }
    }

    public void displayStats(ProcessTrace aProcessTrace, int aNumDocsProcessed) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "Documents Processed: " + aNumDocsProcessed);
        }
        int totalTime = 0;
        for (ProcessTraceEvent event : aProcessTrace.getEvents()) {
            if ("CPM".equals(event.getComponentName())) {
                if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "Current Component::" + event.getComponentName() + " Time::" + event.getDuration());
                continue;
            }
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "Current Component::" + event.getComponentName());
            }
            totalTime += event.getDuration();
        }
        float totalTimeSeconds = (float)totalTime / 1000.0f;
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "Total Time: " + totalTimeSeconds + " seconds");
        }
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "100% (" + totalTime + "ms) - Collection Processing Engine");
        }
        for (ProcessTraceEvent event : aProcessTrace.getEvents()) {
            this.buildEventTree(event, totalTime);
        }
    }

    public void buildEventTree(ProcessTraceEvent aEvent, int aTotalTime) {
        if ("CPM".equals(aEvent.getComponentName())) {
            return;
        }
        int duration = aEvent.getDuration();
        float pct = (float)(duration * 100 * 10 / aTotalTime) / 10.0f;
        String type = (String)this.mEventTypeMap.get(aEvent.getType());
        if (type == null) {
            type = aEvent.getType();
        }
        if (System.getProperty("DEBUG") != null) {
            UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "" + pct + "% (" + duration + "ms) - " + aEvent.getComponentName() + " (" + type + ")");
        }
        for (ProcessTraceEvent event : aEvent.getSubEvents()) {
            this.buildEventTree(event, aTotalTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessTrace getPerformanceReport() {
        Map perfReport = this.cpEngine.getStats();
        Progress[] colReaderProgress = (Progress[])perfReport.get("COLLECTION_READER_PROGRESS");
        ProcessTrace_impl processTrace = new ProcessTrace_impl(this.cpEngine.getPerformanceTuningSettings());
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "-------------------------------------------");
        }
        if (this.useJediiReport) {
            try {
                ProcessTrace processTrace2 = this.procTr;
                synchronized (processTrace2) {
                    List<ProcessTraceEvent> eventList = this.procTr.getEvents();
                    for (int j = 0; eventList != null && j < eventList.size(); ++j) {
                        ProcessTraceEvent prEvent = eventList.get(j);
                        processTrace.addEvent(prEvent);
                    }
                }
                return processTrace;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.defaultProcessTrace) {
            this.createDefaultProcessTrace(this.getCasProcessors(), this.procTr, processTrace);
            return processTrace;
        }
        try {
            Serializable sb;
            CasMetaData casMetaData = (CasMetaData)perfReport.get("CPM_LAST_CAS_METADATA");
            if (casMetaData != null) {
                NameValuePair[] nvp = casMetaData.getCasMetaData();
                sb = new StringBuffer();
                for (int i = 0; i < nvp.length && nvp[i] != null; ++i) {
                    if (i != 0) {
                        ((StringBuffer)sb).append(",");
                    }
                    ((StringBuffer)sb).append(nvp[i].getName() + "=" + (String)nvp[i].getValue());
                }
                processTrace.addEvent("CPM", "CPM_LAST_CAS_METADATA", ((StringBuffer)sb).toString(), 0, null);
            }
            List<ProcessTraceEvent> eList = null;
            sb = this.procTr;
            synchronized (sb) {
                eList = this.procTr.getEventsByComponentName("CPM", true);
            }
            if (!this.useJediiReport) {
                this.copyComponentEvents("CPM PROCESSING TIME", eList, processTrace);
            }
            eList.clear();
            if (colReaderProgress != null) {
                Long totalCollectionReaderTime = (Long)perfReport.get("COLLECTION_READER_TIME");
                String readerName = this.collectionReader.getProcessingResourceMetaData().getName();
                if (totalCollectionReaderTime != null) {
                    processTrace.addEvent(readerName, "COLLECTION_READER_TIME", String.valueOf(totalCollectionReaderTime), 0, null);
                }
                for (int i = 0; i < colReaderProgress.length; ++i) {
                    if ("bytes".equals(colReaderProgress[i].getUnit())) {
                        processTrace.addEvent(readerName, "BYTES_PROCESSED", String.valueOf(colReaderProgress[i].getCompleted()), 0, null);
                        continue;
                    }
                    if (!"entities".equals(colReaderProgress[i].getUnit())) continue;
                    processTrace.addEvent(readerName, "DOCS_PROCESSED", String.valueOf(colReaderProgress[i].getCompleted()), 0, null);
                }
                ProcessTrace i = this.procTr;
                synchronized (i) {
                    eList = this.procTr.getEventsByComponentName(readerName, true);
                }
                this.copyComponentEvents("COLLECTION READER PROCESSING TIME", eList, processTrace);
                eList.clear();
                processTrace.addEvent(readerName, "Last Entity ID Read", this.cpEngine.getLastProcessedDocId(), 0, null);
            }
            LinkedList processors = this.cpEngine.getAllProcessingContainers();
            for (int i = 0; i < processors.size(); ++i) {
                ProcessingContainer container = (ProcessingContainer)processors.get(i);
                ProcessTrace processTrace3 = this.procTr;
                synchronized (processTrace3) {
                    eList = this.procTr.getEventsByComponentName(container.getName(), true);
                }
                this.copyComponentEvents("Process", eList, processTrace);
                processTrace.addEvent(container.getName(), "Documents Processed", String.valueOf(container.getProcessed()), 0, null);
                String status = this.decodeStatus(container.getStatus());
                processTrace.addEvent(container.getName(), "Processor Status", status, 0, null);
                long bytesIn = container.getBytesIn();
                processTrace.addEvent(container.getName(), "Processor BYTESIN", String.valueOf(bytesIn), 0, null);
                long bytesOut = container.getBytesOut();
                processTrace.addEvent(container.getName(), "Processor BYTESOUT", String.valueOf(bytesOut), 0, null);
                int restartCount = container.getRestartCount();
                processTrace.addEvent(container.getName(), "Processor Restarts", String.valueOf(restartCount), 0, null);
                int retryCount = container.getRetryCount();
                processTrace.addEvent(container.getName(), "Processor Retries", String.valueOf(retryCount), 0, null);
                int filteredCount = container.getFilteredCount();
                processTrace.addEvent(container.getName(), "Filtered Entities", String.valueOf(filteredCount), 0, null);
                long remainingCount = container.getRemaining();
                processTrace.addEvent(container.getName(), "Processor Remaining", String.valueOf(remainingCount), 0, null);
                HashMap aMap = container.getAllStats();
                if (aMap.keySet() != null) {
                    if (System.getProperty("SHOW_CUSTOM_STATS") != null) {
                        UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "Adding Custom Stats");
                    }
                    Iterator it = aMap.keySet().iterator();
                    while (it != null && it.hasNext()) {
                        String key = (String)it.next();
                        if (key == null) continue;
                        Object o = aMap.get(key);
                        if (o instanceof String) {
                            processTrace.addEvent(container.getName(), key, (String)o, 0, null);
                            if (System.getProperty("SHOW_CUSTOM_STATS") == null) continue;
                            UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "Custom String Stat-" + key + " Value=" + (String)o);
                            continue;
                        }
                        if (o instanceof Integer) {
                            processTrace.addEvent(container.getName(), key, String.valueOf((Integer)o), 0, null);
                            if (System.getProperty("SHOW_CUSTOM_STATS") == null) continue;
                            UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "Custom Integer Stat-" + key + " Value=" + (Integer)o);
                            continue;
                        }
                        if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                        UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "Invalid Type Found When Generating Status For " + key + ". Type::" + o.getClass().getName() + " Not supported. Use Integer or String instead.");
                    }
                }
                try {
                    String lastDocId = container.getLastProcessedEntityId();
                    if (lastDocId == null) continue;
                    processTrace.addEvent(container.getName(), "Processor Last EntityId", lastDocId, 0, null);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDefaultProcessTrace(CasProcessor[] aProcessors, ProcessTrace srcProcTr, ProcessTrace aProcessTrace) {
        for (int i = 0; aProcessors != null && i < aProcessors.length; ++i) {
            String name = aProcessors[i].getProcessingResourceMetaData().getName();
            if (name == null) {
                name = aProcessors[i].getClass().getName();
            }
            ProcessTrace processTrace = srcProcTr;
            synchronized (processTrace) {
                List<ProcessTraceEvent> eventList = srcProcTr.getEventsByComponentName(name, false);
                for (int j = 0; j < eventList.size(); ++j) {
                    ProcessTraceEvent prEvent = eventList.get(j);
                    aProcessTrace.addEvent(prEvent);
                }
                continue;
            }
        }
    }

    @Override
    public Progress[] getProgress() {
        return this.cpEngine.getProgress();
    }

    public String getDescriptor(List aList) throws ResourceConfigurationException {
        return this.cpeFactory.getDescriptor(aList);
    }

    public SynchPoint getSynchPoint() {
        SynchPoint synchPoint = null;
        if (this.collectionReader != null && this.collectionReader instanceof RecoverableCollectionReader) {
            synchPoint = ((RecoverableCollectionReader)((Object)this.collectionReader)).getSynchPoint();
        }
        return synchPoint;
    }
}

