/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import com.ximpleware.extended.IByteBuffer;
import com.ximpleware.extended.ParseExceptionHuge;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;

public class JulieXMLBuffer
implements IByteBuffer {
    byte[][] bufferArray;
    long length;

    public JulieXMLBuffer() {
    }

    public JulieXMLBuffer(byte[] ba) {
        if (ba == null) {
            throw new IllegalArgumentException("ba can't be null ");
        }
        if (ba.length > 0x40000000) {
            throw new IllegalArgumentException("ba should be shorter than 1G bytes ");
        }
        this.bufferArray = new byte[1][];
        this.bufferArray[0] = ba;
        this.length = ba.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFile(String fileName) throws IOException, ParseExceptionHuge {
        File f = new File(fileName);
        this.length = 0L;
        ArrayList<byte[]> buffers = new ArrayList<byte[]>();
        InputStream fis = new FileInputStream(f);
        if (fileName.endsWith(".gz") || fileName.endsWith(".gzip")) {
            fis = new GZIPInputStream(fis);
        }
        try {
            int byteArrayLen = 0;
            int numOfBytesLastPage = 0;
            int currentPage = 0;
            boolean stop = false;
            while (!stop) {
                numOfBytesLastPage = 0;
                buffers.add(new byte[0x40000000]);
                byteArrayLen = 0x40000000;
                int offset = 0;
                int numRead = 0;
                int numOfBytes = 0x100000;
                if (byteArrayLen - offset < numOfBytes) {
                    numOfBytes = byteArrayLen - offset;
                }
                stop = true;
                while (offset < byteArrayLen && (numRead = fis.read((byte[])buffers.get(currentPage), offset, numOfBytes)) >= 0) {
                    stop = false;
                    if (byteArrayLen - (offset += numRead) < numOfBytes) {
                        numOfBytes = byteArrayLen - offset;
                    }
                    numOfBytesLastPage += numRead;
                }
                this.length += (long)numOfBytesLastPage;
                if (this.length >= 0x4000000000L) {
                    throw new ParseExceptionHuge("document too big > 256 Gbyte");
                }
                ++currentPage;
            }
            if (numOfBytesLastPage < 0x40000000) {
                int lastPageIndex = buffers.size() - 1;
                byte[] lastPage = new byte[numOfBytesLastPage];
                System.arraycopy(buffers.get(lastPageIndex), 0, lastPage, 0, numOfBytesLastPage);
                buffers.set(lastPageIndex, lastPage);
            }
            this.bufferArray = (byte[][])buffers.toArray((T[])new byte[buffers.size()][]);
        }
        finally {
            fis.close();
        }
    }

    @Override
    public final byte byteAt(long index) {
        return this.bufferArray[(int)(index >> 30)][(int)(index & 0x3FFFFFFFL)];
    }

    @Override
    public byte[] getBytes(int offset, int len) {
        return null;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    @Override
    public void writeToFileOutputStream(FileOutputStream ost, long os, long len) throws IOException {
        int pageN = (int)(os >> 30);
        int pos = (int)(os & 0x3FFFFFFFL);
        if ((long)pos + len <= 0x40000000L) {
            ost.write(this.bufferArray[pageN], pos, (int)len);
            return;
        }
        ost.write(this.bufferArray[pageN], pos, 0x40000000 - pos);
        ++pageN;
        len -= (long)(0x40000000 - pos);
        while (len > 0x40000000L) {
            ost.write(this.bufferArray[pageN], 0, 0x40000000);
            ++pageN;
            len -= 0x40000000L;
        }
        ost.write(this.bufferArray[pageN], 0, (int)len);
    }

    public void writeToOutputStream(OutputStream ost, long os, long len) throws IOException {
        int pageN = (int)(os >> 30);
        int pos = (int)(os & 0x3FFFFFFFL);
        if ((long)pos + len <= 0x40000000L) {
            ost.write(this.bufferArray[pageN], pos, (int)len);
            return;
        }
        ost.write(this.bufferArray[pageN], pos, 0x40000000 - pos);
        ++pageN;
        len -= (long)(0x40000000 - pos);
        while (len > 0x40000000L) {
            ost.write(this.bufferArray[pageN], 0, 0x40000000);
            ++pageN;
            len -= 0x40000000L;
        }
        ost.write(this.bufferArray[pageN], 0, (int)len);
    }

    public byte[] getFragment(long os, long len) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.writeToOutputStream(bos, os, len);
        return bos.toByteArray();
    }

    @Override
    public void close() {
    }
}

