/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu;

import de.julielab.jcore.pipeline.builder.cli.menu.dialog.IMenuDialog;
import de.julielab.jcore.pipeline.builder.cli.util.PrintLine;
import de.julielab.jcore.pipeline.builder.cli.util.TextIOUtils;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.fit.factory.ConfigurationParameterFactory;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.beryx.textio.BooleanInputReader;
import org.beryx.textio.TextIO;

public class ParameterEditingMenuItem
implements IMenuDialog {
    private ResourceSpecifier descriptor;
    private ConfigurationParameter parameter;

    public ParameterEditingMenuItem(ResourceSpecifier descriptor, ConfigurationParameter parameter) {
        this.descriptor = descriptor;
        this.parameter = parameter;
    }

    public ConfigurationParameter getParameter() {
        return this.parameter;
    }

    public void setParameterValue(TextIO textIO) {
        Object selection;
        String type = this.parameter.getType();
        Stream<PrintLine> lineStream = Stream.of(TextIOUtils.createPrintLine("Please specify a new value for the parameter \"" + this.parameter.getName() + "\".", "header"));
        lineStream = !StringUtils.isBlank(this.parameter.getDescription()) ? Stream.concat(lineStream, Stream.of(TextIOUtils.createPrintLine("The parameter descriptor is:", "header"), TextIOUtils.createPrintLine(this.parameter.getDescription(), "default"))) : Stream.concat(lineStream, Stream.of(TextIOUtils.createPrintLine("No parameter description is available.", "default")));
        TextIOUtils.printLines(lineStream, textIO);
        String prompt = "Specify new parameter value:";
        switch (type) {
            case "Boolean": {
                selection = ((BooleanInputReader)textIO.newBooleanInputReader().withPossibleValues(true, false)).read("Choose new parameter value:");
                break;
            }
            case "Float": {
                selection = textIO.newDoubleInputReader().read(prompt);
                break;
            }
            case "Integer": {
                selection = textIO.newIntInputReader().read(prompt);
                break;
            }
            case "String": {
                selection = textIO.newStringInputReader().read(prompt);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported parameter type: " + type);
            }
        }
        ConfigurationParameterFactory.setParameter(this.descriptor, this.parameter.getName(), selection);
    }

    @Override
    public String getName() {
        return this.parameter.getName();
    }

    public String toString() {
        return this.getName();
    }
}

