/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.exceptions.PipelineIOException;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.cli.main.PipelineBuilderCLI;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.IMenuDialog;
import java.io.File;
import java.io.IOException;
import java.util.Deque;
import org.apache.commons.io.FileUtils;
import org.beryx.textio.BooleanInputReader;
import org.beryx.textio.StringInputReader;
import org.beryx.textio.TextIO;

public class SavePipelineDialog
implements IMenuDialog {
    @Override
    public String getName() {
        return "Save Pipeline";
    }

    public void savePipeline(JCoReUIMAPipeline pipeline, TextIO textIO, Deque<String> path) throws PipelineIOException {
        String destination;
        path.add(this.getName());
        this.printPosition(textIO, path);
        PipelineBuilderCLI.pipelinePath = destination = (String)((StringInputReader)textIO.newStringInputReader().withDefaultValue((Object)PipelineBuilderCLI.pipelinePath)).read(new String[]{"Enter the directory to save the pipeline to."});
        File destinationFile = new File(destination);
        boolean store = true;
        if (destinationFile.exists()) {
            Boolean clear;
            Boolean overwrite = (Boolean)((BooleanInputReader)textIO.newBooleanInputReader().withDefaultValue((Object)false)).withFalseInput("N").withTrueInput("Y").read(new String[]{"The path " + destinationFile.getAbsolutePath() + " exists. Do you wish to store to this directory anyway?"});
            if (overwrite.booleanValue() && (clear = (Boolean)((BooleanInputReader)textIO.newBooleanInputReader().withDefaultValue((Object)false)).withFalseInput("N").withTrueInput("Y").read(new String[]{"Do you want to completely clear the directory \"" + destinationFile.getAbsolutePath() + "\" before storage? Then, all files and subdirectories within it are deleted."})).booleanValue()) {
                try {
                    FileUtils.deleteDirectory((File)destinationFile);
                }
                catch (IOException e) {
                    throw new PipelineIOException((Throwable)e);
                }
            }
            if (!overwrite.booleanValue()) {
                store = false;
                textIO.getTextTerminal().println("Aborting.");
            }
        }
        if (store) {
            textIO.getTextTerminal().println("Storing pipeline. It may take a while to gather all transitive dependencies, please wait...");
            String message = pipeline.store(destinationFile);
            if (message.isEmpty()) {
                textIO.getTextTerminal().println("Saved pipeline to " + destinationFile.getAbsolutePath());
            } else {
                textIO.getTextTerminal().executeWithPropertiesPrefix("warn", t -> t.println(message));
            }
        }
        path.removeLast();
    }

    public String toString() {
        return this.getName();
    }
}

