/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.base.main;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.jcore.pipeline.builder.base.configurations.PipelineBuilderConstants;
import de.julielab.jcore.pipeline.builder.base.exceptions.GithubInformationException;
import de.julielab.jcore.pipeline.builder.base.main.ComponentMetaInformationService;
import de.julielab.jcore.pipeline.builder.base.main.ComponentRepository;
import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.base.main.DescriptionRepositoryStorageMixin;
import de.julielab.jcore.pipeline.builder.base.main.GitHubRepository;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Repositories {
    public static final List<ComponentRepository> JCORE_REPOSITORIES = Arrays.asList(new GitHubRepository("jcore-base", null, "JULIELab"), new GitHubRepository("jcore-projects", null, "JULIELab"));
    private static final Logger log = LoggerFactory.getLogger(Repositories.class);
    private static List<ComponentRepository> activeRepositories = new ArrayList<ComponentRepository>();

    private Repositories() {
    }

    public static List<ComponentRepository> loadActiveRepositories() {
        File repositoriesFile = new File(PipelineBuilderConstants.JcoreMeta.LOCAL_STORAGE + File.separator + "repositories.json");
        ObjectMapper om = new ObjectMapper();
        try {
            if (repositoriesFile.exists()) {
                activeRepositories = new ArrayList<ComponentRepository>(Arrays.asList((ComponentRepository[])om.readValue(repositoriesFile, ComponentRepository[].class)));
            }
        }
        catch (IOException e) {
            log.error("Could not load available repositories: ", (Throwable)e);
        }
        return activeRepositories;
    }

    public static Stream<ComponentRepository> getRepositories() {
        return Repositories.getRepositories(null);
    }

    public static Stream<ComponentRepository> getRepositories(Predicate<ComponentRepository> filter) {
        if (filter == null) {
            return activeRepositories.stream();
        }
        return activeRepositories.stream().filter(filter);
    }

    public static void addRepositories(ComponentRepository ... repositories) throws IOException {
        activeRepositories.addAll(Arrays.asList(repositories));
        Repositories.saveRepositoryConfiguration();
    }

    public static void saveRepositoryConfiguration() throws IOException {
        File repositoriesFile = new File(PipelineBuilderConstants.JcoreMeta.LOCAL_STORAGE + File.separator + "repositories.json");
        ObjectMapper om = new ObjectMapper();
        om.writeValue((OutputStream)new FileOutputStream(repositoriesFile), activeRepositories);
    }

    public static File getMetaFile(ComponentRepository repository) {
        return Repositories.getMetaFile(repository.getName(), repository.getVersion());
    }

    public static File getMetaFile(String repositoryName, String repositoryVersion) {
        return new File(new StringJoiner(File.separator).add(PipelineBuilderConstants.JcoreMeta.LOCAL_STORAGE).add(repositoryName).add(repositoryVersion).add("componentlist.json").toString());
    }

    public static void saveMetaInformationToDisk(ComponentRepository repository) throws GithubInformationException {
        try {
            File metaFile = Repositories.getMetaFile(repository);
            metaFile.getParentFile().mkdirs();
            if (!metaFile.createNewFile()) {
                metaFile.delete();
                metaFile.createNewFile();
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_ABSENT);
            mapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
            mapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_EMPTY);
            mapper.addMixIn(Description.class, DescriptionRepositoryStorageMixin.class);
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            mapper.writeValue((Writer)FileUtilities.getWriterToFile((File)metaFile), ComponentMetaInformationService.getInstance().getMetaInformation(repository));
        }
        catch (IOException e) {
            throw new GithubInformationException(e);
        }
    }

    public boolean hasComponentListMetaFile(ComponentRepository repository) {
        return Repositories.getMetaFile(repository).exists();
    }

    public static void deleteComponentList(String repositoryName, String version) {
        File metaFile = Repositories.getMetaFile(repositoryName, version);
        if (metaFile.exists()) {
            Stream.of(metaFile.getParentFile().listFiles()).forEach(File::delete);
            metaFile.getParentFile().delete();
        }
    }

    static {
        File localdir = new File(PipelineBuilderConstants.JcoreMeta.LOCAL_STORAGE);
        if (!localdir.exists()) {
            localdir.mkdirs();
        }
    }
}

