/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.base.main;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.java.utilities.classpath.JarLoader;
import de.julielab.jcore.pipeline.builder.base.PipelineParameterChecker;
import de.julielab.jcore.pipeline.builder.base.exceptions.PipelineIOException;
import de.julielab.jcore.pipeline.builder.base.main.CPE;
import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.base.main.MetaDescription;
import de.julielab.jcore.pipeline.builder.base.main.MetaDescriptionPipelineStorageMixin;
import de.julielab.utilities.aether.AetherUtilities;
import de.julielab.utilities.aether.MavenArtifact;
import de.julielab.utilities.aether.MavenException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.impl.AnalysisEngineDescription_impl;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.metadata.FixedFlow;
import org.apache.uima.analysis_engine.metadata.FlowConstraints;
import org.apache.uima.analysis_engine.metadata.impl.FixedFlow_impl;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.MetaDataObject;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.eclipse.aether.artifact.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class JCoReUIMAPipeline {
    public static final String DIR_DESC = "desc";
    public static final String DIR_DESC_ALL = "descAll";
    public static final String DIR_LIB = "lib";
    public static final String DIR_CONF = "config";
    public static final String CPE_AAE_DESC_NAME = "cpeAAE.xml";
    public static final String AGGREGATE_ANALYSIS_ENGINE_WITH_INTEGRATED_DELEGATE_DESCRIPTORS_XML = "AggregateAnalysisEngineWithIntegratedDelegateDescriptors.xml";
    private static final String SERIALIZED_CR_DESCS_FILE = "crDescriptions.json";
    private static final String SERIALIZED_CM_DESCS_FILE = "cmDescriptions.json";
    private static final String SERIALIZED_AE_FLOW_CONTROLLER_DESCS_FILE = "aeFlowControllerDescriptions.json";
    private static final String SERIALIZED_AE_DESCS_FILE = "aeDescriptions.json";
    private static final String SERIALIZED_CC_FLOW_CONTROLLER_DESCS_FILE = "ccFlowControllerDescriptions.json";
    private static final String SERIALIZED_CC_DESCS_FILE = "ccDescriptions.json";
    private static final Logger log = LoggerFactory.getLogger(JCoReUIMAPipeline.class);
    private static final Function<List<Description>, Stream<Import>> tsImportsExtractor = descs -> descs.stream().flatMap(desc -> {
        AnalysisEngineMetaData analysisEngineMetaData = desc.getDescriptorAsAnalysisEngineDescription().getAnalysisEngineMetaData();
        if (analysisEngineMetaData == null) {
            return null;
        }
        TypeSystemDescription typeSystem = analysisEngineMetaData.getTypeSystem();
        if (typeSystem == null) {
            return null;
        }
        return Stream.of(typeSystem.getImports());
    }).filter(Objects::nonNull);
    private final Set<String> filesToDeleteOnSave = new HashSet<String>();
    private MavenArtifact parentPom;
    private Description crDescription;
    private List<Description> aeDelegates;
    private List<Description> cmDelegates = new ArrayList<Description>();
    private List<Description> ccDelegates;
    private Description aeFlowController;
    private Description ccFlowController;
    private AnalysisEngineDescription aaeDesc;
    private AnalysisEngineDescription aaeCmDesc;
    private ResourceCreationSpecifier ccDesc;
    private File loadDirectory;
    private boolean areLibrariesLoaded;

    public JCoReUIMAPipeline(File baseDirectory) {
        this();
        this.setLoadDirectory(baseDirectory);
    }

    public JCoReUIMAPipeline() {
        this.aeDelegates = new ArrayList<Description>();
        this.ccDelegates = new ArrayList<Description>();
    }

    public MavenArtifact getParentPom() {
        return this.parentPom;
    }

    public void setParentPom(MavenArtifact parentPom) {
        this.parentPom = parentPom;
        if ((parentPom.getGroupId() == null || parentPom.getArtifactId() == null || parentPom.getVersion() == null) && parentPom.getFile() != null) {
            parentPom.setCoordinatesFromFile();
        }
    }

    public Stream<Description> getMultipliers() {
        return this.aeDelegates.stream().filter(d -> ((AnalysisEngineDescription)d.getDescriptor()).getAnalysisEngineMetaData().getOperationalProperties().getOutputsNewCASes());
    }

    public Stream<Description> getNonMultiplierAes() {
        return this.aeDelegates.stream().filter(d -> !((AnalysisEngineDescription)d.getDescriptor()).getAnalysisEngineMetaData().getOperationalProperties().getOutputsNewCASes());
    }

    public Description getCrDescription() {
        return this.crDescription;
    }

    public void setCrDescription(Description crDescription) {
        this.avoidNamingCollisions(crDescription);
        this.crDescription = crDescription;
    }

    public AnalysisEngineDescription getAaeDesc() {
        return this.aaeDesc;
    }

    public List<Description> getCcDelegates() {
        return this.ccDelegates;
    }

    public void addCcDesc(Description ccDesc) {
        if (this.ccDelegates.stream().map(Description::getDescriptor).anyMatch(CasConsumerDescription.class::isInstance)) {
            throw new IllegalArgumentException("There is already a consumer represented by a  " + CasConsumerDescription.class.getCanonicalName() + ". Those are deprecated and only one can be used in each pipeline.");
        }
        this.avoidArtifactVersionConflicts(ccDesc);
        this.avoidNamingCollisions(ccDesc);
        this.ccDelegates.add(ccDesc);
    }

    public void store(File directory) throws PipelineIOException {
        this.store(directory, false);
    }

    public void store(File directory, boolean populateLibDir) throws PipelineIOException {
        block59: {
            String message = "";
            if (this.aaeDesc == null && (this.aeDelegates == null || this.aeDelegates.isEmpty()) && this.ccDesc == null && (this.ccDelegates == null || this.ccDelegates.isEmpty()) || this.crDescription == null) {
                message = "This pipeline has either no collection reader or no analysis engines and no consumer. A reader and an analysis engine or a consumer is required to do any work. The pipeline will be stored anyway but will need additional work.";
                log.warn(message);
            }
            try {
                Stream<AnalysisEngineDescription> descStream;
                File descDir = new File(directory.getAbsolutePath() + File.separator + DIR_DESC);
                File descDirAll = new File(directory.getAbsolutePath() + File.separator + DIR_DESC_ALL);
                if (!descDir.exists()) {
                    descDir.mkdirs();
                } else {
                    Stream.of(descDir.listFiles()).forEach(File::delete);
                }
                this.storeAllDescriptors(descDirAll);
                if (this.aeDelegates.stream().anyMatch(Description::isActive)) {
                    descStream = this.aeDelegates.stream().filter(Description::isActive).map(Description::getDescriptorAsAnalysisEngineDescription);
                    this.aaeDesc = this.createAAEWithImportedDelegates(descDir, "AggregateAnalysisEngine", this.aeDelegates, descStream, true, this.aeFlowController);
                } else {
                    this.aaeDesc = null;
                }
                if (this.cmDelegates != null && this.cmDelegates.stream().filter(Description::isActive).count() > 1L) {
                    descStream = this.cmDelegates.stream().filter(Description::isActive).map(Description::getDescriptorAsAnalysisEngineDescription);
                    this.aaeCmDesc = this.createAAEWithImportedDelegates(descDir, "AggregateMultiplier", this.cmDelegates, descStream, true, null);
                }
                if (this.crDescription != null) {
                    File crFile = this.getDescriptorStoragePath(this.crDescription, descDir).toFile();
                    this.crDescription.getDescriptor().setSourceUrl(crFile.toURI().toURL());
                    this.crDescription.getDescriptor().toXML((Writer)FileUtilities.getWriterToFile((File)crFile));
                    this.crDescription.setUimaDescPath(crFile.getName());
                    this.filesToDeleteOnSave.remove(crFile.getName());
                }
                File cmFile = new File(descDir.getAbsolutePath() + File.separator + "AggregateMultiplier.xml");
                if (this.cmDelegates != null && this.cmDelegates.stream().filter(Description::isActive).count() == 1L) {
                    Description cm = this.cmDelegates.stream().filter(Description::isActive).findFirst().get();
                    this.aaeCmDesc = cm.getDescriptorAsAnalysisEngineDescription();
                    cmFile = this.getDescriptorStoragePath(cm, descDir).toFile();
                    cm.getDescriptor().setSourceUrl(cmFile.toURI().toURL());
                    cm.getDescriptorAsAnalysisEngineDescription().toXML((Writer)FileUtilities.getWriterToFile((File)cmFile), true);
                    cm.setUimaDescPath(cmFile.getName());
                    this.filesToDeleteOnSave.remove(cmFile.getName());
                } else if (this.cmDelegates != null && this.cmDelegates.stream().filter(Description::isActive).count() > 1L) {
                    this.aaeCmDesc.getMetaData().setName("JCoRe Multiplier AAE");
                    this.aaeCmDesc.getMetaData().setDescription("This AAE descriptor directly contains the CAS multipliers added through the JCoRe pipeline builder. The AAE serves to bundle all the components together.");
                    this.storeDescriptor((ResourceCreationSpecifier)this.aaeCmDesc, cmFile);
                } else if (cmFile.exists()) {
                    cmFile.delete();
                }
                File aaeFile = new File(descDir.getAbsolutePath() + File.separator + "AggregateAnalysisEngine.xml");
                if (this.aaeDesc != null) {
                    this.aaeDesc.getMetaData().setName("JCoRe Pipeline AAE");
                    this.aaeDesc.getMetaData().setDescription("This AAE descriptor directly contains the analysis engines added through the JCoRe pipeline builder. The AAE serves to bundle all the components together.");
                    this.storeDescriptor((ResourceCreationSpecifier)this.aaeDesc, aaeFile);
                    Stream<AnalysisEngineDescription> descStream2 = this.aeDelegates.stream().filter(Description::isActive).map(Description::getDescriptorAsAnalysisEngineDescription);
                    AnalysisEngineDescription integratedDelegatesAAE = this.createAAEWithIntegratedDelegates(descDirAll, "AggregateAnalysisEngineWithIntegratedDelegateDescriptors", this.aeDelegates, descStream2, true, this.aeFlowController);
                    this.storeDescriptor((ResourceCreationSpecifier)integratedDelegatesAAE, new File(descDirAll.getAbsolutePath() + File.separator + AGGREGATE_ANALYSIS_ENGINE_WITH_INTEGRATED_DELEGATE_DESCRIPTORS_XML));
                } else if (aaeFile.exists()) {
                    aaeFile.delete();
                }
                File ccFile = new File(descDir.getAbsolutePath() + File.separator + "AggregateConsumer.xml");
                if (ccFile.exists()) {
                    ccFile.delete();
                }
                if (this.ccDelegates != null && this.ccDelegates.stream().anyMatch(Description::isActive)) {
                    List activeCCs = this.ccDelegates.stream().filter(Description::isActive).collect(Collectors.toList());
                    for (Description ccDesc : activeCCs) {
                        this.storeCCDescriptor(ccDesc, descDir);
                    }
                    if (activeCCs.size() == 1) {
                        Description activeCCDescription = (Description)activeCCs.get(0);
                        this.ccDesc = (ResourceCreationSpecifier)activeCCDescription.getDescriptor();
                        ccFile = new File(descDir.getAbsolutePath() + File.separator + ((Description)activeCCs.get(0)).getUimaDescPath());
                    } else if (activeCCs.size() > 1) {
                        this.ccDesc = this.createAAEWithImportedDelegates(descDir, "AggregateConsumer", this.ccDelegates, activeCCs.stream().map(Description::getDescriptorAsAnalysisEngineDescription), true, this.ccFlowController);
                        this.ccDesc.getMetaData().setName("JCoRe Consumer AAE");
                        this.ccDesc.getMetaData().setDescription("This consumer AAE descriptor directly contains the CAS consumers added through the JCoRe pipeline builder. The AAE serves to bundle all the components together.");
                        this.storeDescriptor(this.ccDesc, ccFile);
                    }
                }
                this.storeCPE(descDir, cmFile, aaeFile, ccFile);
            }
            catch (IOException | ResourceInitializationException | SAXException e) {
                throw new PipelineIOException(e);
            }
            catch (InvalidXMLException e) {
                e.printStackTrace();
            }
            List<PipelineParameterChecker.MissingComponentConfiguration> missingConfiguration = PipelineParameterChecker.findMissingConfiguration(this);
            File missingConfigFile = new File(directory.getAbsolutePath() + File.separator + "missing_configuration.txt");
            if (missingConfigFile.exists()) {
                missingConfigFile.delete();
            }
            if (!missingConfiguration.isEmpty()) {
                try {
                    log.warn("There are missing configuration items for this pipeline. A list of these items is written to {}.", (Object)missingConfigFile);
                    PipelineParameterChecker.writeMissingConfigurationToFile(missingConfiguration, missingConfigFile);
                }
                catch (IOException e) {
                    log.warn("Could not write the file for missing configuration items", (Throwable)e);
                }
            }
            try (InputStream versionFileStream = this.getClass().getResourceAsStream("/version.txt");){
                if (versionFileStream == null) break block59;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(new BufferedInputStream(versionFileStream)));){
                    String version = br.lines().filter(Predicate.not(String::isBlank)).findAny().get();
                    try (BufferedWriter bw = new BufferedWriter(new FileWriter(directory.getAbsolutePath() + File.separator + "version-pipelinebuilder.txt", StandardCharsets.UTF_8));){
                        bw.write(version);
                        bw.newLine();
                    }
                }
            }
            catch (IOException e) {
                throw new PipelineIOException(e);
            }
        }
        try {
            File libDir = new File(directory.getAbsolutePath() + File.separator + DIR_LIB);
            if (populateLibDir) {
                if (libDir.exists()) {
                    log.debug("Removing all files from the library directory at {}", (Object)libDir);
                    Stream.of(libDir.listFiles()).forEach(File::delete);
                }
                log.debug("Storing all artifact files to {}", (Object)libDir);
                this.storeArtifacts(directory);
            }
        }
        catch (MavenException e) {
            throw new PipelineIOException(e);
        }
        try {
            this.serializeDescriptions(directory, SERIALIZED_CR_DESCS_FILE, this.crDescription);
            this.serializeDescriptions(directory, SERIALIZED_CM_DESCS_FILE, this.cmDelegates);
            this.serializeDescriptions(directory, SERIALIZED_AE_FLOW_CONTROLLER_DESCS_FILE, this.aeFlowController);
            this.serializeDescriptions(directory, SERIALIZED_AE_DESCS_FILE, this.aeDelegates);
            this.serializeDescriptions(directory, SERIALIZED_CC_FLOW_CONTROLLER_DESCS_FILE, this.ccFlowController);
            this.serializeDescriptions(directory, SERIALIZED_CC_DESCS_FILE, this.ccDelegates);
        }
        catch (IOException e) {
            throw new PipelineIOException(e);
        }
        try {
            if (this.loadDirectory != null && this.loadDirectory.getCanonicalPath().equals(directory.getCanonicalPath())) {
                for (String toDelete : this.filesToDeleteOnSave) {
                    File file = new File(directory.getAbsolutePath() + File.separator + DIR_DESC + File.separator + toDelete);
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
        }
        catch (IOException e) {
            throw new PipelineIOException(e);
        }
        if (this.parentPom != null) {
            ObjectMapper om = new ObjectMapper();
            try {
                om.writeValue(Path.of(directory.getAbsolutePath(), "pipelineParentPomSource.json").toFile(), (Object)this.parentPom);
            }
            catch (IOException e) {
                throw new PipelineIOException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeCPE(File descDir, File cmFile, File aaeFile, File ccFile) {
        try {
            File cpeFile;
            File cpeAAEFile;
            block18: {
                block17: {
                    cpeAAEFile = new File(descDir.getAbsolutePath() + File.separator + CPE_AAE_DESC_NAME);
                    cpeFile = new File(descDir.getAbsolutePath() + File.separator + "CPE.xml");
                    if (this.ccDelegates == null) break block17;
                    if (!this.ccDelegates.stream().map(Description::getDescriptor).noneMatch(CasConsumer.class::isInstance)) break block18;
                }
                CPE cpe = new CPE();
                if (this.crDescription != null) {
                    cpe.setCollectionReader(this.crDescription);
                }
                AnalysisEngineDescription cpeAAE = AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])new AnalysisEngineDescription[0]);
                boolean multipleDeploymentAllowed = true;
                cpeAAE.getDelegateAnalysisEngineSpecifiersWithImports().clear();
                if (this.cmDelegates.stream().anyMatch(Description::isActive)) {
                    Import_impl cmImport = new Import_impl();
                    cmImport.setLocation(cmFile.getName());
                    cmImport.setSourceUrl(cmFile.toURI().toURL());
                    cpeAAE.getDelegateAnalysisEngineSpecifiersWithImports().put(this.aaeCmDesc.getMetaData().getName(), cmImport);
                    boolean cmMultipleDeploymentAllowed = this.aaeCmDesc.getAnalysisEngineMetaData().getOperationalProperties().isMultipleDeploymentAllowed();
                    if (!cmMultipleDeploymentAllowed) {
                        log.warn("The CAS multiplier used for the CPE Aggregate Analysis engine does not support multiple deployments. Thus, the whole CPE will basically run singlethreaded.");
                    }
                    multipleDeploymentAllowed &= cmMultipleDeploymentAllowed;
                }
                if (this.aaeDesc != null) {
                    Import_impl aaeImport = new Import_impl();
                    aaeImport.setLocation(aaeFile.getName());
                    aaeImport.setSourceUrl(aaeFile.toURI().toURL());
                    cpeAAE.getDelegateAnalysisEngineSpecifiersWithImports().put(this.aaeDesc.getMetaData().getName(), aaeImport);
                    boolean aaeMultipleDeploymentAllowed = this.aaeDesc.getAnalysisEngineMetaData().getOperationalProperties().isMultipleDeploymentAllowed();
                    if (!aaeMultipleDeploymentAllowed) {
                        log.warn("The aggregate collecting the actual analysis engines used for the CPE Aggregate Analysis engine does not support multiple deployments. Thus, the whole CPE will basically run singlethreaded.");
                    }
                    multipleDeploymentAllowed &= aaeMultipleDeploymentAllowed;
                }
                if (this.ccDelegates != null && this.ccDelegates.stream().anyMatch(Description::isActive)) {
                    Import_impl ccImport = new Import_impl();
                    ccImport.setLocation(ccFile.getName());
                    ccImport.setSourceUrl(ccFile.toURI().toURL());
                    cpeAAE.getDelegateAnalysisEngineSpecifiersWithImports().put(this.ccDesc.getMetaData().getName(), ccImport);
                    boolean ccMultipleDeploymentAllowed = this.ccDesc instanceof AnalysisEngineDescription ? ((AnalysisEngineDescription)this.ccDesc).getAnalysisEngineMetaData().getOperationalProperties().isMultipleDeploymentAllowed() : ((CasConsumerDescription)this.ccDesc).getCasConsumerMetaData().getOperationalProperties().isMultipleDeploymentAllowed();
                    if (!ccMultipleDeploymentAllowed) {
                        log.warn("The consumer (potentially an aggregate) used for the CPE Aggregate Analysis engine does not support multiple deployments. Thus, the whole CPE will basically run singlethreaded.");
                    }
                    multipleDeploymentAllowed &= ccMultipleDeploymentAllowed;
                }
                if (!multipleDeploymentAllowed) {
                    log.warn("The sole AggregateAnalysisEngine created for the CPE cannot allow multiple deployment because one of its delegate does not. This will render multithreading ineffective.");
                }
                cpeAAE.getAnalysisEngineMetaData().getOperationalProperties().setMultipleDeploymentAllowed(multipleDeploymentAllowed);
                Stream<ResourceCreationSpecifier> descriptorsForFlow = Stream.of(this.aaeCmDesc, this.aaeDesc);
                if (this.ccDelegates != null && this.ccDelegates.stream().anyMatch(Description::isActive)) {
                    descriptorsForFlow = Stream.concat(descriptorsForFlow, Stream.of(this.ccDesc));
                }
                String[] flow = (String[])descriptorsForFlow.filter(Objects::nonNull).map(ResourceCreationSpecifier::getMetaData).map(ResourceMetaData::getName).toArray(String[]::new);
                ((FixedFlow)cpeAAE.getAnalysisEngineMetaData().getFlowConstraints()).setFixedFlow(flow);
                cpeAAE.toXML((Writer)FileUtilities.getWriterToFile((File)cpeAAEFile));
                cpe.setAnalysisEngine(cpeAAEFile.getName(), "CPE AAE");
                CpeCasProcessor[] cpeCasProcessorArray = cpe.getDescription().getCpeCasProcessors().getAllCpeCasProcessors();
                int n = cpeCasProcessorArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        CpeDescription cpeDescription = cpe.getDescription();
                        cpeDescription.getCpeCasProcessors().setPoolSize(24);
                        cpeDescription.toXML((Writer)FileUtilities.getWriterToFile((File)cpeFile));
                        return;
                    }
                    CpeCasProcessor casProcessor = cpeCasProcessorArray[n2];
                    casProcessor.setMaxErrorCount(0);
                    casProcessor.setMaxErrorSampleSize(1);
                    ++n2;
                }
            }
            log.warn("Could not store a CPE descriptor because a CasConsumer is included in the pipeline that implements a CasConsumer interface rather than the AnalysisEngine interface. Note that CasConsumers are basically analysis engines since UIMA 2.0 and that there is no downside in using AEs as consumers.");
            if (cpeAAEFile.exists()) {
                cpeAAEFile.delete();
            }
            if (!cpeFile.exists()) return;
            cpeFile.delete();
            return;
        }
        catch (Exception e) {
            log.error("Could not store the CPE descriptor: ", (Throwable)e);
        }
    }

    private AnalysisEngineDescription createAAEWithImportedDelegates(File descDir, String name, List<Description> allDelegates, Stream<AnalysisEngineDescription> aaeElements, boolean filterDeactivated, Description flowControllerDescription) throws ResourceInitializationException, SAXException, IOException, InvalidXMLException, PipelineIOException {
        AnalysisEngineDescription aaeDesc = flowControllerDescription == null || !flowControllerDescription.isActive() ? AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])((AnalysisEngineDescription[])aaeElements.toArray(AnalysisEngineDescription[]::new))) : AnalysisEngineFactory.createEngineDescription((FlowControllerDescription)flowControllerDescription.getDescriptorAsFlowControllerDescriptor(), (AnalysisEngineDescription[])((AnalysisEngineDescription[])aaeElements.toArray(AnalysisEngineDescription[]::new)));
        Map delegatesWithImports = aaeDesc.getDelegateAnalysisEngineSpecifiersWithImports();
        delegatesWithImports.clear();
        ArrayList<String> flowNames = new ArrayList<String>();
        boolean multipleDeploymentAllowed = true;
        for (Description description : allDelegates) {
            boolean currentComponentAllowsMultipleDeployment = description.getDescriptorAsAnalysisEngineDescription().getAnalysisEngineMetaData().getOperationalProperties().isMultipleDeploymentAllowed();
            if (!currentComponentAllowsMultipleDeployment) {
                log.warn("The component {} does not allow multiple deployment. Thus, multiple deployment won't be allowed for the whole AAE with name {}.", (Object)description.getName(), (Object)name);
            }
            multipleDeploymentAllowed &= currentComponentAllowsMultipleDeployment;
            if (!description.isActive() && filterDeactivated) continue;
            Import_impl imp = new Import_impl();
            imp.setLocation(description.getName() + ".xml");
            delegatesWithImports.put(description.getName(), imp);
            File destination = this.getDescriptorStoragePath(description, descDir).toFile();
            description.getDescriptorAsAnalysisEngineDescription().toXML((Writer)FileUtilities.getWriterToFile((File)destination), true);
            flowNames.add(description.getName());
        }
        aaeDesc.setSourceUrl(descDir.toURI().toURL());
        try {
            Optional<Description> pearOpt = allDelegates.stream().filter(d -> d.getMetaDescription().isPear()).findAny();
            if (pearOpt.isPresent()) {
                aaeDesc.getDelegateAnalysisEngineSpecifiers();
            }
        }
        catch (InvalidXMLException e) {
            log.debug("An InvalidXMLException was thrown. This could be due to actually invalid XML but also because a type descriptor import couldn't be found. Loading dependencies.");
            this.addLibrariesToClassPath();
            aaeDesc.getDelegateAnalysisEngineSpecifiers();
        }
        ((FixedFlow)aaeDesc.getAnalysisEngineMetaData().getFlowConstraints()).setFixedFlow(flowNames.toArray(new String[0]));
        aaeDesc.getAnalysisEngineMetaData().setName(name);
        if (!multipleDeploymentAllowed) {
            log.warn("Deactivating multiple deployments for the AAE {} because at least one delegate does not support multiple deployments.", (Object)name);
            aaeDesc.getAnalysisEngineMetaData().getOperationalProperties().setMultipleDeploymentAllowed(false);
        }
        return aaeDesc;
    }

    private AnalysisEngineDescription createAAEWithIntegratedDelegates(File descDir, String name, List<Description> allDelegates, Stream<AnalysisEngineDescription> aaeElements, boolean filterDeactivated, Description flowControllerDescription) throws ResourceInitializationException, SAXException, IOException, InvalidXMLException, PipelineIOException {
        AnalysisEngineDescription aaeDesc = flowControllerDescription == null || !flowControllerDescription.isActive() ? AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])((AnalysisEngineDescription[])aaeElements.toArray(AnalysisEngineDescription[]::new))) : AnalysisEngineFactory.createEngineDescription((FlowControllerDescription)flowControllerDescription.getDescriptorAsFlowControllerDescriptor(), (AnalysisEngineDescription[])((AnalysisEngineDescription[])aaeElements.toArray(AnalysisEngineDescription[]::new)));
        boolean multipleDeploymentAllowed = true;
        for (Description description : allDelegates) {
            boolean currentComponentAllowsMultipleDeployment = description.getDescriptorAsAnalysisEngineDescription().getAnalysisEngineMetaData().getOperationalProperties().isMultipleDeploymentAllowed();
            if (!currentComponentAllowsMultipleDeployment) {
                log.warn("The component {} does not allow multiple deployment. Thus, multiple deployment won't be allowed for the whole AAE with name {}.", (Object)description.getName(), (Object)name);
            }
            multipleDeploymentAllowed &= currentComponentAllowsMultipleDeployment;
        }
        aaeDesc.setSourceUrl(descDir.toURI().toURL());
        try {
            Optional<Description> pearOpt = allDelegates.stream().filter(d -> d.getMetaDescription().isPear()).findAny();
            if (pearOpt.isPresent()) {
                aaeDesc.getDelegateAnalysisEngineSpecifiers();
            }
        }
        catch (InvalidXMLException e) {
            log.debug("An InvalidXMLException was thrown. This could be due to actually invalid XML but also because a type descriptor import couldn't be found. Loading dependencies.");
            this.addLibrariesToClassPath();
            aaeDesc.getDelegateAnalysisEngineSpecifiers();
        }
        aaeDesc.getAnalysisEngineMetaData().setName(name);
        if (!multipleDeploymentAllowed) {
            log.warn("Deactivating multiple deployments for the AAE {} because at least one delegate does not support multiple deployments.", (Object)name);
            aaeDesc.getAnalysisEngineMetaData().getOperationalProperties().setMultipleDeploymentAllowed(false);
        }
        return aaeDesc;
    }

    private void storeAllDescriptors(File descDirAll) throws IOException, SAXException, InvalidXMLException, ResourceInitializationException, PipelineIOException {
        AnalysisEngineDescription aae;
        if (!descDirAll.exists()) {
            descDirAll.mkdirs();
        }
        Stream.of(descDirAll.listFiles()).forEach(File::delete);
        if (this.crDescription != null) {
            this.storeDescriptor((ResourceCreationSpecifier)this.crDescription.getDescriptorAsCollectionReaderDescription(), this.getDescriptorStoragePath(this.crDescription, descDirAll).toFile());
        }
        for (Description cmDelegate : this.cmDelegates) {
            this.storeDescriptor((ResourceCreationSpecifier)cmDelegate.getDescriptorAsAnalysisEngineDescription(), this.getDescriptorStoragePath(cmDelegate, descDirAll).toFile());
        }
        if (this.aeFlowController != null) {
            this.storeDescriptor((ResourceCreationSpecifier)this.aeFlowController.getDescriptorAsFlowControllerDescriptor(), this.getDescriptorStoragePath(this.aeFlowController, descDirAll).toFile());
        }
        for (Description aeDelegate : this.aeDelegates) {
            this.storeDescriptor((ResourceCreationSpecifier)aeDelegate.getDescriptorAsAnalysisEngineDescription(), this.getDescriptorStoragePath(aeDelegate, descDirAll).toFile());
        }
        if (this.ccFlowController != null) {
            this.storeDescriptor((ResourceCreationSpecifier)this.ccFlowController.getDescriptorAsFlowControllerDescriptor(), this.getDescriptorStoragePath(this.ccFlowController, descDirAll).toFile());
        }
        for (Description ccDelegate : this.ccDelegates) {
            this.storeCCDescriptor(ccDelegate, descDirAll);
        }
        if (!this.cmDelegates.isEmpty() && this.cmDelegates.size() > 1) {
            aae = this.createAAEWithImportedDelegates(descDirAll, "AggregateMultiplier", this.cmDelegates, this.cmDelegates.stream().map(Description::getDescriptorAsAnalysisEngineDescription), false, null);
            this.storeDescriptor((ResourceCreationSpecifier)aae, Paths.get(descDirAll.getAbsolutePath(), aae.getMetaData().getName() + ".xml").toFile());
        }
        if (!this.aeDelegates.isEmpty() && this.aeDelegates.size() > 1) {
            aae = this.createAAEWithImportedDelegates(descDirAll, "AggregateAnalysisEngine", this.aeDelegates, this.aeDelegates.stream().map(Description::getDescriptorAsAnalysisEngineDescription), false, this.aeFlowController);
            this.storeDescriptor((ResourceCreationSpecifier)aae, Paths.get(descDirAll.getAbsolutePath(), aae.getMetaData().getName() + ".xml").toFile());
        }
        if (!this.ccDelegates.isEmpty() && this.ccDelegates.size() > 1) {
            aae = this.createAAEWithImportedDelegates(descDirAll, "AggregateConsumer", this.ccDelegates, this.ccDelegates.stream().map(Description::getDescriptorAsAnalysisEngineDescription), false, this.ccFlowController);
            this.storeDescriptor((ResourceCreationSpecifier)aae, Paths.get(descDirAll.getAbsolutePath(), aae.getMetaData().getName() + ".xml").toFile());
        }
    }

    private void storeDescriptor(ResourceCreationSpecifier spec, File path) throws IOException, SAXException {
        spec.setSourceUrl(path.toURI().toURL());
        try (BufferedWriter writer = FileUtilities.getWriterToFile((File)path);){
            if (spec instanceof AnalysisEngineDescription) {
                ((AnalysisEngineDescription)spec).toXML((Writer)writer, true);
            } else {
                spec.toXML((Writer)writer);
            }
        }
    }

    private Path getDescriptorStoragePath(Description desc, File destinationDir) {
        String filename = desc.getName() + ".xml";
        return Paths.get(destinationDir.getAbsolutePath(), filename);
    }

    private void storeCCDescriptor(Description ccDesc, File descDir) throws SAXException, IOException {
        if (!ccDesc.getName().toLowerCase().contains("writer") && !ccDesc.getName().toLowerCase().contains("consumer")) {
            throw new IllegalStateException("The CAS consumer descriptor " + ccDesc.getName() + " at " + ccDesc.getDescriptor().getSourceUrlString() + " does not specify 'writer' or 'consumer' in its name. By convention, consumers must do this to be recognized as consumer.");
        }
        File ccFile = this.getDescriptorStoragePath(ccDesc, descDir).toFile();
        ccDesc.setUri(ccFile.toURI());
        ccDesc.setUimaDescPath(ccFile.getName());
        if (ccDesc.getDescriptor() instanceof AnalysisEngineDescription) {
            ccDesc.getDescriptorAsAnalysisEngineDescription().toXML((Writer)FileUtilities.getWriterToFile((File)ccFile), true);
        } else {
            ccDesc.getDescriptor().toXML((Writer)FileUtilities.getWriterToFile((File)ccFile));
        }
        this.filesToDeleteOnSave.remove(ccFile.getName());
    }

    public void storeArtifacts(File directory) throws MavenException {
        File libDir = new File(directory.getAbsolutePath() + File.separator + DIR_LIB);
        if (!libDir.exists()) {
            libDir.mkdirs();
        }
        Stream<Object> descriptions = Stream.empty();
        if (this.crDescription != null && this.crDescription.getMetaDescription() != null) {
            descriptions = Stream.concat(descriptions, Stream.of(this.crDescription));
        }
        if (this.cmDelegates != null) {
            descriptions = Stream.concat(descriptions, this.cmDelegates.stream().filter(d -> Objects.nonNull(d.getMetaDescription())));
        }
        if (this.aeFlowController != null) {
            descriptions = Stream.concat(descriptions, Stream.of(this.aeFlowController));
        }
        if (this.aeDelegates != null) {
            descriptions = Stream.concat(descriptions, this.aeDelegates.stream().filter(d -> d.getMetaDescription().isPear() == false && Objects.nonNull(d.getMetaDescription())));
        }
        if (this.ccFlowController != null) {
            descriptions = Stream.concat(descriptions, Stream.of(this.ccFlowController));
        }
        if (this.ccDelegates != null) {
            descriptions = Stream.concat(descriptions, this.ccDelegates.stream().filter(d -> Objects.nonNull(d.getMetaDescription())));
        }
        this.storeArtifactsOfDescriptions(descriptions, libDir);
    }

    private void storeArtifactsOfDescriptions(Stream<Description> descriptions, File libDir) throws MavenException {
        AetherUtilities.storeArtifactsWithDependencies((MavenArtifact)this.parentPom, descriptions.map(d -> d.getMetaDescription().getMavenArtifact()), (File)libDir);
    }

    private void serializeDescriptions(File pipelineStorageDir, String targetFileName, Object descriptions) throws IOException {
        if (!pipelineStorageDir.exists()) {
            pipelineStorageDir.mkdirs();
        }
        File targetFile = new File(pipelineStorageDir.getAbsolutePath() + File.separatorChar + targetFileName);
        ObjectMapper om = new ObjectMapper();
        om.addMixIn(MetaDescription.class, MetaDescriptionPipelineStorageMixin.class);
        om.writeValue((Writer)FileUtilities.getWriterToFile((File)targetFile), descriptions);
    }

    private <T> T deserializeDescriptions(File pipelineStorageDir, String sourceFileName, TypeReference<?> typeReference) throws IOException, ClassNotFoundException {
        File sourceFile = new File(pipelineStorageDir.getAbsolutePath() + File.separatorChar + sourceFileName);
        if (!sourceFile.exists()) {
            return null;
        }
        ObjectMapper om = new ObjectMapper();
        try (BufferedReader reader = FileUtilities.getReaderFromFile((File)sourceFile);){
            Object object = om.readValue((Reader)reader, typeReference);
            return (T)object;
        }
    }

    public File getLoadDirectory() {
        return this.loadDirectory;
    }

    public void setLoadDirectory(File loadDirectory) {
        this.loadDirectory = loadDirectory;
    }

    public JCoReUIMAPipeline load(boolean forEditing) throws PipelineIOException {
        if (this.loadDirectory == null) {
            throw new IllegalStateException("The base directory for the pipeline has not been set, cannot load.");
        }
        if (!this.loadDirectory.exists()) {
            throw new PipelineIOException("The JCoReUIMAPipeline directory " + this.loadDirectory + " does not exist.");
        }
        try {
            File descDir;
            try {
                if (forEditing) {
                    this.crDescription = (Description)this.deserializeDescriptions(this.loadDirectory, SERIALIZED_CR_DESCS_FILE, new TypeReference<Description>(){});
                    this.cmDelegates = (List)this.deserializeDescriptions(this.loadDirectory, SERIALIZED_CM_DESCS_FILE, new TypeReference<List<Description>>(){});
                    this.aeFlowController = (Description)this.deserializeDescriptions(this.loadDirectory, SERIALIZED_AE_FLOW_CONTROLLER_DESCS_FILE, new TypeReference<Description>(){});
                    this.aeDelegates = (List)this.deserializeDescriptions(this.loadDirectory, SERIALIZED_AE_DESCS_FILE, new TypeReference<List<Description>>(){});
                    this.ccFlowController = (Description)this.deserializeDescriptions(this.loadDirectory, SERIALIZED_CC_FLOW_CONTROLLER_DESCS_FILE, new TypeReference<Description>(){});
                    this.ccDelegates = (List)this.deserializeDescriptions(this.loadDirectory, SERIALIZED_CC_DESCS_FILE, new TypeReference<List<Description>>(){});
                }
            }
            catch (ClassNotFoundException e) {
                throw new PipelineIOException(e);
            }
            ObjectMapper om = new ObjectMapper();
            File parentPomFile = Path.of(this.loadDirectory.getAbsolutePath(), "pipelineParentPomSource.json").toFile();
            if (parentPomFile.exists()) {
                this.parentPom = (MavenArtifact)om.readValue(parentPomFile, MavenArtifact.class);
            }
            if (!(descDir = new File(this.loadDirectory.getAbsolutePath() + File.separator + DIR_DESC_ALL)).exists()) {
                File allDescDir = descDir;
                descDir = new File(this.loadDirectory.getAbsolutePath() + File.separator + DIR_DESC);
                log.debug("Directory {} does not exist, falling back to {}", (Object)allDescDir, (Object)descDir);
            }
            if (!descDir.exists()) {
                throw new PipelineIOException("The JCoReUIMAPipeline directory " + this.loadDirectory + " does not have the descriptor sub directory descAll or desc");
            }
            File[] xmlFiles = descDir.listFiles(f -> f.getName().endsWith(".xml"));
            ArrayList<CollectionReaderDescription> crDescs = new ArrayList<CollectionReaderDescription>();
            ArrayList<AnalysisEngineDescription> cmDescs = new ArrayList<AnalysisEngineDescription>();
            ArrayList<AnalysisEngineDescription> aaeCmDescs = new ArrayList<AnalysisEngineDescription>();
            ArrayList<AnalysisEngineDescription> aeDescs = new ArrayList<AnalysisEngineDescription>();
            ArrayList<AnalysisEngineDescription> aaeDescs = new ArrayList<AnalysisEngineDescription>();
            ArrayList<ResourceCreationSpecifier> ccDescs = new ArrayList<ResourceCreationSpecifier>();
            ArrayList<ResourceCreationSpecifier> aaeCcDescs = new ArrayList<ResourceCreationSpecifier>();
            ArrayList<ResourceCreationSpecifier> flowContrDescs = new ArrayList<ResourceCreationSpecifier>();
            for (File xmlFile : xmlFiles) {
                ResourceCreationSpecifier spec;
                block44: {
                    if (xmlFile.getName().equals(CPE_AAE_DESC_NAME) || xmlFile.getName().equals(AGGREGATE_ANALYSIS_ENGINE_WITH_INTEGRATED_DELEGATE_DESCRIPTORS_XML)) continue;
                    XMLParser parser = UIMAFramework.getXMLParser();
                    spec = null;
                    try {
                        spec = (ResourceCreationSpecifier)parser.parseResourceSpecifier(new XMLInputSource(xmlFile));
                    }
                    catch (InvalidXMLException e) {
                        if (!log.isDebugEnabled()) break block44;
                        ArrayList<String> messages = new ArrayList<String>();
                        Throwable cause = e;
                        do {
                            messages.add(cause.getMessage());
                        } while ((cause = cause.getCause()) != null);
                        log.debug("File {} could not be parsed as a UIMA component and is skipped: {}", (Object)xmlFile, (Object)String.join((CharSequence)"; ", messages));
                    }
                }
                if (spec == null) continue;
                spec.setSourceUrl(xmlFile.getAbsoluteFile().toURI().toURL());
                if (spec instanceof CollectionReaderDescription) {
                    crDescs.add((CollectionReaderDescription)spec);
                    continue;
                }
                if (spec instanceof AnalysisEngineDescription) {
                    AnalysisEngineDescription aeDesc = (AnalysisEngineDescription)spec;
                    if (xmlFile.getName().toLowerCase().contains("consumer") || xmlFile.getName().toLowerCase().contains("writer")) {
                        log.debug("Adding the descriptor {} to CAS consumers because of its file name", (Object)xmlFile);
                        if (aeDesc.isPrimitive()) {
                            log.debug("Reading descriptor {} as CAS consumer", (Object)xmlFile);
                            ccDescs.add(spec);
                            continue;
                        }
                        aaeCcDescs.add(spec);
                        continue;
                    }
                    if (aeDesc.getAnalysisEngineMetaData().getOperationalProperties().getOutputsNewCASes()) {
                        log.debug("Reading descriptor {} as CAS multiplier", (Object)xmlFile);
                        if (aeDesc.isPrimitive()) {
                            cmDescs.add(aeDesc);
                            continue;
                        }
                        aaeCmDescs.add(aeDesc);
                        continue;
                    }
                    log.debug("Reading descriptor {} as analysis engine", (Object)xmlFile);
                    if (aeDesc.isPrimitive()) {
                        aeDescs.add(aeDesc);
                        continue;
                    }
                    aaeDescs.add(aeDesc);
                    continue;
                }
                if (spec instanceof CasConsumerDescription) {
                    ccDescs.add(spec);
                    continue;
                }
                if (spec instanceof FlowControllerDescription) {
                    flowContrDescs.add(spec);
                    continue;
                }
                log.debug("Ignoring file " + xmlFile + " because it is no UIMA component descriptor.");
            }
            if (crDescs.isEmpty()) {
                log.warn("There is no CollectionReader descriptor in directory " + descDir.getAbsolutePath() + ". A pipeline without a CollectionReader cannot be run.");
            }
            if (crDescs.size() > 1) {
                throw new PipelineIOException("There are multiple CollectionReader descriptors in directory " + descDir.getAbsolutePath() + ": " + crDescs.stream().map(MetaDataObject::getSourceUrlString).collect(Collectors.joining("\n")));
            }
            long time = System.currentTimeMillis();
            time = System.currentTimeMillis() - time;
            log.debug("Loading of dependencies took {}ms ({}s)", (Object)time, (Object)(time / 1000L));
            if (this.crDescription == null && crDescs != null && !crDescs.isEmpty()) {
                this.crDescription = new Description(((CollectionReaderDescription)crDescs.get(0)).getSourceUrl());
            }
            if (!cmDescs.isEmpty()) {
                this.aaeCmDesc = (AnalysisEngineDescription)cmDescs.get(0);
            }
            if (aaeCmDescs.size() == 1) {
                this.aaeCmDesc = (AnalysisEngineDescription)aaeCmDescs.get(0);
            }
            if (aaeCmDescs.size() > 1) {
                this.setAaeDesc(descDir, cmDescs, aaeCmDescs, "CAS multiplier", desc -> {
                    this.aaeCmDesc = desc;
                });
            }
            if (!flowContrDescs.isEmpty() && this.aeFlowController != null) {
                this.setDescriptorByName(this.aeFlowController, flowContrDescs);
            }
            if (!aeDescs.isEmpty()) {
                this.aaeDesc = (AnalysisEngineDescription)aeDescs.get(0);
            }
            if (aaeDescs.size() == 1) {
                this.aaeDesc = (AnalysisEngineDescription)aaeDescs.get(0);
            }
            if (aeDescs.size() > 1 && aaeDescs.isEmpty()) {
                log.warn("Found analysis engine descriptions but no AAE grouping them together. Creating a new aggregate for grouping. A reorder might be necessary.");
                this.aaeDesc = AnalysisEngineFactory.createEngineDescription(aeDescs, aeDescs.stream().map(ae -> ae.getAnalysisEngineMetaData().getName()).collect(Collectors.toList()), null, null, null);
            }
            if (aaeDescs.size() > 1) {
                this.setAaeDesc(descDir, aeDescs, aaeDescs, "analysis engine", desc -> {
                    this.aaeDesc = desc;
                });
            }
            if (!flowContrDescs.isEmpty() && this.ccFlowController != null) {
                this.setDescriptorByName(this.ccFlowController, flowContrDescs);
            }
            if (!ccDescs.isEmpty()) {
                this.ccDesc = (ResourceCreationSpecifier)ccDescs.get(0);
            }
            if (aaeCcDescs.size() == 1) {
                this.ccDesc = (ResourceCreationSpecifier)aaeCcDescs.get(0);
            }
            if (aaeCcDescs.size() > 1) {
                List<AnalysisEngineDescription> ccAeDescs = ccDescs.stream().map(AnalysisEngineDescription.class::cast).collect(Collectors.toList());
                List<AnalysisEngineDescription> ccAaeDescs = aaeCcDescs.stream().map(AnalysisEngineDescription.class::cast).collect(Collectors.toList());
                this.setAaeDesc(descDir, ccAeDescs, ccAaeDescs, "CAS consumer", desc -> {
                    this.ccDesc = desc;
                });
            }
            try {
                if (this.crDescription != null && !crDescs.isEmpty()) {
                    this.crDescription.setDescriptor((MetaDataObject)crDescs.get(0));
                }
                if (this.aaeCmDesc != null && !this.cmDelegates.isEmpty()) {
                    this.setAaeDescriptors(this.aaeCmDesc, this.cmDelegates, cmDescs, "CAS Multiplier");
                }
                if (this.aaeDesc != null && !this.aeDelegates.isEmpty()) {
                    this.setAaeDescriptors(this.aaeDesc, this.aeDelegates, aeDescs, "Analysis Engine");
                }
                if (this.ccDesc != null && !this.ccDelegates.isEmpty() && this.ccDesc instanceof AnalysisEngineDescription) {
                    this.setAaeDescriptors((AnalysisEngineDescription)this.ccDesc, this.ccDelegates, ccDescs, "CAS Consumer");
                }
            }
            catch (Exception e) {
                log.warn("Could not set descriptor files from the {}/ directory to the serialized meta descriptions. Changes in the descriptors that have not been stored in the meta descriptions won't be available.", (Object)DIR_DESC_ALL, (Object)e);
            }
        }
        catch (IOException | URISyntaxException | ResourceInitializationException | InvalidXMLException e) {
            throw new PipelineIOException(e);
        }
        return this;
    }

    private void setDescriptorByName(Description description, List<ResourceCreationSpecifier> descriptors) {
        String name = description.getName();
        for (ResourceCreationSpecifier spec : descriptors) {
            String descriptorName = spec.getMetaData().getName();
            if (!name.equals(descriptorName)) continue;
            description.setDescriptor((MetaDataObject)spec);
            return;
        }
        throw new IllegalStateException("Tried to find the UIMA descriptor for the description with name '" + name + "' but could not find one. Available descriptor names were: " + descriptors.stream().map(d -> d.getMetaData().getName()).collect(Collectors.joining(", ")));
    }

    private void setAaeDescriptors(AnalysisEngineDescription aae, List<Description> descriptions, List<? extends ResourceCreationSpecifier> loadedDescriptors, String type) throws PipelineIOException, InvalidXMLException {
        if (!aae.isPrimitive()) {
            Map descByName = descriptions.stream().collect(Collectors.toMap(Description::getName, Function.identity()));
            Map specByName = loadedDescriptors.stream().collect(Collectors.toMap(s -> s.getMetaData().getName(), Function.identity()));
            FlowConstraints flowConstraints = aae.getAnalysisEngineMetaData().getFlowConstraints();
            if (!(flowConstraints instanceof FixedFlow)) {
                throw new PipelineIOException(String.format("The %s aggregate does not define a FixedFlow. Only FixedFlow constraints are currently supported.", type));
            }
            FixedFlow flow = (FixedFlow)flowConstraints;
            for (int i = 0; i < flow.getFixedFlow().length; ++i) {
                String component = flow.getFixedFlow()[i];
                ResourceSpecifier descriptor = (ResourceSpecifier)specByName.get(component);
                if (descriptor == null) {
                    this.addLibrariesToClassPath();
                    MetaDataObject metaDataObject = (MetaDataObject)aae.getDelegateAnalysisEngineSpecifiersWithImports().get(component);
                    if (metaDataObject == null) {
                        throw new IllegalStateException("The AAE '" + aae.getMetaData().getName() + "' specifies the flow component '" + component + "' but does not list it as a delegate.");
                    }
                    if (metaDataObject instanceof AnalysisEngineDescription) continue;
                    throw new IllegalStateException("The " + type + " AAE specifies the component key " + component + " but no descriptor loaded from the descAll/ directory has this name. Names in the stored descriptors may not be changed outside of the Pipeline Builder or they can possibly not be loaded any more.");
                }
                if (i >= descriptions.size()) continue;
                if (!descByName.containsKey(component)) {
                    throw new IllegalStateException("The " + type + " AAE specifies the component key " + component + " but no descriptor has this name. The descriptor names and the AAE keys must match.");
                }
                ((Description)descByName.get(component)).setDescriptor((MetaDataObject)descriptor);
            }
            log.debug("For the {} aggregate, the following delegate descriptors were set: {}", (Object)type, (Object)String.join((CharSequence)", ", flow.getFixedFlow()));
            descriptions.stream().filter(d -> d.getName().equals(aae.getMetaData().getName())).findAny().ifPresent(d -> d.setDescriptor((MetaDataObject)aae));
        } else {
            if (descriptions.size() > 1) {
                log.error("The {} is not an aggregate but there are {} descriptions with the following names: {}", new Object[]{type, descriptions.size(), descriptions.stream().map(Description::getName).collect(Collectors.joining(", "))});
            }
            descriptions.get(0).setDescriptor((MetaDataObject)aae);
        }
    }

    private void addLibrariesToClassPath() throws PipelineIOException {
        if (!this.areLibrariesLoaded) {
            log.info("Loading pipeline libraries. This is required to resolve AAE descriptor imports.");
            this.getClasspathElements().forEach(JarLoader::addJarToClassPath);
        }
        this.areLibrariesLoaded = true;
    }

    private void setAaeDesc(File descDir, List<AnalysisEngineDescription> aeDescs, List<AnalysisEngineDescription> aaeDescs, String componentType, Consumer<AnalysisEngineDescription> descSetter) throws InvalidXMLException, PipelineIOException {
        HashSet delegateUris;
        Function<URL, String> url2String = url -> {
            try {
                return new File(url.toString().replaceAll(" ", "%20")).getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        };
        Set aeUris = aeDescs.stream().map(MetaDataObject::getSourceUrl).map(url2String).collect(Collectors.toSet());
        Set aaeUris = aaeDescs.stream().map(MetaDataObject::getSourceUrl).map(url2String).collect(Collectors.toSet());
        try {
            delegateUris = new HashSet();
            for (AnalysisEngineDescription analysisEngineDescription : aaeDescs) {
                delegateUris.addAll(analysisEngineDescription.getDelegateAnalysisEngineSpecifiers().values().stream().map(MetaDataObject::getSourceUrl).map(url2String).collect(Collectors.toList()));
            }
        }
        catch (InvalidXMLException e) {
            log.debug("An InvalidXMLException was thrown while loading descriptors from file. This could be due to actually invalid XML but also because a type descriptor import couldn't be found. Loading dependencies.");
            this.addLibrariesToClassPath();
            delegateUris = new HashSet();
            for (AnalysisEngineDescription aaeDesc3 : aaeDescs) {
                delegateUris.addAll(aaeDesc3.getDelegateAnalysisEngineSpecifiers().values().stream().map(MetaDataObject::getSourceUrl).map(url2String).collect(Collectors.toList()));
            }
        }
        Sets.SetView topAAEs = Sets.difference(aaeUris, delegateUris);
        Sets.SetView setView = Sets.difference(aeUris, delegateUris);
        Sets.SetView delegateAAEs = Sets.difference(aaeUris, (Set)topAAEs);
        aaeDescs.stream().filter(aae -> delegateAAEs.contains(url2String.apply(aae.getSourceUrl()))).forEach(aeDescs::add);
        if (topAAEs.size() > 1) {
            throw new PipelineIOException("There are multiple " + componentType + "s in " + descDir.getAbsolutePath() + " that don't have a common super AAE. The pipeline cannot be built because it is unknown which to use.");
        }
        if (!topAAEs.isEmpty()) {
            String topAAEUri = (String)topAAEs.iterator().next();
            descSetter.accept(aaeDescs.stream().filter(aaeDesc -> ((String)url2String.apply(aaeDesc.getSourceUrl())).equals(topAAEUri)).findAny().get());
            if (!setView.isEmpty()) {
                log.warn("The AAE {} is used for the " + componentType + " part of the pipeline. Primitive Analysis Engines that are no direct or indirect delegate of this AAE will not be run. The following " + componentType + "s are not a part of the AAE: {}", (Object)topAAEUri, (Object)setView);
            }
        } else {
            descSetter.accept(aaeDescs.get(0));
        }
    }

    public List<Description> getAeDelegates() {
        return this.aeDelegates;
    }

    public void addDelegateAe(Description aeDesc) {
        if (!aeDesc.getMetaDescription().isPear().booleanValue()) {
            if (!(aeDesc.getDescriptor() instanceof AnalysisEngineDescription)) {
                throw new IllegalArgumentException("The passed description " + aeDesc + " does not specify an analysis engine description but an instance of " + aeDesc.getDescriptor().getClass().getCanonicalName());
            }
            if (aeDesc.getDescriptorAsAnalysisEngineDescription().getAnalysisEngineMetaData().getOperationalProperties().getOutputsNewCASes()) {
                throw new IllegalArgumentException("The passed description " + aeDesc + " is set to output new CASes, i.e. it is a CAS multiplier. Add it via the appropriate method to the pipeline.");
            }
            this.avoidArtifactVersionConflicts(aeDesc);
        } else {
            AnalysisEngineDescription_impl aaePear = new AnalysisEngineDescription_impl();
            Map delegatesWithImports = aaePear.getDelegateAnalysisEngineSpecifiersWithImports();
            Import_impl imp = new Import_impl();
            File pearDescriptorFile = new File(aeDesc.getLocation());
            imp.setLocation(pearDescriptorFile.toURI().toString());
            delegatesWithImports.put(aeDesc.getName(), imp);
            List<String> flowNames = Collections.singletonList(aeDesc.getName());
            aaePear.getAnalysisEngineMetaData().setFlowConstraints((FlowConstraints)new FixedFlow_impl());
            ((FixedFlow)aaePear.getAnalysisEngineMetaData().getFlowConstraints()).setFixedFlow(flowNames.toArray(new String[0]));
            try {
                aaePear.getDelegateAnalysisEngineSpecifiers();
                aeDesc = aeDesc.clone();
                aeDesc.setDescriptor((MetaDataObject)aaePear);
            }
            catch (CloneNotSupportedException | InvalidXMLException e) {
                e.printStackTrace();
            }
        }
        this.avoidNamingCollisions(aeDesc);
        this.aeDelegates.add(aeDesc);
    }

    private void avoidNamingCollisions(Description desc) {
        Multiset<String> existingDescriptorNames = this.getExistingDescriptorNames();
        int i = 1;
        String basename = desc.getName();
        while (existingDescriptorNames.contains((Object)desc.getName())) {
            desc.setName(basename + " " + i++);
            ((ResourceCreationSpecifier)desc.getDescriptor()).getMetaData().setName(desc.getName());
        }
    }

    public Multiset<String> getExistingDescriptorNames() {
        HashMultiset names = HashMultiset.create();
        if (this.crDescription != null) {
            names.add((Object)this.crDescription.getName());
        }
        this.cmDelegates.stream().map(Description::getName).forEach(arg_0 -> ((Multiset)names).add(arg_0));
        if (this.aeFlowController != null) {
            names.add((Object)this.aeFlowController.getName());
        }
        this.aeDelegates.stream().map(Description::getName).forEach(arg_0 -> ((Multiset)names).add(arg_0));
        if (this.ccFlowController != null) {
            names.add((Object)this.ccFlowController.getName());
        }
        this.ccDelegates.stream().map(Description::getName).forEach(arg_0 -> ((Multiset)names).add(arg_0));
        return names;
    }

    public void addCasMultiplier(Description multiplier) {
        if (!(multiplier.getDescriptor() instanceof AnalysisEngineDescription)) {
            throw new IllegalArgumentException("The passed description " + multiplier + " does not specify an analysis engine description but an instance of " + multiplier.getDescriptor().getClass().getCanonicalName());
        }
        if (!multiplier.getDescriptorAsAnalysisEngineDescription().getAnalysisEngineMetaData().getOperationalProperties().getOutputsNewCASes()) {
            throw new IllegalArgumentException("The passed description " + multiplier + " is set not to output new CASes, i.e. it is a simple analysis engine and not a CAS multiplier. Add it via the appropriate method to the pipeline.");
        }
        this.avoidArtifactVersionConflicts(multiplier);
        this.avoidNamingCollisions(multiplier);
        this.cmDelegates.add(multiplier);
    }

    private void avoidArtifactVersionConflicts(Description description) {
        if (description.getMetaDescription() != null && description.getMetaDescription().getMavenArtifact() != null) {
            MavenArtifact artifact = description.getMetaDescription().getMavenArtifact();
            Optional<MavenArtifact> anyExistingArtifactForComponent = this.getMavenComponentArtifacts().filter(a -> a.getArtifactId().equalsIgnoreCase(artifact.getArtifactId()) && a.getGroupId().equalsIgnoreCase(artifact.getGroupId()) && (a.getClassifier() == null && artifact.getClassifier() == null || a.getClassifier().equalsIgnoreCase(artifact.getClassifier())) && a.getPackaging().equalsIgnoreCase(artifact.getPackaging())).findAny();
            anyExistingArtifactForComponent.ifPresent(mavenArtifact -> description.getMetaDescription().getMavenArtifact().setVersion(mavenArtifact.getVersion()));
        }
    }

    public Stream<File> getClasspathElements() throws PipelineIOException {
        File libDir = null;
        if (this.loadDirectory != null) {
            libDir = new File(this.loadDirectory.getAbsolutePath() + File.separator + DIR_LIB);
        }
        if (!(this.loadDirectory == null || libDir.exists() && libDir.list().length != 0)) {
            try {
                this.storeArtifacts(this.loadDirectory);
            }
            catch (MavenException e) {
                throw new PipelineIOException("Error occurred when trying to store the Maven artifacts to the " + this.loadDirectory.getAbsolutePath() + File.separator + "lib directory. This storage is necessary to return the classpath elements which was requested by calling this method.", e);
            }
        }
        if (this.loadDirectory != null && libDir.exists()) {
            File configJar = new File(this.loadDirectory.getAbsolutePath() + File.separator + DIR_CONF);
            File[] libFiles = libDir.listFiles((dir, name) -> name.endsWith(".jar") || name.endsWith(".zip"));
            Stream<File> libFilesStream = Stream.of(libFiles);
            if (configJar.exists()) {
                libFilesStream = Stream.concat(libFilesStream, Stream.of(configJar));
            }
            return libFilesStream;
        }
        Stream<MavenArtifact> mavenArtifactStream = this.getMavenComponentArtifacts();
        return mavenArtifactStream.flatMap(artifact -> {
            try {
                return AetherUtilities.getDependencies((MavenArtifact)artifact);
            }
            catch (MavenException e) {
                log.error("Maven exception while trying to get transitive dependencies of artifact {}:{}:{}", new Object[]{artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), e});
                return null;
            }
        }).map(Artifact::getFile);
    }

    public Stream<MavenArtifact> getMavenComponentArtifacts() {
        ArrayList<Stream<MavenArtifact>> artifactList = new ArrayList<Stream<MavenArtifact>>();
        Function<Description, MavenArtifact> artifactExtractor = d -> d.getMetaDescription() != null ? d.getMetaDescription().getMavenArtifactCoordinates() : null;
        if (this.crDescription != null) {
            artifactList.add(Stream.of(artifactExtractor.apply(this.crDescription)));
        }
        if (this.cmDelegates != null) {
            artifactList.add(this.cmDelegates.stream().map(artifactExtractor));
        }
        if (this.aeDelegates != null) {
            artifactList.add(this.aeDelegates.stream().map(artifactExtractor));
        }
        if (this.ccDelegates != null) {
            artifactList.add(this.ccDelegates.stream().map(artifactExtractor));
        }
        return artifactList.stream().flatMap(Function.identity()).filter(Objects::nonNull).filter(a -> Objects.nonNull(a.getArtifactId()));
    }

    public void removeComponent(Description description) {
        if (description.equals(this.crDescription)) {
            this.crDescription = null;
        }
        if (this.aeDelegates != null && this.aeDelegates.contains(description)) {
            this.aeDelegates.remove(description);
            this.aaeDesc = null;
        }
        if (this.cmDelegates != null && this.cmDelegates.contains(description)) {
            this.cmDelegates.remove(description);
            this.aaeCmDesc = null;
        }
        if (this.ccDelegates != null && this.ccDelegates.contains(description)) {
            this.ccDelegates.remove(description);
            this.ccDesc = null;
        }
        if (description.getUimaDescPath() != null) {
            this.filesToDeleteOnSave.add(description.getUimaDescPath());
        }
    }

    public String getClassPath() throws PipelineIOException {
        Stream<File> artifactFiles = this.getClasspathElements();
        Stream<String> classpathElements = artifactFiles.map(File::getAbsolutePath);
        return classpathElements.collect(Collectors.joining(File.pathSeparator));
    }

    public AnalysisEngineDescription getAaeCmDesc() {
        return this.aaeCmDesc;
    }

    public ResourceCreationSpecifier getCcDesc() {
        return this.ccDesc;
    }

    public List<Description> getCmDelegates() {
        return this.cmDelegates;
    }

    public AnalysisEngineDescription getCompleteAggregateDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])((AnalysisEngineDescription[])Stream.of(this.aaeCmDesc, this.aaeDesc, (AnalysisEngineDescription)this.ccDesc).filter(Objects::nonNull).toArray(AnalysisEngineDescription[]::new)));
    }

    public void clear() {
        this.crDescription = null;
        if (this.aeDelegates != null) {
            this.aeDelegates.clear();
        }
        if (this.cmDelegates != null) {
            this.cmDelegates.clear();
        }
        this.aaeDesc = null;
        this.aaeCmDesc = null;
        this.ccDesc = null;
        if (this.ccDelegates != null) {
            this.ccDelegates.clear();
        }
        this.loadDirectory = null;
    }

    public Description getAeFlowController() {
        return this.aeFlowController;
    }

    public void setAeFlowController(Description flowControllerDescription) {
        this.avoidNamingCollisions(flowControllerDescription);
        this.aeFlowController = flowControllerDescription;
    }

    public Description getCcFlowController() {
        return this.ccFlowController;
    }

    public void setCcFlowController(Description flowControllerDescription) {
        this.avoidNamingCollisions(flowControllerDescription);
        this.ccFlowController = flowControllerDescription;
    }
}

